//[okhttp](../../../index.md)/[okhttp3](../index.md)/[ConnectionSpec](index.md)/[isCompatible](is-compatible.md)

# isCompatible

[jvm]\
fun [isCompatible](is-compatible.md)(socket: [SSLSocket](https://docs.oracle.com/javase/8/docs/api/javax/net/ssl/SSLSocket.html)): [Boolean](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-boolean/index.html)

Returns `true` if the socket, as currently configured, supports this connection spec. In order for a socket to be compatible the enabled cipher suites and protocols must intersect.

For cipher suites, at least one of the [required cipher suites](cipher-suites.md) must match the socket's enabled cipher suites. If there are no required cipher suites the socket must have at least one cipher suite enabled.

For protocols, at least one of the [required protocols](tls-versions.md) must match the socket's enabled protocols.
