/*
 * Decompiled with CFR 0.152.
 */
package okhttp3.internal;

import java.net.IDN;
import java.net.InetAddress;
import java.util.Locale;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import okhttp3.internal._HostnamesCommonKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 7, 1}, k=2, xi=48, d1={"\u0000\b\n\u0000\n\u0002\u0010\u000e\n\u0000\u001a\f\u0010\u0000\u001a\u0004\u0018\u00010\u0001*\u00020\u0001\u00a8\u0006\u0002"}, d2={"toCanonicalHost", "", "okhttp"})
public final class _HostnamesJvmKt {
    @Nullable
    public static final String toCanonicalHost(@NotNull String $this$toCanonicalHost) {
        Intrinsics.checkNotNullParameter((Object)$this$toCanonicalHost, (String)"<this>");
        String host = $this$toCanonicalHost;
        if (StringsKt.contains$default((CharSequence)host, (CharSequence)":", (boolean)false, (int)2, null)) {
            byte[] byArray = StringsKt.startsWith$default((String)host, (String)"[", (boolean)false, (int)2, null) && StringsKt.endsWith$default((String)host, (String)"]", (boolean)false, (int)2, null) ? _HostnamesCommonKt.decodeIpv6(host, 1, host.length() - 1) : _HostnamesCommonKt.decodeIpv6(host, 0, host.length());
            if (byArray == null) {
                return null;
            }
            byte[] inetAddressByteArray = byArray;
            InetAddress inetAddress = InetAddress.getByAddress(inetAddressByteArray);
            byte[] address = inetAddress.getAddress();
            if (address.length == 16) {
                Intrinsics.checkNotNullExpressionValue((Object)address, (String)"address");
                return _HostnamesCommonKt.inet6AddressToAscii(address);
            }
            if (address.length == 4) {
                return inetAddress.getHostAddress();
            }
            throw new AssertionError((Object)("Invalid IPv6 address: '" + host + '\''));
        }
        try {
            String string = IDN.toASCII(host);
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toASCII(host)");
            String string2 = string;
            Locale locale = Locale.US;
            Intrinsics.checkNotNullExpressionValue((Object)locale, (String)"US");
            String string3 = string2.toLowerCase(locale);
            Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"this as java.lang.String).toLowerCase(locale)");
            String result = string3;
            if (((CharSequence)result).length() == 0) {
                return null;
            }
            return _HostnamesCommonKt.containsInvalidHostnameAsciiCodes(result) ? (String)null : (_HostnamesCommonKt.containsInvalidLabelLengths(result) ? (String)null : result);
        }
        catch (IllegalArgumentException _) {
            return null;
        }
    }
}

