/*
 * Decompiled with CFR 0.152.
 */
package okhttp3;

import java.io.IOException;
import java.net.CookieHandler;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import okhttp3.Cookie;
import okhttp3.CookieJar;
import okhttp3.HttpUrl;
import okhttp3.internal.InternalKtKt;
import okhttp3.internal.Util;
import okhttp3.internal.platform.Platform;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 1, 15}, bv={1, 0, 3}, k=1, d1={"\u00002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0002\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u001e\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00070\u00062\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000bH\u0002J\u0016\u0010\f\u001a\b\u0012\u0004\u0012\u00020\u00070\u00062\u0006\u0010\b\u001a\u00020\tH\u0016J\u001e\u0010\r\u001a\u00020\u000e2\u0006\u0010\b\u001a\u00020\t2\f\u0010\u000f\u001a\b\u0012\u0004\u0012\u00020\u00070\u0006H\u0016R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0010"}, d2={"Lokhttp3/JavaNetCookieJar;", "Lokhttp3/CookieJar;", "cookieHandler", "Ljava/net/CookieHandler;", "(Ljava/net/CookieHandler;)V", "decodeHeaderAsJavaNetCookies", "", "Lokhttp3/Cookie;", "url", "Lokhttp3/HttpUrl;", "header", "", "loadForRequest", "saveFromResponse", "", "cookies", "okhttp-urlconnection"})
public final class JavaNetCookieJar
implements CookieJar {
    private final CookieHandler cookieHandler;

    public void saveFromResponse(@NotNull HttpUrl url, @NotNull List<Cookie> cookies) {
        Intrinsics.checkParameterIsNotNull((Object)url, (String)"url");
        Intrinsics.checkParameterIsNotNull(cookies, (String)"cookies");
        boolean bl = false;
        List cookieStrings = new ArrayList();
        for (Cookie cookie : cookies) {
            cookieStrings.add(InternalKtKt.cookieToString((Cookie)cookie, (boolean)true));
        }
        Map multimap = MapsKt.mapOf((Pair)TuplesKt.to((Object)"Set-Cookie", (Object)cookieStrings));
        try {
            this.cookieHandler.put(url.uri(), multimap);
        }
        catch (IOException e) {
            Platform platform = Platform.Companion.get();
            StringBuilder stringBuilder = new StringBuilder().append("Saving cookies failed for ");
            HttpUrl httpUrl = url.resolve("/...");
            if (httpUrl == null) {
                Intrinsics.throwNpe();
            }
            platform.log(5, stringBuilder.append(httpUrl).toString(), (Throwable)e);
        }
    }

    @NotNull
    public List<Cookie> loadForRequest(@NotNull HttpUrl url) {
        List list;
        Map<String, List<String>> map;
        Intrinsics.checkParameterIsNotNull((Object)url, (String)"url");
        try {
            map = this.cookieHandler.get(url.uri(), MapsKt.emptyMap());
        }
        catch (IOException e) {
            Platform platform = Platform.Companion.get();
            StringBuilder stringBuilder = new StringBuilder().append("Loading cookies failed for ");
            HttpUrl httpUrl = url.resolve("/...");
            if (httpUrl == null) {
                Intrinsics.throwNpe();
            }
            platform.log(5, stringBuilder.append(httpUrl).toString(), (Throwable)e);
            return CollectionsKt.emptyList();
        }
        Map<String, List<String>> cookieHeaders = map;
        List cookies = null;
        Map<String, List<String>> map2 = cookieHeaders;
        Intrinsics.checkExpressionValueIsNotNull(map2, (String)"cookieHeaders");
        Map<String, List<String>> map3 = map2;
        boolean bl = false;
        for (Map.Entry<String, List<String>> entry : map3.entrySet()) {
            Object object = entry;
            boolean bl2 = false;
            String key = object.getKey();
            object = entry;
            bl2 = false;
            List<String> value = object.getValue();
            if (!StringsKt.equals((String)"Cookie", (String)key, (boolean)true) && !StringsKt.equals((String)"Cookie2", (String)key, (boolean)true)) continue;
            List<String> list2 = value;
            Intrinsics.checkExpressionValueIsNotNull(list2, (String)"value");
            object = list2;
            bl2 = false;
            if (!(!object.isEmpty())) continue;
            for (String header : value) {
                if (cookies == null) {
                    cookies = new ArrayList();
                }
                String string = header;
                Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"header");
                cookies.addAll((Collection)this.decodeHeaderAsJavaNetCookies(url, string));
            }
        }
        if (cookies != null) {
            List list3 = Collections.unmodifiableList(cookies);
            list = list3;
            Intrinsics.checkExpressionValueIsNotNull(list3, (String)"Collections.unmodifiableList(cookies)");
        } else {
            list = CollectionsKt.emptyList();
        }
        return list;
    }

    private final List<Cookie> decodeHeaderAsJavaNetCookies(HttpUrl url, String header) {
        boolean bl = false;
        List result = new ArrayList();
        int pos = 0;
        int limit = header.length();
        int pairEnd = 0;
        while (pos < limit) {
            String value;
            String name;
            pairEnd = Util.delimiterOffset((String)header, (int)pos, (int)limit, (String)";,");
            int equalsSign = Util.delimiterOffset((String)header, (int)pos, (int)pairEnd, (char)'=');
            String string = name = Util.trimSubstring((String)header, (int)pos, (int)equalsSign);
            Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"name");
            if (StringsKt.startsWith$default((String)string, (String)"$", (boolean)false, (int)2, null)) {
                pos = pairEnd + 1;
                continue;
            }
            String string2 = value = equalsSign < pairEnd ? Util.trimSubstring((String)header, (int)(equalsSign + 1), (int)pairEnd) : "";
            Intrinsics.checkExpressionValueIsNotNull((Object)string2, (String)"value");
            if (StringsKt.startsWith$default((String)string2, (String)"\"", (boolean)false, (int)2, null) && StringsKt.endsWith$default((String)value, (String)"\"", (boolean)false, (int)2, null)) {
                String string3 = value;
                int n = 1;
                int n2 = value.length() - 1;
                boolean bl2 = false;
                String string4 = string3.substring(n, n2);
                Intrinsics.checkExpressionValueIsNotNull((Object)string4, (String)"(this as java.lang.Strin\u2026ing(startIndex, endIndex)");
                value = string4;
            }
            Cookie.Builder builder = new Cookie.Builder().name(name);
            String string5 = value;
            Intrinsics.checkExpressionValueIsNotNull((Object)string5, (String)"value");
            result.add(builder.value(string5).domain(url.host()).build());
            pos = pairEnd + 1;
        }
        return result;
    }

    public JavaNetCookieJar(@NotNull CookieHandler cookieHandler) {
        Intrinsics.checkParameterIsNotNull((Object)cookieHandler, (String)"cookieHandler");
        this.cookieHandler = cookieHandler;
    }
}

