/*
 * Decompiled with CFR 0.152.
 */
package okhttp3.internal.http;

import java.text.DateFormat;
import java.text.ParsePosition;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Locale;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.internal.Intrinsics;
import okhttp3.internal.Util;
import okhttp3.internal.http.HttpDate;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 1, 15}, bv={1, 0, 3}, k=1, d1={"\u00005\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u0011\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010\t\n\u0000\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0002*\u0001\r\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u000e\u0010\u000f\u001a\u00020\b2\u0006\u0010\u0010\u001a\u00020\u0011J\u0010\u0010\u0012\u001a\u0004\u0018\u00010\u00112\u0006\u0010\u0010\u001a\u00020\bR\u0018\u0010\u0003\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\u00050\u0004X\u0082\u0004\u00a2\u0006\u0004\n\u0002\u0010\u0006R\u0016\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\b0\u0004X\u0082\u0004\u00a2\u0006\u0004\n\u0002\u0010\tR\u000e\u0010\n\u001a\u00020\u000bX\u0086T\u00a2\u0006\u0002\n\u0000R\u0010\u0010\f\u001a\u00020\rX\u0082\u0004\u00a2\u0006\u0004\n\u0002\u0010\u000e\u00a8\u0006\u0013"}, d2={"Lokhttp3/internal/http/HttpDate;", "", "()V", "BROWSER_COMPATIBLE_DATE_FORMATS", "", "Ljava/text/DateFormat;", "[Ljava/text/DateFormat;", "BROWSER_COMPATIBLE_DATE_FORMAT_STRINGS", "", "[Ljava/lang/String;", "MAX_DATE", "", "STANDARD_DATE_FORMAT", "okhttp3/internal/http/HttpDate$STANDARD_DATE_FORMAT$1", "Lokhttp3/internal/http/HttpDate$STANDARD_DATE_FORMAT$1;", "format", "value", "Ljava/util/Date;", "parse", "okhttp"})
public final class HttpDate {
    public static final long MAX_DATE = 253402300799999L;
    private static final STANDARD_DATE_FORMAT.1 STANDARD_DATE_FORMAT;
    private static final String[] BROWSER_COMPATIBLE_DATE_FORMAT_STRINGS;
    private static final DateFormat[] BROWSER_COMPATIBLE_DATE_FORMATS;
    public static final HttpDate INSTANCE;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Nullable
    public final Date parse(@NotNull String value) {
        Intrinsics.checkParameterIsNotNull((Object)value, (String)"value");
        CharSequence charSequence = value;
        boolean bl = false;
        if (charSequence.length() == 0) {
            return null;
        }
        boolean bl2 = false;
        if (bl2) {
            return null;
        }
        ParsePosition position = new ParsePosition(0);
        Date result = ((DateFormat)STANDARD_DATE_FORMAT.get()).parse(value, position);
        if (position.getIndex() == value.length()) {
            return result;
        }
        String[] stringArray = BROWSER_COMPATIBLE_DATE_FORMAT_STRINGS;
        boolean bl3 = false;
        boolean bl4 = false;
        synchronized (stringArray) {
            boolean bl5 = false;
            int n = 0;
            int n2 = BROWSER_COMPATIBLE_DATE_FORMAT_STRINGS.length;
            while (true) {
                void i;
                if (n >= n2) {
                    Unit unit = Unit.INSTANCE;
                    return null;
                }
                DateFormat format = BROWSER_COMPATIBLE_DATE_FORMATS[i];
                if (format == null) {
                    SimpleDateFormat simpleDateFormat = new SimpleDateFormat(BROWSER_COMPATIBLE_DATE_FORMAT_STRINGS[i], Locale.US);
                    boolean bl6 = false;
                    boolean bl7 = false;
                    SimpleDateFormat $this$apply = simpleDateFormat;
                    boolean bl8 = false;
                    $this$apply.setTimeZone(Util.UTC);
                    HttpDate.BROWSER_COMPATIBLE_DATE_FORMATS[i] = format = (DateFormat)simpleDateFormat;
                }
                position.setIndex(0);
                result = format.parse(value, position);
                if (position.getIndex() != 0) {
                    return result;
                }
                ++i;
            }
        }
    }

    @NotNull
    public final String format(@NotNull Date value) {
        Intrinsics.checkParameterIsNotNull((Object)value, (String)"value");
        String string = ((DateFormat)STANDARD_DATE_FORMAT.get()).format(value);
        Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"STANDARD_DATE_FORMAT.get().format(value)");
        return string;
    }

    private HttpDate() {
    }

    static {
        HttpDate httpDate;
        INSTANCE = httpDate = new HttpDate();
        STANDARD_DATE_FORMAT = new ThreadLocal<DateFormat>(){

            @NotNull
            protected DateFormat initialValue() {
                SimpleDateFormat simpleDateFormat = new SimpleDateFormat("EEE, dd MMM yyyy HH:mm:ss 'GMT'", Locale.US);
                boolean bl = false;
                boolean bl2 = false;
                SimpleDateFormat $this$apply = simpleDateFormat;
                boolean bl3 = false;
                $this$apply.setLenient(false);
                $this$apply.setTimeZone(Util.UTC);
                return simpleDateFormat;
            }
        };
        BROWSER_COMPATIBLE_DATE_FORMAT_STRINGS = new String[]{"EEE, dd MMM yyyy HH:mm:ss zzz", "EEEE, dd-MMM-yy HH:mm:ss zzz", "EEE MMM d HH:mm:ss yyyy", "EEE, dd-MMM-yyyy HH:mm:ss z", "EEE, dd-MMM-yyyy HH-mm-ss z", "EEE, dd MMM yy HH:mm:ss z", "EEE dd-MMM-yyyy HH:mm:ss z", "EEE dd MMM yyyy HH:mm:ss z", "EEE dd-MMM-yyyy HH-mm-ss z", "EEE dd-MMM-yy HH:mm:ss z", "EEE dd MMM yy HH:mm:ss z", "EEE,dd-MMM-yy HH:mm:ss z", "EEE,dd-MMM-yyyy HH:mm:ss z", "EEE, dd-MM-yyyy HH:mm:ss z", "EEE MMM d yyyy HH:mm:ss z"};
        BROWSER_COMPATIBLE_DATE_FORMATS = new DateFormat[BROWSER_COMPATIBLE_DATE_FORMAT_STRINGS.length];
    }
}

