//[okio](../../../index.md)/[okio](../index.md)/[BufferedSink](index.md)

# BufferedSink

expect sealed interface [BufferedSink](index.md) : [Sink](../-sink/index.md)actual interface [BufferedSink](index.md) : [Sink](../-sink/index.md), [WritableByteChannel](https://docs.oracle.com/javase/8/docs/api/java/nio/channels/WritableByteChannel.html)actual interface [BufferedSink](index.md) : [Sink](../-sink/index.md)

A sink that keeps a buffer internally so that callers can do small writes without a performance penalty.

#### Inheritors

| |
|---|
| [Buffer](../-buffer/index.md) |
| [Buffer](../-buffer/index.md) |
| [Buffer](../-buffer/index.md) |

## Properties

| Name | Summary |
|---|---|
| [buffer](buffer.md) | [common]<br>expect abstract val [buffer](buffer.md): [Buffer](../-buffer/index.md)<br>This sink's internal buffer.<br>[jvm, nonJvm]<br>[jvm, nonJvm]<br>actual abstract val [buffer](buffer.md): [Buffer](../-buffer/index.md) |

## Functions

| Name | Summary |
|---|---|
| [buffer](../buffer.md) | [common]<br>fun [Sink](../-sink/index.md).[buffer](../buffer.md)(): [BufferedSink](index.md)<br>Returns a new sink that buffers writes to `sink`. The returned sink will batch writes to `sink`. Use this wherever you write to a sink to get an ergonomic and efficient access to data. |
| [cipherSink](../cipher-sink.md) | [jvm]<br>fun [Sink](../-sink/index.md).[cipherSink](../cipher-sink.md)(cipher: [Cipher](https://docs.oracle.com/javase/8/docs/api/javax/crypto/Cipher.html)): [CipherSink](../-cipher-sink/index.md)<br>Returns a sink that uses [cipher](../cipher-sink.md) to encrypt or decrypt this. |
| [close](../-sink/close.md) | [common]<br>expect abstract override fun [close](../-sink/close.md)()<br>Pushes all buffered bytes to their final destination and releases the resources held by this sink. It is an error to write a closed sink. It is safe to close a sink more than once.<br>[jvm, nonJvm]<br>[jvm, nonJvm]<br>actual abstract override fun [close](../-sink/close.md)() |
| [deflate](../deflate.md) | [zlib]<br>inline fun [Sink](../-sink/index.md#-376010351%2FMain%2F-1717108311).[deflate](../deflate.md)(deflater: [Deflater](../-deflater/index.md) = Deflater()): [DeflaterSink](../-deflater-sink/index.md)<br>Returns an [DeflaterSink](../-deflater-sink/index.md) that DEFLATE-compresses data to this [Sink](../-sink/index.md#-376010351%2FMain%2F-1717108311) while writing. |
| [emit](emit.md) | [common]<br>expect abstract fun [emit](emit.md)(): [BufferedSink](index.md)<br>Writes all buffered data to the underlying sink, if one exists. Like [flush](flush.md), but weaker. Call this before this buffered sink goes out of scope so that its data can reach its destination.<br>[jvm, nonJvm]<br>[jvm, nonJvm]<br>actual abstract fun [emit](emit.md)(): [BufferedSink](index.md) |
| [emitCompleteSegments](emit-complete-segments.md) | [common]<br>expect abstract fun [emitCompleteSegments](emit-complete-segments.md)(): [BufferedSink](index.md)<br>Writes complete segments to the underlying sink, if one exists. Like [flush](flush.md), but weaker. Use this to limit the memory held in the buffer to a single segment. Typically application code will not need to call this: it is only necessary when application code writes directly to this [sink's buffer](../buffer.md).<br>[jvm, nonJvm]<br>[jvm, nonJvm]<br>actual abstract fun [emitCompleteSegments](emit-complete-segments.md)(): [BufferedSink](index.md) |
| [flush](flush.md) | [common]<br>expect abstract override fun [flush](flush.md)()<br>Writes all buffered data to the underlying sink, if one exists. Then that sink is recursively flushed which pushes data as far as possible towards its ultimate destination. Typically that destination is a network socket or file.<br>[jvm, nonJvm]<br>[jvm]<br>actual abstract override fun [flush](flush.md)()<br>[nonJvm]<br>actual abstract fun [flush](../-sink/flush.md)() |
| [gzip](../gzip.md) | [zlib]<br>inline fun [Sink](../-sink/index.md#-376010351%2FMain%2F-1717108311).[gzip](../gzip.md)(): [GzipSink](../-gzip-sink/index.md)<br>Returns a [GzipSink](../-gzip-sink/index.md) that gzip-compresses to this [Sink](../-sink/index.md#-376010351%2FMain%2F-1717108311) while writing. |
| [hashingSink](../hashing-sink.md) | [jvm]<br>fun [Sink](../-sink/index.md).[hashingSink](../hashing-sink.md)(digest: [MessageDigest](https://docs.oracle.com/javase/8/docs/api/java/security/MessageDigest.html)): [HashingSink](../-hashing-sink/index.md)<br>Returns a sink that uses [digest](../hashing-sink.md) to hash this.<br>[jvm]<br>fun [Sink](../-sink/index.md).[hashingSink](../hashing-sink.md)(mac: [Mac](https://docs.oracle.com/javase/8/docs/api/javax/crypto/Mac.html)): [HashingSink](../-hashing-sink/index.md)<br>Returns a sink that uses [mac](../hashing-sink.md) to hash this. |
| [isOpen](../-buffered-source/index.md#1887389732%2FFunctions%2F1033915053) | [jvm]<br>abstract fun [isOpen](../-buffered-source/index.md#1887389732%2FFunctions%2F1033915053)(): [Boolean](https://kotlinlang.org/api/core/kotlin-stdlib/kotlin/-boolean/index.html) |
| [outputStream](output-stream.md) | [jvm]<br>abstract fun [outputStream](output-stream.md)(): [OutputStream](https://docs.oracle.com/javase/8/docs/api/java/io/OutputStream.html)<br>Returns an output stream that writes to this sink. |
| [timeout](../-sink/timeout.md) | [common]<br>expect abstract fun [timeout](../-sink/timeout.md)(): [Timeout](../-timeout/index.md)<br>Returns the timeout for this sink.<br>[jvm, nonJvm]<br>[jvm, nonJvm]<br>actual abstract fun [timeout](../-sink/timeout.md)(): [Timeout](../-timeout/index.md) |
| write | [jvm, nonJvm, common]<br>[jvm]<br>abstract fun [write](index.md#356247273%2FFunctions%2F1033915053)(p0: [ByteBuffer](https://docs.oracle.com/javase/8/docs/api/java/nio/ByteBuffer.html)): [Int](https://kotlinlang.org/api/core/kotlin-stdlib/kotlin/-int/index.html)<br>[jvm, nonJvm]<br>actual abstract fun [write](write.md)(source: [ByteArray](https://kotlinlang.org/api/core/kotlin-stdlib/kotlin/-byte-array/index.html)): [BufferedSink](index.md)<br>[common]<br>expect abstract fun [write](write.md)(byteString: [ByteString](../-byte-string/index.md)): [BufferedSink](index.md)<br>[jvm, nonJvm]<br>actual abstract fun [write](write.md)(byteString: [ByteString](../-byte-string/index.md)): [BufferedSink](index.md)<br>[jvm]<br>actual abstract fun [write](write.md)(source: [Source](../-source/index.md#1331753033%2FMain%2F1033915053), byteCount: [Long](https://kotlinlang.org/api/core/kotlin-stdlib/kotlin/-long/index.html)): [BufferedSink](index.md)<br>[nonJvm]<br>actual abstract fun [write](write.md)(source: [Source](../-source/index.md), byteCount: [Long](https://kotlinlang.org/api/core/kotlin-stdlib/kotlin/-long/index.html)): [BufferedSink](index.md)<br>[jvm, nonJvm]<br>actual abstract fun [write](write.md)(source: [ByteArray](https://kotlinlang.org/api/core/kotlin-stdlib/kotlin/-byte-array/index.html), offset: [Int](https://kotlinlang.org/api/core/kotlin-stdlib/kotlin/-int/index.html), byteCount: [Int](https://kotlinlang.org/api/core/kotlin-stdlib/kotlin/-int/index.html)): [BufferedSink](index.md)<br>[common]<br>expect abstract fun [write](write.md)(byteString: [ByteString](../-byte-string/index.md), offset: [Int](https://kotlinlang.org/api/core/kotlin-stdlib/kotlin/-int/index.html), byteCount: [Int](https://kotlinlang.org/api/core/kotlin-stdlib/kotlin/-int/index.html)): [BufferedSink](index.md)<br>[jvm, nonJvm]<br>actual abstract fun [write](write.md)(byteString: [ByteString](../-byte-string/index.md), offset: [Int](https://kotlinlang.org/api/core/kotlin-stdlib/kotlin/-int/index.html), byteCount: [Int](https://kotlinlang.org/api/core/kotlin-stdlib/kotlin/-int/index.html)): [BufferedSink](index.md)<br>[jvm, nonJvm]<br>actual abstract fun [write](../-sink/write.md)(source: [Buffer](../-buffer/index.md), byteCount: [Long](https://kotlinlang.org/api/core/kotlin-stdlib/kotlin/-long/index.html))<br>[common]<br>expect abstract fun [write](write.md)(source: [ByteArray](https://kotlinlang.org/api/core/kotlin-stdlib/kotlin/-byte-array/index.html)): [BufferedSink](index.md)<br>Like OutputStream.write, this writes a complete byte array to this sink.<br>[common]<br>expect abstract fun [write](write.md)(source: [Source](../-source/index.md), byteCount: [Long](https://kotlinlang.org/api/core/kotlin-stdlib/kotlin/-long/index.html)): [BufferedSink](index.md)<br>Removes `byteCount` bytes from `source` and appends them to this sink.<br>[common]<br>expect abstract fun [write](write.md)(source: [ByteArray](https://kotlinlang.org/api/core/kotlin-stdlib/kotlin/-byte-array/index.html), offset: [Int](https://kotlinlang.org/api/core/kotlin-stdlib/kotlin/-int/index.html), byteCount: [Int](https://kotlinlang.org/api/core/kotlin-stdlib/kotlin/-int/index.html)): [BufferedSink](index.md)<br>Like OutputStream.write, this writes `byteCount` bytes of `source`, starting at `offset`.<br>[common]<br>expect abstract fun [write](../-sink/write.md)(source: [Buffer](../-buffer/index.md), byteCount: [Long](https://kotlinlang.org/api/core/kotlin-stdlib/kotlin/-long/index.html))<br>Removes `byteCount` bytes from `source` and appends them to this. |
| [writeAll](write-all.md) | [common]<br>expect abstract fun [writeAll](write-all.md)(source: [Source](../-source/index.md)): [Long](https://kotlinlang.org/api/core/kotlin-stdlib/kotlin/-long/index.html)<br>Removes all bytes from `source` and appends them to this sink. Returns the number of bytes read which will be 0 if `source` is exhausted.<br>[jvm, nonJvm]<br>[jvm]<br>actual abstract fun [writeAll](write-all.md)(source: [Source](../-source/index.md#1331753033%2FMain%2F1033915053)): [Long](https://kotlinlang.org/api/core/kotlin-stdlib/kotlin/-long/index.html)<br>[nonJvm]<br>actual abstract fun [writeAll](write-all.md)(source: [Source](../-source/index.md)): [Long](https://kotlinlang.org/api/core/kotlin-stdlib/kotlin/-long/index.html) |
| [writeByte](write-byte.md) | [common]<br>expect abstract fun [writeByte](write-byte.md)(b: [Int](https://kotlinlang.org/api/core/kotlin-stdlib/kotlin/-int/index.html)): [BufferedSink](index.md)<br>Writes a byte to this sink.<br>[jvm, nonJvm]<br>[jvm, nonJvm]<br>actual abstract fun [writeByte](write-byte.md)(b: [Int](https://kotlinlang.org/api/core/kotlin-stdlib/kotlin/-int/index.html)): [BufferedSink](index.md) |
| [writeDecimalLong](write-decimal-long.md) | [common]<br>expect abstract fun [writeDecimalLong](write-decimal-long.md)(v: [Long](https://kotlinlang.org/api/core/kotlin-stdlib/kotlin/-long/index.html)): [BufferedSink](index.md)<br>Writes a long to this sink in signed decimal form (i.e., as a string in base 10).<br>[jvm, nonJvm]<br>[jvm, nonJvm]<br>actual abstract fun [writeDecimalLong](write-decimal-long.md)(v: [Long](https://kotlinlang.org/api/core/kotlin-stdlib/kotlin/-long/index.html)): [BufferedSink](index.md) |
| [writeHexadecimalUnsignedLong](write-hexadecimal-unsigned-long.md) | [common]<br>expect abstract fun [writeHexadecimalUnsignedLong](write-hexadecimal-unsigned-long.md)(v: [Long](https://kotlinlang.org/api/core/kotlin-stdlib/kotlin/-long/index.html)): [BufferedSink](index.md)<br>Writes a long to this sink in hexadecimal form (i.e., as a string in base 16).<br>[jvm, nonJvm]<br>[jvm, nonJvm]<br>actual abstract fun [writeHexadecimalUnsignedLong](write-hexadecimal-unsigned-long.md)(v: [Long](https://kotlinlang.org/api/core/kotlin-stdlib/kotlin/-long/index.html)): [BufferedSink](index.md) |
| [writeInt](write-int.md) | [common]<br>expect abstract fun [writeInt](write-int.md)(i: [Int](https://kotlinlang.org/api/core/kotlin-stdlib/kotlin/-int/index.html)): [BufferedSink](index.md)<br>Writes a big-endian int to this sink using four bytes.<br>[jvm, nonJvm]<br>[jvm, nonJvm]<br>actual abstract fun [writeInt](write-int.md)(i: [Int](https://kotlinlang.org/api/core/kotlin-stdlib/kotlin/-int/index.html)): [BufferedSink](index.md) |
| [writeIntLe](write-int-le.md) | [common]<br>expect abstract fun [writeIntLe](write-int-le.md)(i: [Int](https://kotlinlang.org/api/core/kotlin-stdlib/kotlin/-int/index.html)): [BufferedSink](index.md)<br>Writes a little-endian int to this sink using four bytes.<br>[jvm, nonJvm]<br>[jvm, nonJvm]<br>actual abstract fun [writeIntLe](write-int-le.md)(i: [Int](https://kotlinlang.org/api/core/kotlin-stdlib/kotlin/-int/index.html)): [BufferedSink](index.md) |
| [writeLong](write-long.md) | [common]<br>expect abstract fun [writeLong](write-long.md)(v: [Long](https://kotlinlang.org/api/core/kotlin-stdlib/kotlin/-long/index.html)): [BufferedSink](index.md)<br>Writes a big-endian long to this sink using eight bytes.<br>[jvm, nonJvm]<br>[jvm, nonJvm]<br>actual abstract fun [writeLong](write-long.md)(v: [Long](https://kotlinlang.org/api/core/kotlin-stdlib/kotlin/-long/index.html)): [BufferedSink](index.md) |
| [writeLongLe](write-long-le.md) | [common]<br>expect abstract fun [writeLongLe](write-long-le.md)(v: [Long](https://kotlinlang.org/api/core/kotlin-stdlib/kotlin/-long/index.html)): [BufferedSink](index.md)<br>Writes a little-endian long to this sink using eight bytes.<br>[jvm, nonJvm]<br>[jvm, nonJvm]<br>actual abstract fun [writeLongLe](write-long-le.md)(v: [Long](https://kotlinlang.org/api/core/kotlin-stdlib/kotlin/-long/index.html)): [BufferedSink](index.md) |
| [writeShort](write-short.md) | [common]<br>expect abstract fun [writeShort](write-short.md)(s: [Int](https://kotlinlang.org/api/core/kotlin-stdlib/kotlin/-int/index.html)): [BufferedSink](index.md)<br>Writes a big-endian short to this sink using two bytes.<br>[jvm, nonJvm]<br>[jvm, nonJvm]<br>actual abstract fun [writeShort](write-short.md)(s: [Int](https://kotlinlang.org/api/core/kotlin-stdlib/kotlin/-int/index.html)): [BufferedSink](index.md) |
| [writeShortLe](write-short-le.md) | [common]<br>expect abstract fun [writeShortLe](write-short-le.md)(s: [Int](https://kotlinlang.org/api/core/kotlin-stdlib/kotlin/-int/index.html)): [BufferedSink](index.md)<br>Writes a little-endian short to this sink using two bytes.<br>[jvm, nonJvm]<br>[jvm, nonJvm]<br>actual abstract fun [writeShortLe](write-short-le.md)(s: [Int](https://kotlinlang.org/api/core/kotlin-stdlib/kotlin/-int/index.html)): [BufferedSink](index.md) |
| [writeString](write-string.md) | [jvm]<br>abstract fun [writeString](write-string.md)(string: [String](https://kotlinlang.org/api/core/kotlin-stdlib/kotlin/-string/index.html), charset: [Charset](https://docs.oracle.com/javase/8/docs/api/java/nio/charset/Charset.html)): [BufferedSink](index.md)<br>abstract fun [writeString](write-string.md)(string: [String](https://kotlinlang.org/api/core/kotlin-stdlib/kotlin/-string/index.html), beginIndex: [Int](https://kotlinlang.org/api/core/kotlin-stdlib/kotlin/-int/index.html), endIndex: [Int](https://kotlinlang.org/api/core/kotlin-stdlib/kotlin/-int/index.html), charset: [Charset](https://docs.oracle.com/javase/8/docs/api/java/nio/charset/Charset.html)): [BufferedSink](index.md) |
| [writeUtf8](write-utf8.md) | [common]<br>expect abstract fun [writeUtf8](write-utf8.md)(string: [String](https://kotlinlang.org/api/core/kotlin-stdlib/kotlin/-string/index.html)): [BufferedSink](index.md)<br>Encodes `string` in UTF-8 and writes it to this sink.<br>[jvm, nonJvm]<br>[jvm, nonJvm]<br>actual abstract fun [writeUtf8](write-utf8.md)(string: [String](https://kotlinlang.org/api/core/kotlin-stdlib/kotlin/-string/index.html)): [BufferedSink](index.md)<br>[jvm, nonJvm]<br>actual abstract fun [writeUtf8](write-utf8.md)(string: [String](https://kotlinlang.org/api/core/kotlin-stdlib/kotlin/-string/index.html), beginIndex: [Int](https://kotlinlang.org/api/core/kotlin-stdlib/kotlin/-int/index.html), endIndex: [Int](https://kotlinlang.org/api/core/kotlin-stdlib/kotlin/-int/index.html)): [BufferedSink](index.md)<br>[common]<br>expect abstract fun [writeUtf8](write-utf8.md)(string: [String](https://kotlinlang.org/api/core/kotlin-stdlib/kotlin/-string/index.html), beginIndex: [Int](https://kotlinlang.org/api/core/kotlin-stdlib/kotlin/-int/index.html), endIndex: [Int](https://kotlinlang.org/api/core/kotlin-stdlib/kotlin/-int/index.html)): [BufferedSink](index.md)<br>Encodes the characters at `beginIndex` up to `endIndex` from `string` in UTF-8 and writes it to this sink. |
| [writeUtf8CodePoint](write-utf8-code-point.md) | [common]<br>expect abstract fun [writeUtf8CodePoint](write-utf8-code-point.md)(codePoint: [Int](https://kotlinlang.org/api/core/kotlin-stdlib/kotlin/-int/index.html)): [BufferedSink](index.md)<br>Encodes `codePoint` in UTF-8 and writes it to this sink.<br>[jvm, nonJvm]<br>[jvm, nonJvm]<br>actual abstract fun [writeUtf8CodePoint](write-utf8-code-point.md)(codePoint: [Int](https://kotlinlang.org/api/core/kotlin-stdlib/kotlin/-int/index.html)): [BufferedSink](index.md) |