//[okio](../../../index.md)/[okio](../index.md)/[BufferedSource](index.md)/[readDecimalLong](read-decimal-long.md)

# readDecimalLong

[common]\
abstract fun [readDecimalLong](read-decimal-long.md)(): [Long](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-long/index.html)

Reads a long from this source in signed decimal form (i.e., as a string in base 10 with optional leading '-'). This will iterate until a non-digit character is found.

Buffer buffer = new Buffer()\
    .writeUtf8("8675309 -123 00001");\
\
assertEquals(8675309L, buffer.readDecimalLong());\
assertEquals(' ', buffer.readByte());\
assertEquals(-123L, buffer.readDecimalLong());\
assertEquals(' ', buffer.readByte());\
assertEquals(1L, buffer.readDecimalLong());

## Throws

| | |
|---|---|
| [kotlin.NumberFormatException](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-number-format-exception/index.html) | if the found digits do not fit into a long or a decimal number was not present. |

[jvm, nonJvm]\
[jvm, nonJvm]\
abstract fun [readDecimalLong](read-decimal-long.md)(): [Long](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-long/index.html)

## Throws

| | |
|---|---|
| [kotlin.NumberFormatException](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-number-format-exception/index.html) | if the found digits do not fit into a long or a decimal number was not present. |
