/*
 * Decompiled with CFR 0.152.
 */
package retrofit2;

import java.io.IOException;
import okhttp3.Call;
import okhttp3.MediaType;
import okhttp3.Request;
import okhttp3.ResponseBody;
import okio.Buffer;
import okio.BufferedSource;
import okio.ForwardingSource;
import okio.Okio;
import okio.Source;
import retrofit2.Call;
import retrofit2.Callback;
import retrofit2.Converter;
import retrofit2.RequestFactory;
import retrofit2.Response;
import retrofit2.Utils;

final class OkHttpCall<T>
implements Call<T> {
    private final Call.Factory callFactory;
    private final RequestFactory requestFactory;
    private final Object[] args;
    private final Converter<ResponseBody, T> responseConverter;
    private volatile okhttp3.Call rawCall;
    private boolean executed;
    private volatile boolean canceled;

    OkHttpCall(Call.Factory callFactory, RequestFactory requestFactory, Object[] args, Converter<ResponseBody, T> responseConverter) {
        this.callFactory = callFactory;
        this.requestFactory = requestFactory;
        this.args = args;
        this.responseConverter = responseConverter;
    }

    @Override
    public OkHttpCall<T> clone() {
        return new OkHttpCall<T>(this.callFactory, this.requestFactory, this.args, this.responseConverter);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void enqueue(final Callback<T> callback) {
        okhttp3.Call rawCall;
        OkHttpCall okHttpCall = this;
        synchronized (okHttpCall) {
            if (this.executed) {
                throw new IllegalStateException("Already executed.");
            }
            this.executed = true;
        }
        try {
            rawCall = this.createRawCall();
        }
        catch (Throwable t) {
            callback.onFailure(t);
            return;
        }
        if (this.canceled) {
            rawCall.cancel();
        }
        this.rawCall = rawCall;
        rawCall.enqueue(new okhttp3.Callback(){

            private void callFailure(Throwable e) {
                try {
                    callback.onFailure(e);
                }
                catch (Throwable t) {
                    t.printStackTrace();
                }
            }

            private void callSuccess(Response<T> response) {
                try {
                    callback.onResponse(response);
                }
                catch (Throwable t) {
                    t.printStackTrace();
                }
            }

            public void onFailure(Request request, IOException e) {
                this.callFailure(e);
            }

            public void onResponse(okhttp3.Response rawResponse) {
                Response response;
                try {
                    response = OkHttpCall.this.parseResponse(rawResponse);
                }
                catch (Throwable e) {
                    this.callFailure(e);
                    return;
                }
                this.callSuccess(response);
            }
        });
    }

    @Override
    public synchronized boolean isExecuted() {
        return this.executed;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Response<T> execute() throws IOException {
        OkHttpCall okHttpCall = this;
        synchronized (okHttpCall) {
            if (this.executed) {
                throw new IllegalStateException("Already executed.");
            }
            this.executed = true;
        }
        okhttp3.Call rawCall = this.createRawCall();
        if (this.canceled) {
            rawCall.cancel();
        }
        this.rawCall = rawCall;
        return this.parseResponse(rawCall.execute());
    }

    private okhttp3.Call createRawCall() throws IOException {
        okhttp3.Call call = this.callFactory.newCall(this.requestFactory.create(this.args));
        if (call == null) {
            throw new NullPointerException("Call.Factory returned null.");
        }
        return call;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    Response<T> parseResponse(okhttp3.Response rawResponse) throws IOException {
        ResponseBody rawBody = rawResponse.body();
        int code = (rawResponse = rawResponse.newBuilder().body((ResponseBody)new NoContentResponseBody(rawBody.contentType(), rawBody.contentLength())).build()).code();
        if (code < 200 || code >= 300) {
            try {
                ResponseBody bufferedBody = Utils.buffer(rawBody);
                Response response = Response.error(bufferedBody, rawResponse);
                return response;
            }
            finally {
                rawBody.close();
            }
        }
        if (code == 204 || code == 205) {
            return Response.success(null, rawResponse);
        }
        ExceptionCatchingRequestBody catchingBody = new ExceptionCatchingRequestBody(rawBody);
        try {
            T body = this.responseConverter.convert(catchingBody);
            return Response.success(body, rawResponse);
        }
        catch (RuntimeException e) {
            catchingBody.throwIfCaught();
            throw e;
        }
    }

    @Override
    public void cancel() {
        this.canceled = true;
        okhttp3.Call rawCall = this.rawCall;
        if (rawCall != null) {
            rawCall.cancel();
        }
    }

    @Override
    public boolean isCanceled() {
        return this.canceled;
    }

    static final class ExceptionCatchingRequestBody
    extends ResponseBody {
        private final ResponseBody delegate;
        IOException thrownException;

        ExceptionCatchingRequestBody(ResponseBody delegate) {
            this.delegate = delegate;
        }

        public MediaType contentType() {
            return this.delegate.contentType();
        }

        public long contentLength() {
            return this.delegate.contentLength();
        }

        public BufferedSource source() {
            return Okio.buffer((Source)new ForwardingSource((Source)this.delegate.source()){

                public long read(Buffer sink, long byteCount) throws IOException {
                    try {
                        return super.read(sink, byteCount);
                    }
                    catch (IOException e) {
                        ExceptionCatchingRequestBody.this.thrownException = e;
                        throw e;
                    }
                }
            });
        }

        public void close() {
            this.delegate.close();
        }

        void throwIfCaught() throws IOException {
            if (this.thrownException != null) {
                throw this.thrownException;
            }
        }
    }

    static final class NoContentResponseBody
    extends ResponseBody {
        private final MediaType contentType;
        private final long contentLength;

        NoContentResponseBody(MediaType contentType, long contentLength) {
            this.contentType = contentType;
            this.contentLength = contentLength;
        }

        public MediaType contentType() {
            return this.contentType;
        }

        public long contentLength() {
            return this.contentLength;
        }

        public BufferedSource source() {
            throw new IllegalStateException("Cannot read raw response body of a converted body.");
        }
    }
}

