/*
 * Decompiled with CFR 0.152.
 */
package com.squareup.wire;

import com.squareup.wire.WireLogger;
import com.squareup.wire.schema.ProtoType;
import java.util.Set;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import okio.Path;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u00008\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\"\n\u0002\b\u0005\b\u0000\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J \u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u000eH\u0016J\u0018\u0010\u0010\u001a\u00020\n2\u0006\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u000f\u001a\u00020\u000eH\u0016J\u0016\u0010\u0013\u001a\u00020\n2\f\u0010\u0014\u001a\b\u0012\u0004\u0012\u00020\u000e0\u0015H\u0016J\u0016\u0010\u0016\u001a\u00020\n2\f\u0010\u0017\u001a\b\u0012\u0004\u0012\u00020\u000e0\u0015H\u0016J\u0016\u0010\u0018\u001a\u00020\n2\f\u0010\u0018\u001a\b\u0012\u0004\u0012\u00020\u000e0\u0015H\u0016J\u0016\u0010\u0019\u001a\u00020\n2\f\u0010\u0019\u001a\b\u0012\u0004\u0012\u00020\u000e0\u0015H\u0016R\u001a\u0010\u0003\u001a\u00020\u0004X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0005\u0010\u0006\"\u0004\b\u0007\u0010\b\u00a8\u0006\u001a"}, d2={"Lcom/squareup/wire/ConsoleWireLogger;", "Lcom/squareup/wire/WireLogger;", "()V", "quiet", "", "getQuiet", "()Z", "setQuiet", "(Z)V", "artifactHandled", "", "outputPath", "Lokio/Path;", "qualifiedName", "", "targetName", "artifactSkipped", "type", "Lcom/squareup/wire/schema/ProtoType;", "unusedExcludesInTarget", "unusedExcludes", "", "unusedIncludesInTarget", "unusedIncludes", "unusedPrunes", "unusedRoots", "wire-compiler"})
public final class ConsoleWireLogger
implements WireLogger {
    private boolean quiet;

    public final boolean getQuiet() {
        return this.quiet;
    }

    public final void setQuiet(boolean bl) {
        this.quiet = bl;
    }

    public void unusedRoots(@NotNull Set<String> unusedRoots) {
        Intrinsics.checkNotNullParameter(unusedRoots, (String)"unusedRoots");
        if (this.quiet) {
            return;
        }
        System.out.println((Object)StringsKt.trimMargin$default((String)("Unused element in treeShakingRoots:\n      |  " + CollectionsKt.joinToString$default((Iterable)unusedRoots, (CharSequence)"\n  ", null, null, (int)0, null, null, (int)62, null) + "\n      "), null, (int)1, null));
    }

    public void unusedPrunes(@NotNull Set<String> unusedPrunes) {
        Intrinsics.checkNotNullParameter(unusedPrunes, (String)"unusedPrunes");
        if (this.quiet) {
            return;
        }
        System.out.println((Object)StringsKt.trimMargin$default((String)("Unused element in treeShakingRubbish:\n      |  " + CollectionsKt.joinToString$default((Iterable)unusedPrunes, (CharSequence)"\n  ", null, null, (int)0, null, null, (int)62, null) + "\n      "), null, (int)1, null));
    }

    public void unusedIncludesInTarget(@NotNull Set<String> unusedIncludes) {
        Intrinsics.checkNotNullParameter(unusedIncludes, (String)"unusedIncludes");
        if (this.quiet) {
            return;
        }
        System.out.println((Object)StringsKt.trimMargin$default((String)("Unused includes in targets:\n      |  " + CollectionsKt.joinToString$default((Iterable)unusedIncludes, (CharSequence)"\n  ", null, null, (int)0, null, null, (int)62, null) + "\n      "), null, (int)1, null));
    }

    public void unusedExcludesInTarget(@NotNull Set<String> unusedExcludes) {
        Intrinsics.checkNotNullParameter(unusedExcludes, (String)"unusedExcludes");
        if (this.quiet) {
            return;
        }
        System.out.println((Object)StringsKt.trimMargin$default((String)("Unused excludes in targets:\n      |  " + CollectionsKt.joinToString$default((Iterable)unusedExcludes, (CharSequence)"\n  ", null, null, (int)0, null, null, (int)62, null) + "\n      "), null, (int)1, null));
    }

    public void artifactHandled(@NotNull Path outputPath, @NotNull String qualifiedName, @NotNull String targetName) {
        Intrinsics.checkNotNullParameter((Object)outputPath, (String)"outputPath");
        Intrinsics.checkNotNullParameter((Object)qualifiedName, (String)"qualifiedName");
        Intrinsics.checkNotNullParameter((Object)targetName, (String)"targetName");
        if (this.quiet) {
            System.out.println((Object)qualifiedName);
        } else {
            String string = "Writing " + qualifiedName + " to " + outputPath + " (target=" + targetName + ')';
            System.out.println((Object)string);
        }
    }

    public void artifactSkipped(@NotNull ProtoType type, @NotNull String targetName) {
        Intrinsics.checkNotNullParameter((Object)type, (String)"type");
        Intrinsics.checkNotNullParameter((Object)targetName, (String)"targetName");
        System.out.println((Object)("Skipping " + type + " (target=" + targetName + ')'));
    }
}

