/*
 * Decompiled with CFR 0.152.
 */
package com.sshtools.client;

import com.sshtools.common.logger.Log;
import com.sshtools.common.sshd.SshMessage;
import com.sshtools.synergy.util.EncodingUtils;
import java.nio.ByteBuffer;

public class AuthenticationMessage
implements SshMessage {
    byte[] username;
    byte[] servicename;
    byte[] methodname;

    public AuthenticationMessage(String username, String servicename, String methodname) {
        this.username = EncodingUtils.getUTF8Bytes((String)username);
        this.servicename = EncodingUtils.getUTF8Bytes((String)servicename);
        this.methodname = EncodingUtils.getUTF8Bytes((String)methodname);
    }

    public boolean writeMessageIntoBuffer(ByteBuffer buf) {
        buf.put((byte)50);
        buf.putInt(this.username.length);
        buf.put(this.username);
        buf.putInt(this.servicename.length);
        buf.put(this.servicename);
        buf.putInt(this.methodname.length);
        buf.put(this.methodname);
        return true;
    }

    public void messageSent(Long sequenceNo) {
        if (Log.isDebugEnabled()) {
            Log.info((String)("SSH_MSG_USERAUTH_REQUEST sent method=" + EncodingUtils.getUTF8String((byte[])this.methodname) + " username=" + EncodingUtils.getUTF8String((byte[])this.username)), (Object[])new Object[0]);
        }
    }
}

