/*
 * Decompiled with CFR 0.152.
 */
package com.sshtools.client;

import com.sshtools.client.SshClientContext;
import com.sshtools.common.logger.Log;
import com.sshtools.common.permissions.PermissionDeniedException;
import com.sshtools.common.permissions.UnauthorizedException;
import com.sshtools.common.ssh.ChannelOpenException;
import com.sshtools.common.ssh.ConnectionAwareTask;
import com.sshtools.common.ssh.ExecutorOperationSupport;
import com.sshtools.common.ssh.SshConnection;
import com.sshtools.common.ssh.SshException;
import com.sshtools.common.ssh.UnsupportedChannelException;
import com.sshtools.common.util.ByteArrayReader;
import com.sshtools.common.util.ByteArrayWriter;
import com.sshtools.synergy.ssh.ChannelNG;
import com.sshtools.synergy.ssh.Connection;
import com.sshtools.synergy.ssh.ConnectionProtocol;
import com.sshtools.synergy.ssh.ConnectionStateListener;
import com.sshtools.synergy.ssh.ConnectionTaskWrapper;
import com.sshtools.synergy.ssh.TransportProtocol;
import java.io.IOException;

public class ConnectionProtocolClient
extends ConnectionProtocol<SshClientContext> {
    public ConnectionProtocolClient(TransportProtocol<SshClientContext> transport, String username) {
        super(transport, username);
    }

    protected boolean isClient() {
        return true;
    }

    protected void onStart() {
        SshClientContext context = this.getContext();
        this.con = context.getConnectionManager().registerConnection((ConnectionProtocol)this);
        this.addTask(ExecutorOperationSupport.EVENTS, (ConnectionAwareTask)new ConnectionTaskWrapper((SshConnection)this.con, new Runnable(){

            @Override
            public void run() {
                for (ConnectionStateListener connectionStateListener : ConnectionProtocolClient.this.getContext().getStateListeners()) {
                    connectionStateListener.ready((SshConnection)ConnectionProtocolClient.this.con);
                }
            }
        }));
    }

    protected void onStop() {
    }

    public int startLocalForwarding(String addressToBind, int portToBind, String destinationHost, int destinationPort) throws UnauthorizedException, SshException {
        if (Log.isInfoEnabled()) {
            Log.info((String)("Requesting local forwarding on " + addressToBind + ":" + portToBind + " to " + destinationHost + ":" + destinationPort), (Object[])new Object[0]);
        }
        if (!this.getContext().getForwardingPolicy().checkInterfacePermitted((SshConnection)this.con, addressToBind, portToBind)) {
            if (Log.isInfoEnabled()) {
                Log.info((String)("User not permitted to forward on " + addressToBind + ":" + portToBind), (Object[])new Object[0]);
            }
            throw new UnauthorizedException();
        }
        int port = this.getContext().getForwardingManager().startListening(addressToBind, portToBind, this.con, destinationHost, destinationPort);
        if (Log.isInfoEnabled()) {
            Log.info((String)("Local forwarding is now active on local interface " + addressToBind + ":" + portToBind + " forwarding to remote " + destinationHost + ":" + destinationPort), (Object[])new Object[0]);
        }
        return port;
    }

    public void stopLocalForwarding() {
        this.getContext().getForwardingManager().stopForwarding(this.getConnection());
    }

    public void stopLocalForwarding(String addressToBind, int portToBind) {
        this.stopLocalForwarding(addressToBind + ":" + portToBind);
    }

    public void stopLocalForwarding(String key) {
        this.getContext().getForwardingManager().stopForwarding(key, this.getConnection());
    }

    public void stopRemoteForwarding(String addressToBind, int portToBind) throws SshException {
        this.getContext().getForwardingManager().stopRemoteForwarding(addressToBind, portToBind, (ConnectionProtocol)this);
    }

    public void stopRemoteForwarding() throws SshException {
        this.getContext().getForwardingManager().stopRemoteForwarding((ConnectionProtocol)this);
    }

    public int startRemoteForwarding(String addressToBind, int portToBind, String destinationHost, int destinationPort) throws SshException {
        return this.getContext().getForwardingManager().startRemoteForwarding(addressToBind, portToBind, destinationHost, destinationPort, (ConnectionProtocol)this);
    }

    public SshClientContext getContext() {
        return (SshClientContext)this.getTransport().getContext();
    }

    protected boolean processTCPIPCancel(ByteArrayReader bar, ByteArrayWriter msg) throws IOException {
        return false;
    }

    protected boolean processTCPIPForward(ByteArrayReader bar, ByteArrayWriter response) throws IOException {
        return false;
    }

    public String getName() {
        return "ssh-connection";
    }

    protected ChannelNG<SshClientContext> createChannel(String channeltype, Connection<SshClientContext> con) throws UnsupportedChannelException, PermissionDeniedException, ChannelOpenException {
        return this.getContext().getChannelFactory().createChannel(channeltype, con);
    }
}

