/*
 * Decompiled with CFR 0.152.
 */
package com.sshtools.client;

import com.sshtools.client.SshClientContext;
import com.sshtools.common.logger.Log;
import com.sshtools.common.ssh.GlobalRequest;
import com.sshtools.common.ssh.SshConnection;
import com.sshtools.common.ssh.SshException;
import com.sshtools.common.util.ByteArrayReader;
import com.sshtools.common.util.ByteArrayWriter;
import com.sshtools.synergy.ssh.ConnectionProtocol;
import com.sshtools.synergy.ssh.RemoteForwardRequestHandler;
import java.io.IOException;
import java.nio.file.Paths;

public class DefaultRemoteForwardRequestHandler
implements RemoteForwardRequestHandler<SshClientContext> {
    public boolean isHandled(String hostToBind, int portToBind, String destinationHost, int destinationPort, ConnectionProtocol<SshClientContext> conn) {
        if (portToBind == 0 && destinationPort == 0) {
            return false;
        }
        return !Paths.get(hostToBind, new String[0]).isAbsolute() || !Paths.get(hostToBind, new String[0]).isAbsolute();
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public int startRemoteForward(String hostToBind, int portToBind, String destinationHost, int destinationPort, ConnectionProtocol<SshClientContext> conn) throws SshException {
        try (ByteArrayWriter msg = new ByteArrayWriter();){
            msg.writeString(hostToBind);
            msg.writeInt(portToBind);
            GlobalRequest request = new GlobalRequest("tcpip-forward", (SshConnection)conn.getConnection(), msg.toByteArray());
            conn.sendGlobalRequest(request, true);
            request.waitForever();
            if (!request.isSuccess()) throw new SshException("Remote forwarding on interface " + hostToBind + ":" + portToBind + " failed", 14);
            if (request.getData().length > 0) {
                try (ByteArrayReader r = new ByteArrayReader(request.getData());){
                    portToBind = (int)r.readInt();
                }
            }
            if (Log.isInfoEnabled()) {
                Log.info((String)("Remote forwarding is now active on remote interface " + hostToBind + ":" + portToBind + " forwarding to " + destinationHost + ":" + destinationPort), (Object[])new Object[0]);
            }
            int n = portToBind;
            return n;
        }
        catch (IOException e) {
            throw new SshException(5, (Throwable)e);
        }
    }

    public void stopRemoteForward(String hostToBind, int portToBind, String destinationHost, int destinationPort, ConnectionProtocol<SshClientContext> conn) throws SshException {
        block9: {
            try (ByteArrayWriter msg = new ByteArrayWriter();){
                msg.writeString(hostToBind);
                msg.writeInt(portToBind);
                GlobalRequest request = new GlobalRequest("cancel-tcpip-forward", (SshConnection)conn.getConnection(), msg.toByteArray());
                conn.sendGlobalRequest(request, true);
                request.waitForever();
                if (request.isSuccess()) {
                    if (Log.isInfoEnabled()) {
                        Log.info((String)("Remote forwarding cancelled on remote interface " + hostToBind + ":" + portToBind), (Object[])new Object[0]);
                    }
                    break block9;
                }
                throw new SshException("Cancel remote forwarding on interface " + hostToBind + ":" + portToBind + " failed", 14);
            }
            catch (IOException e) {
                throw new SshException(5, (Throwable)e);
            }
        }
    }
}

