/*
 * Decompiled with CFR 0.152.
 */
package com.sshtools.client;

import com.sshtools.client.AuthenticationMessage;
import com.sshtools.client.ClientAuthenticator;
import com.sshtools.client.NotifiedPrompt;
import com.sshtools.client.SimpleClientAuthenticator;
import com.sshtools.client.TransportProtocolClient;
import com.sshtools.common.ssh.SshException;
import com.sshtools.synergy.util.EncodingUtils;
import java.nio.ByteBuffer;
import java.util.Objects;
import java.util.function.Supplier;

public class PasswordAuthenticator
extends SimpleClientAuthenticator {
    private PasswordPrompt password;
    private String lastPassword;

    public static PasswordAuthenticator of(PasswordPrompt password) {
        PasswordAuthenticator pa = new PasswordAuthenticator();
        pa.password = password;
        return pa;
    }

    public PasswordAuthenticator() {
    }

    @Deprecated(since="3.1.0")
    public PasswordAuthenticator(final Supplier<String> supplier) {
        this.password = new PasswordPrompt(){

            @Override
            public String get() {
                return (String)supplier.get();
            }
        };
    }

    public PasswordAuthenticator(String password) {
        this.password = () -> password;
    }

    public PasswordAuthenticator(char[] password) {
        this.password = () -> new String(password);
    }

    public String getPassword() {
        return (String)this.password.get();
    }

    public synchronized void done(boolean success) {
        try {
            super.done(success);
        }
        finally {
            this.password.completed(success, this.lastPassword, this);
        }
    }

    @Override
    public void authenticate(TransportProtocolClient transport, String username) throws SshException {
        this.lastPassword = this.getPassword();
        final byte[] tmp = EncodingUtils.getUTF8Bytes((String)this.lastPassword);
        if (Objects.isNull(tmp)) {
            this.cancel();
            return;
        }
        transport.postMessage(new AuthenticationMessage(username, "ssh-connection", "password"){

            @Override
            public boolean writeMessageIntoBuffer(ByteBuffer buf) {
                super.writeMessageIntoBuffer(buf);
                buf.put((byte)0);
                buf.putInt(tmp.length);
                buf.put(tmp);
                return true;
            }
        });
    }

    @Override
    public String getName() {
        return "password";
    }

    @FunctionalInterface
    public static interface PasswordPrompt
    extends Supplier<String>,
    NotifiedPrompt {
        @Override
        default public void completed(boolean success, String value, ClientAuthenticator authenticator) {
        }
    }
}

