/*
 * Decompiled with CFR 0.152.
 */
package com.sshtools.client;

import com.sshtools.client.PassphrasePrompt;
import com.sshtools.client.PublicKeyAuthenticator;
import com.sshtools.common.publickey.InvalidPassphraseException;
import com.sshtools.common.publickey.SshPrivateKeyFile;
import com.sshtools.common.publickey.SshPrivateKeyFileFactory;
import com.sshtools.common.ssh.components.SshKeyPair;
import com.sshtools.common.ssh.components.SshPublicKey;
import java.io.File;
import java.io.IOException;
import java.nio.file.Path;

public class PrivateKeyFileAuthenticator
extends PublicKeyAuthenticator {
    private SshPrivateKeyFile keyfile;
    private PassphrasePrompt passphrase;
    private SshKeyPair pair;
    private Path path;

    public PrivateKeyFileAuthenticator(File path, String passphrase) throws IOException {
        this(path.toPath(), passphrase);
    }

    public PrivateKeyFileAuthenticator(File path, PassphrasePrompt passphrase) throws IOException {
        this(path.toPath(), passphrase);
    }

    public PrivateKeyFileAuthenticator(Path path, String passphrase) throws IOException {
        this(path);
        this.passphrase = keyinfo -> passphrase;
    }

    public PrivateKeyFileAuthenticator(Path path, PassphrasePrompt passphrase) throws IOException {
        this(path);
        this.passphrase = passphrase;
    }

    public PrivateKeyFileAuthenticator(File path) throws IOException {
        this(path.toPath());
    }

    public PrivateKeyFileAuthenticator(Path path) throws IOException {
        this.keyfile = SshPrivateKeyFileFactory.parse((Path)path);
        this.path = path;
    }

    public String getPassphrase() {
        return this.passphrase.getPasshrase(String.format("Passphrase for %s: ", this.path.getFileName().toString()));
    }

    @Override
    protected SshPublicKey getNextKey() throws IOException {
        try {
            this.pair = this.keyfile.isPassphraseProtected() ? this.keyfile.toKeyPair(this.getPassphrase()) : this.keyfile.toKeyPair(null);
        }
        catch (InvalidPassphraseException | IOException e) {
            throw new IOException(e.getMessage(), e);
        }
        return this.pair.getPublicKey();
    }

    @Override
    protected SshKeyPair getAuthenticatingKey() throws IOException, InvalidPassphraseException {
        return this.pair;
    }

    @Override
    protected boolean hasCredentialsRemaining() {
        return this.pair == null;
    }
}

