/*
 * Decompiled with CFR 0.152.
 */
package com.sshtools.client;

import com.sshtools.client.SshClientContext;
import com.sshtools.common.ssh.SecurityLevel;
import com.sshtools.common.ssh.SshException;
import com.sshtools.common.ssh.components.Digest;
import com.sshtools.common.ssh.components.SshPublicKey;
import com.sshtools.synergy.ssh.SshTransport;
import com.sshtools.synergy.ssh.components.SshKeyExchange;
import java.io.IOException;
import java.math.BigInteger;

public abstract class SshKeyExchangeClient
implements SshKeyExchange<SshClientContext> {
    protected BigInteger secret;
    protected byte[] exchangeHash;
    protected byte[] hostKey;
    protected byte[] signature;
    protected String clientId;
    protected String serverId;
    protected byte[] clientKexInit;
    protected byte[] serverKexInit;
    protected SshPublicKey key;
    protected boolean firstPacketFollows;
    protected boolean useFirstPacket;
    boolean sentNewKeys = false;
    boolean receivedNewKeys = false;
    protected BigInteger e = null;
    protected BigInteger f = null;
    private final SecurityLevel securityLevel;
    final int priority;
    protected SshTransport<SshClientContext> transport;
    String hashAlgorithm;

    public SshKeyExchangeClient(String hashAlgorithm, SecurityLevel securityLevel, int priority) {
        this.hashAlgorithm = hashAlgorithm;
        this.securityLevel = securityLevel;
        this.priority = priority;
    }

    public SecurityLevel getSecurityLevel() {
        return this.securityLevel;
    }

    public int getPriority() {
        return this.priority;
    }

    public void setReceivedNewKeys(boolean receivedNewKeys) {
        this.receivedNewKeys = receivedNewKeys;
    }

    public void setSentNewKeys(boolean sentNewKeys) {
        this.sentNewKeys = sentNewKeys;
    }

    public boolean hasSentNewKeys() {
        return this.sentNewKeys;
    }

    public boolean hasReceivedNewKeys() {
        return this.receivedNewKeys;
    }

    public byte[] getExchangeHash() {
        return this.exchangeHash;
    }

    public byte[] getHostKey() {
        return this.hostKey;
    }

    public BigInteger getSecret() {
        return this.secret;
    }

    public byte[] getSignature() {
        return this.signature;
    }

    public abstract boolean processMessage(byte[] var1) throws SshException, IOException;

    public void reset() {
        this.exchangeHash = null;
        this.hostKey = null;
        this.signature = null;
        this.secret = null;
    }

    public boolean isComplete() {
        return this.sentNewKeys && this.receivedNewKeys;
    }

    public String getHashAlgorithm() {
        return this.hashAlgorithm;
    }

    protected void calculateExchangeHash() throws SshException {
        Digest hash = (Digest)((SshClientContext)this.transport.getContext()).getComponentManager().supportedDigests().getInstance(this.hashAlgorithm);
        hash.putString(this.clientId);
        hash.putString(this.serverId);
        hash.putInt(this.clientKexInit.length);
        hash.putBytes(this.clientKexInit);
        hash.putInt(this.serverKexInit.length);
        hash.putBytes(this.serverKexInit);
        hash.putInt(this.hostKey.length);
        hash.putBytes(this.hostKey);
        hash.putBigInteger(this.e);
        hash.putBigInteger(this.f);
        hash.putBigInteger(this.secret);
        this.exchangeHash = hash.doFinal();
    }
}

