/*
 * Decompiled with CFR 0.152.
 */
package com.sshtools.client.components;

import com.sshtools.client.SshClientContext;
import com.sshtools.client.SshKeyExchangeClient;
import com.sshtools.client.SshKeyExchangeClientFactory;
import com.sshtools.common.logger.Log;
import com.sshtools.common.publickey.SshPublicKeyFileFactory;
import com.sshtools.common.ssh.SecurityLevel;
import com.sshtools.common.ssh.SshException;
import com.sshtools.common.ssh.components.ComponentManager;
import com.sshtools.common.ssh.components.Digest;
import com.sshtools.common.ssh.components.SshPrivateKey;
import com.sshtools.common.ssh.components.SshPublicKey;
import com.sshtools.common.ssh.components.SshRsaPublicKey;
import com.sshtools.common.ssh.components.jce.JCEComponentManager;
import com.sshtools.common.ssh.components.jce.JCEProvider;
import com.sshtools.common.sshd.SshMessage;
import com.sshtools.common.util.ByteArrayReader;
import com.sshtools.common.util.ByteArrayWriter;
import com.sshtools.synergy.ssh.SshTransport;
import com.sshtools.synergy.ssh.components.jce.AbstractKeyExchange;
import java.io.IOException;
import java.math.BigInteger;
import java.nio.ByteBuffer;
import java.security.InvalidAlgorithmParameterException;
import java.security.InvalidKeyException;
import java.security.NoSuchAlgorithmException;
import javax.crypto.Cipher;
import javax.crypto.NoSuchPaddingException;

public class Rsa2048Sha256
extends SshKeyExchangeClient
implements AbstractKeyExchange {
    public static final String RSA_2048_SHA256 = "rsa2048-sha256";
    static final int SSH_MSG_KEXRSA_PUBKEY = 30;
    static final int SSH_MSG_KEXRSA_SECRET = 31;
    static final int SSH_MSG_KEXRSA_DONE = 32;
    Cipher cipher;
    byte[] tk;
    byte[] encryptedSecret;
    private String clientId;
    private String serverId;
    private byte[] clientKexInit;
    private byte[] serverKexInit;
    private byte[] s = new byte[185];

    public Rsa2048Sha256() {
        super("SHA-256", SecurityLevel.STRONG, 2000);
    }

    public String getAlgorithm() {
        return RSA_2048_SHA256;
    }

    public String getProvider() {
        return this.cipher.getProvider().getName();
    }

    public void test() {
        try {
            ComponentManager.getInstance().supportedDigests().getInstance(this.getHashAlgorithm());
            this.initCrypto();
        }
        catch (Throwable e) {
            throw new IllegalStateException(e.getMessage(), e);
        }
    }

    void initCrypto() throws NoSuchAlgorithmException, InvalidAlgorithmParameterException, InvalidKeyException, NoSuchPaddingException {
        this.cipher = Cipher.getInstance(JCEProvider.getRSAOAEPSHA256AlgorithmName());
    }

    public void init(SshTransport<SshClientContext> transport, String clientId, String serverId, byte[] clientKexInit, byte[] serverKexInit, SshPrivateKey prvkey, SshPublicKey pubkey, boolean firstPacketFollows, boolean useFirstPacket) throws IOException, SshException {
        this.transport = transport;
        this.clientId = clientId;
        this.serverId = serverId;
        this.clientKexInit = clientKexInit;
        this.serverKexInit = serverKexInit;
        try {
            this.initCrypto();
        }
        catch (Exception ex) {
            throw new SshException((Throwable)ex, 16);
        }
    }

    @Override
    public boolean processMessage(byte[] tmp) throws SshException, IOException {
        switch (tmp[0]) {
            case 30: {
                try (ByteArrayWriter msg = new ByteArrayWriter();){
                    try (ByteArrayReader r = new ByteArrayReader(tmp);){
                        r.skip(1L);
                        this.hostKey = r.readBinaryString();
                        this.tk = r.readBinaryString();
                    }
                    SshRsaPublicKey key = (SshRsaPublicKey)SshPublicKeyFileFactory.decodeSSH2PublicKey((byte[])this.tk);
                    JCEComponentManager.getSecureRandom().nextBytes(this.s);
                    this.cipher.init(1, key.getJCEPublicKey());
                    try (ByteArrayWriter w = new ByteArrayWriter();){
                        w.writeBinaryString(this.s);
                        this.encryptedSecret = this.cipher.doFinal(w.toByteArray());
                    }
                    if (Log.isDebugEnabled()) {
                        Log.debug((String)"Sending SSH_MSG_KEXRSA_SECRET", (Object[])new Object[0]);
                    }
                    this.transport.postMessage(new SshMessage(){

                        public boolean writeMessageIntoBuffer(ByteBuffer buf) {
                            buf.put((byte)31);
                            buf.putInt(Rsa2048Sha256.this.encryptedSecret.length);
                            buf.put(Rsa2048Sha256.this.encryptedSecret);
                            return true;
                        }

                        public void messageSent(Long sequenceNo) {
                            if (Log.isDebugEnabled()) {
                                Log.debug((String)"Sent SSH_MSG_KEX_ECDH_INIT", (Object[])new Object[0]);
                            }
                        }
                    }, true);
                }
                catch (Throwable ex) {
                    throw new SshException("Failed to write SSH_MSG_KEXRSA_SECRET to message buffer", 5);
                }
                return true;
            }
            case 32: {
                if (Log.isDebugEnabled()) {
                    Log.debug((String)"Received SSH_MSG_KEXRSA_DONE", (Object[])new Object[0]);
                }
                try (ByteArrayReader bar = new ByteArrayReader(tmp, 1, tmp.length - 1);){
                    this.signature = bar.readBinaryString();
                    this.secret = new BigInteger(this.s);
                    this.calculateExchangeHash();
                    this.transport.sendNewKeys();
                }
                return true;
            }
        }
        this.transport.disconnect(3, "Key exchange failed");
        throw new SshException("Key exchange failed [id=" + tmp[0] + "]", 5);
    }

    @Override
    protected void calculateExchangeHash() throws SshException {
        Digest hash = (Digest)ComponentManager.getInstance().supportedDigests().getInstance(this.getHashAlgorithm());
        hash.putString(this.clientId);
        hash.putString(this.serverId);
        hash.putInt(this.clientKexInit.length);
        hash.putBytes(this.clientKexInit);
        hash.putInt(this.serverKexInit.length);
        hash.putBytes(this.serverKexInit);
        hash.putInt(this.hostKey.length);
        hash.putBytes(this.hostKey);
        hash.putInt(this.tk.length);
        hash.putBytes(this.tk);
        hash.putInt(this.encryptedSecret.length);
        hash.putBytes(this.encryptedSecret);
        hash.putBigInteger(this.secret);
        this.exchangeHash = hash.doFinal();
    }

    public static class Rsa2048Sha256Factory
    implements SshKeyExchangeClientFactory<Rsa2048Sha256> {
        public Rsa2048Sha256 create() throws NoSuchAlgorithmException, IOException {
            return new Rsa2048Sha256();
        }

        public String[] getKeys() {
            return new String[]{Rsa2048Sha256.RSA_2048_SHA256};
        }
    }
}

