/*
 * Decompiled with CFR 0.152.
 */
package com.sshtools.client.tasks;

import com.sshtools.client.PseudoTerminalModes;
import com.sshtools.client.SessionChannelNG;
import com.sshtools.client.tasks.AbstractCommandTask;
import com.sshtools.client.tasks.AbstractSessionTask;
import com.sshtools.common.ssh.SshConnection;
import java.io.IOException;
import java.io.UncheckedIOException;
import java.nio.charset.Charset;
import java.util.Optional;

public final class CommandTask
extends AbstractCommandTask {
    private final Optional<CommandTaskEvent> onClose;
    private final Optional<CommandTaskEvent> onBeforeExecute;
    private final Optional<CommandTaskEvent> onBeforeTask;
    private final Optional<CommandTaskEvent> onTask;
    private final String termType;
    private final int rows;
    private final int cols;
    private final boolean withPty;
    private final Optional<PseudoTerminalModes> modes;

    private CommandTask(CommandTaskBuilder builder) {
        super(builder, builder.command.orElseThrow(() -> new IllegalArgumentException("Command must be supplied")), builder.encoding.map(Charset::name).orElse("UTF-8"), builder.autoConsume);
        this.onClose = builder.onClose;
        this.onBeforeExecute = builder.onBeforeExecute;
        this.onTask = builder.onTask;
        this.onBeforeTask = builder.onBeforeTask;
        this.withPty = builder.withPty;
        this.termType = builder.termType.orElse("dumb");
        this.rows = builder.rows;
        this.cols = builder.cols;
        this.modes = builder.modes;
    }

    @Override
    @Deprecated(since="3.1.0", forRemoval=true)
    protected final void onCloseSession(SessionChannelNG session) {
        super.onCloseSession(session);
        this.onClose.ifPresent(c -> {
            try {
                c.commandEvent(this, session);
            }
            catch (RuntimeException re) {
                throw re;
            }
            catch (IOException ioe) {
                throw new UncheckedIOException(ioe);
            }
            catch (Exception e) {
                throw new IllegalStateException(e.getMessage(), e);
            }
        });
    }

    @Override
    public final int getExitCode() {
        return super.getExitCode();
    }

    @Override
    public final String getCommand() {
        return super.getCommand();
    }

    @Override
    protected final SessionChannelNG createSession(SshConnection con) {
        return super.createSession(con);
    }

    @Override
    @Deprecated(since="3.1.0", forRemoval=true)
    protected void closeOnTaskComplete() {
    }

    @Override
    protected final void onOpenSession(SessionChannelNG session) throws IOException {
        this.onBeforeTask.ifPresent(c -> {
            try {
                c.commandEvent(this, session);
            }
            catch (RuntimeException re) {
                throw re;
            }
            catch (IOException ioe) {
                throw new UncheckedIOException(ioe);
            }
            catch (Exception e) {
                throw new IllegalStateException(e.getMessage(), e);
            }
        });
        this.onTask.ifPresent(c -> {
            try {
                c.commandEvent(this, session);
            }
            catch (RuntimeException re) {
                throw re;
            }
            catch (IOException ioe) {
                throw new UncheckedIOException(ioe);
            }
            catch (Exception e) {
                throw new IllegalStateException(e.getMessage(), e);
            }
            finally {
                this.close();
            }
        });
    }

    @Override
    protected final void beforeExecuteCommand(SessionChannelNG session) {
        try {
            if (this.withPty) {
                if (this.modes.isEmpty()) {
                    session.allocatePseudoTerminal(this.termType, this.cols, this.rows);
                } else {
                    session.allocatePseudoTerminal(this.termType, this.cols, this.rows, 0, 0, this.modes.get());
                }
            }
            this.onBeforeExecute.ifPresent(c -> {
                try {
                    c.commandEvent(this, session);
                }
                catch (RuntimeException re) {
                    throw re;
                }
                catch (IOException ioe) {
                    throw new UncheckedIOException(ioe);
                }
                catch (Exception e) {
                    throw new IllegalStateException(e.getMessage(), e);
                }
            });
        }
        catch (RuntimeException re) {
            throw re;
        }
        catch (Exception e) {
            throw new IllegalStateException(e);
        }
    }

    public static final class CommandTaskBuilder
    extends AbstractSessionTask.AbstractSessionTaskBuilder<CommandTaskBuilder, SessionChannelNG, CommandTask> {
        private Optional<CommandTaskEvent> onClose = Optional.empty();
        private Optional<CommandTaskEvent> onBeforeExecute = Optional.empty();
        private Optional<CommandTaskEvent> onBeforeTask = Optional.empty();
        private Optional<CommandTaskEvent> onTask = Optional.empty();
        private Optional<Charset> encoding = Optional.empty();
        private Optional<String> command = Optional.empty();
        private Optional<String> termType = Optional.empty();
        private int cols = 80;
        private int rows = 24;
        private boolean withPty = true;
        private Optional<PseudoTerminalModes> modes = Optional.empty();
        private boolean autoConsume;

        private CommandTaskBuilder() {
        }

        public CommandTaskBuilder withAutoConsume() {
            return this.withAutoConsume(true);
        }

        public CommandTaskBuilder withAutoConsume(boolean autoConsume) {
            this.autoConsume = autoConsume;
            return this;
        }

        public final CommandTaskBuilder withTermType(String termType) {
            return this.withTermType(Optional.of(termType));
        }

        public final CommandTaskBuilder withTermType(Optional<String> termType) {
            this.termType = termType;
            return this;
        }

        public final CommandTaskBuilder withColumns(int cols) {
            this.cols = cols;
            return this;
        }

        public final CommandTaskBuilder withRows(int rows) {
            this.rows = rows;
            return this;
        }

        public final CommandTaskBuilder withModes(PseudoTerminalModes modes) {
            this.modes = Optional.of(modes);
            return this;
        }

        public CommandTaskBuilder withPty(boolean withPty) {
            this.withPty = withPty;
            return this;
        }

        public CommandTaskBuilder withoutPty() {
            this.withPty = false;
            return this;
        }

        public CommandTaskBuilder withCommand(String command) {
            this.command = Optional.of(command);
            return this;
        }

        public CommandTaskBuilder withEncoding(String encoding) {
            if (encoding == null) {
                this.encoding = Optional.empty();
                return this;
            }
            return this.withEncoding(Charset.forName(encoding));
        }

        public CommandTaskBuilder withEncoding(Charset encoding) {
            this.encoding = Optional.of(encoding);
            return this;
        }

        public static CommandTaskBuilder create() {
            return new CommandTaskBuilder();
        }

        public final CommandTaskBuilder onBeforeExecute(CommandTaskEvent onBeforeExecute) {
            this.onBeforeExecute = Optional.of(onBeforeExecute);
            return this;
        }

        public final CommandTaskBuilder onClose(CommandTaskEvent onClose) {
            this.onClose = Optional.of(onClose);
            return this;
        }

        public final CommandTaskBuilder onBeforeTask(CommandTaskEvent onOpen) {
            this.onBeforeTask = Optional.of(onOpen);
            return this;
        }

        public final CommandTaskBuilder onTask(CommandTaskEvent onExecute) {
            this.onTask = Optional.of(onExecute);
            return this;
        }

        @Override
        public CommandTask build() {
            return new CommandTask(this);
        }
    }

    @FunctionalInterface
    public static interface CommandTaskEvent {
        public void commandEvent(CommandTask var1, SessionChannelNG var2) throws Exception;
    }
}

