/*
 * Decompiled with CFR 0.152.
 */
package com.sshtools.client.tasks;

import com.sshtools.client.SshClient;
import com.sshtools.client.sftp.SftpClient;
import com.sshtools.client.sftp.SftpHandle;
import com.sshtools.client.sftp.TransferCancelledException;
import com.sshtools.client.tasks.AbstractOptimisedTask;
import com.sshtools.client.tasks.FileTransferProgress;
import com.sshtools.common.logger.Log;
import com.sshtools.common.permissions.PermissionDeniedException;
import com.sshtools.common.sftp.SftpFileAttributes;
import com.sshtools.common.sftp.SftpStatusException;
import com.sshtools.common.ssh.ChannelOpenException;
import com.sshtools.common.ssh.SshException;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InterruptedIOException;
import java.nio.channels.Channels;
import java.nio.channels.SeekableByteChannel;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.StandardOpenOption;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import java.util.Optional;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicLong;

public final class PullTask
extends AbstractOptimisedTask<Path, String> {
    private final List<String> files;
    private Optional<Path> localFolder;

    PullTask(PullTaskBuilder builder) {
        super(builder);
        this.localFolder = builder.localFolder;
        this.files = Collections.unmodifiableList(builder.paths);
    }

    @Override
    protected void transferFiles(Path target) throws SftpStatusException, SshException, TransferCancelledException, IOException, PermissionDeniedException, ChannelOpenException {
        if (!Files.isDirectory(target, new LinkOption[0])) {
            throw new IOException(MessageFormat.format("Local directory {0} must be a directory!", target));
        }
        this.verboseMessage("The paths will be transferred to {0}", target);
        for (String file : this.files) {
            if (this.primarySftpClient.exists(file)) continue;
            throw new FileNotFoundException(String.format("%s does not exist", file));
        }
        for (String file : this.files) {
            this.transferFile(file, target);
        }
    }

    @Override
    protected Path configureTargetFolder() throws IOException, SshException, PermissionDeniedException, SftpStatusException {
        return this.localFolder.orElseGet(() -> Paths.get(System.getProperty("user.dir"), new String[0]));
    }

    private void transferFile(String remotePath, Path localFolder) throws SftpStatusException, SshException, TransferCancelledException, IOException, PermissionDeniedException, ChannelOpenException {
        SftpFileAttributes remoteFile = this.primarySftpClient.stat(remotePath);
        this.verboseMessage("Total to transfer is {0} bytes", remoteFile.size());
        if (this.chunks <= 1) {
            this.receiveFileViaSFTP(remotePath, localFolder);
        } else {
            this.checkErrors(this.receiveChunks(remotePath, localFolder));
        }
        this.verifyIntegrity(localFolder.resolve(Paths.get(remotePath, new String[0]).getFileName()), remotePath);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Collection<Throwable> receiveChunks(String remotePath, Path localFolder) throws PermissionDeniedException, IOException, SftpStatusException, SshException {
        ExecutorService executor = Executors.newFixedThreadPool(this.chunks);
        String remoteFolder = this.primarySftpClient.pwd();
        try {
            Path targetFilePath = localFolder.resolve(Paths.get(remotePath, new String[0]).getFileName());
            SftpFileAttributes remoteFile = this.primarySftpClient.stat(remotePath);
            long chunkLength = remoteFile.size().longValue() / (long)this.chunks;
            long finalLength = remoteFile.size().longValue() - chunkLength * (long)(this.chunks - 1);
            List progressChunks = Collections.synchronizedList(new ArrayList());
            List<Throwable> errors = Collections.synchronizedList(new ArrayList());
            AtomicLong total = new AtomicLong();
            this.verboseMessage("Splitting {0} into {1} chunks", targetFilePath.getFileName(), this.chunks);
            if (this.progress.isPresent()) {
                ((FileTransferProgress)this.progress.get()).started(remoteFile.size().longValue(), targetFilePath.getFileName().toString());
            }
            try (SeekableByteChannel localOutChannel = Files.newByteChannel(targetFilePath, StandardOpenOption.WRITE, StandardOpenOption.CREATE);){
                localOutChannel.truncate(remoteFile.size().longValue());
            }
            this.verboseMessage("Remote server supports multipart extensions", new Object[0]);
            this.printChunkMessages(chunkLength);
            for (int i = 0; i < this.chunks; ++i) {
                int chunk = i + 1;
                long pointer = (long)i * chunkLength;
                executor.submit(() -> {
                    try {
                        FileTransferProgress tmp = (FileTransferProgress)this.chunkProgress.apply(remotePath);
                        AbstractOptimisedTask.FileTransferProgressWrapper wrapper = new AbstractOptimisedTask.FileTransferProgressWrapper(tmp, this.progress, total);
                        progressChunks.add(wrapper);
                        boolean lastChunk = chunk == this.chunks;
                        long thisLength = lastChunk ? chunkLength + finalLength : chunkLength;
                        this.receivePart(remotePath, pointer, (int)thisLength, chunk, lastChunk, wrapper, String.format("part%d", chunk), localFolder, remoteFile.size().longValue(), remoteFolder);
                    }
                    catch (Throwable e) {
                        errors.add(e);
                    }
                });
            }
            List<Throwable> list = errors;
            return list;
        }
        finally {
            executor.shutdown();
            try {
                executor.awaitTermination(Long.MAX_VALUE, TimeUnit.MILLISECONDS);
            }
            catch (InterruptedException e1) {
                throw new InterruptedIOException();
            }
            finally {
                ((FileTransferProgress)this.progress.get()).completed();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void receiveFileViaSFTP(String remotePath, Path localFolder) throws IOException, SshException, PermissionDeniedException, SftpStatusException, TransferCancelledException {
        SshClient ssh = (SshClient)this.clients.removeFirst();
        SftpClient.SftpClientBuilder bldr = SftpClient.SftpClientBuilder.create().withClient(ssh);
        if (this.blocksize > 0) {
            bldr.withBlockSize(this.blocksize);
        }
        if (this.outstandingRequests > 0) {
            bldr.withAsyncRequests(this.outstandingRequests);
        }
        try (SftpClient sftp = bldr.build();){
            sftp.cd(this.primarySftpClient.pwd());
            sftp.lcd(localFolder.toAbsolutePath().toString());
            sftp.get(remotePath, (FileTransferProgress)this.progress.orElse(null));
        }
        finally {
            LinkedList linkedList = this.clients;
            synchronized (linkedList) {
                this.clients.addLast(ssh);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void receivePart(String remotePath, final long pointer, int chunkLength, Integer chunkNumber, boolean lastChunk, final FileTransferProgress progress, String partId, Path localFolder, long totalLength, String remoteFolder) throws IOException, SftpStatusException, SshException, TransferCancelledException, ChannelOpenException, PermissionDeniedException {
        SshClient ssh;
        LinkedList linkedList = this.clients;
        synchronized (linkedList) {
            ssh = (SshClient)this.clients.removeFirst();
        }
        Path targetFilePath = localFolder.resolve(Paths.get(remotePath, new String[0]).getFileName());
        try (SeekableByteChannel file = Files.newByteChannel(targetFilePath, StandardOpenOption.WRITE);){
            file.position(pointer);
            try (SftpClient sftp = SftpClient.SftpClientBuilder.create().withClient(ssh).withRemotePath(remoteFolder).withLocalPath(localFolder.toAbsolutePath().toString()).build();){
                try (SftpHandle handle = sftp.getSubsystemChannel().openFile(remotePath, 1);){
                    handle.performOptimizedRead(totalLength, chunkLength, Channels.newOutputStream(file), this.outstandingRequests, new FileTransferProgress(){

                        @Override
                        public void started(long bytesTotal, String file) {
                            progress.started(bytesTotal, file);
                        }

                        @Override
                        public boolean isCancelled() {
                            return progress.isCancelled();
                        }

                        @Override
                        public void progressed(long bytesSoFar) {
                            progress.progressed(bytesSoFar - pointer);
                        }

                        @Override
                        public void completed() {
                            progress.completed();
                        }
                    }, pointer);
                }
                catch (TransferCancelledException | SftpStatusException | SshException e) {
                    Log.error((String)"Part upload failed", (Throwable)e, (Object[])new Object[0]);
                    throw e;
                }
            }
        }
        catch (IOException ioe) {
            if (ioe.getCause() instanceof TransferCancelledException) {
                throw (TransferCancelledException)ioe.getCause();
            }
            throw ioe;
        }
        finally {
            LinkedList linkedList2 = this.clients;
            synchronized (linkedList2) {
                this.clients.addLast(ssh);
            }
        }
    }

    public static class PullTaskBuilder
    extends AbstractOptimisedTask.AbstractOptimisedTaskBuilder<PullTaskBuilder, PullTask, String> {
        private Optional<Path> localFolder = Optional.empty();
        private List<String> paths = new ArrayList<String>();

        private PullTaskBuilder() {
        }

        public static PullTaskBuilder create() {
            return new PullTaskBuilder();
        }

        public PullTaskBuilder addPaths(Collection<String> filePaths) {
            this.paths.addAll(filePaths);
            return this;
        }

        public PullTaskBuilder addPaths(String ... paths) {
            return this.addPaths(Arrays.asList(paths));
        }

        public PullTaskBuilder withPaths(String ... paths) {
            this.paths.clear();
            return this.addPaths(Arrays.asList(paths));
        }

        public PullTaskBuilder withPaths(Collection<String> filePaths) {
            this.paths.clear();
            return this.addPaths(filePaths);
        }

        public PullTaskBuilder withLocalFolder(String localFolder) {
            return this.withLocalFolder(localFolder == null || localFolder.equals("") ? Optional.empty() : Optional.of(Path.of(localFolder, new String[0])));
        }

        public PullTaskBuilder withLocalFolder(Path localFolder) {
            return this.withLocalFolder(Optional.of(localFolder));
        }

        public PullTaskBuilder withLocalFolder(Optional<Path> localFolder) {
            this.localFolder = localFolder;
            return this;
        }

        @Override
        public PullTask build() {
            return new PullTask(this);
        }
    }
}

