/*
 * Decompiled with CFR 0.152.
 */
package com.sshtools.synergy.ssh;

import com.sshtools.common.logger.Log;
import com.sshtools.common.logger.LoggerContext;
import com.sshtools.common.ssh.ExecutorServiceProvider;
import com.sshtools.common.ssh.SshConnection;
import com.sshtools.common.ssh.SshConnectionManager;
import com.sshtools.synergy.ssh.Connection;
import com.sshtools.synergy.ssh.ConnectionLoggingContext;
import com.sshtools.synergy.ssh.ConnectionProtocol;
import com.sshtools.synergy.ssh.SshContext;
import com.sshtools.synergy.ssh.TransportProtocol;
import java.io.IOException;
import java.net.InetSocketAddress;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Objects;

public class ConnectionManager<T extends SshContext>
implements SshConnectionManager {
    private HashMap<String, Connection<T>> activeConnections = new HashMap();
    private static Map<String, ConnectionManager<?>> instances = new HashMap();
    public static final String DEFAULT_NAME = "default";
    final String name;
    static ThreadLocal<SshConnection> currentConnection = new ThreadLocal();
    ConnectionLoggingContext ctx;

    public ConnectionManager(String name) {
        this(name, Log.Level.valueOf((String)Log.getDefaultContext().getProperty("maverick.log.connection.level", "NONE")));
    }

    public ConnectionManager(String name, Log.Level level) {
        if (instances.containsKey(name)) {
            throw new IllegalArgumentException(String.format("There is already a connection manager registered named %s", name));
        }
        this.name = name;
        instances.put(name, this);
        this.ctx = new ConnectionLoggingContext(level, this);
    }

    public static SshConnection searchConnectionsById(String uuid) {
        for (ConnectionManager<?> mgr : instances.values()) {
            SshConnection con = mgr.getConnectionById(uuid);
            if (Objects.isNull(con)) continue;
            return con;
        }
        return null;
    }

    public String getName() {
        return this.name;
    }

    public void startLogging(SshConnection con, Log.Level level) throws IOException {
        this.ctx.startLogging(con, level);
    }

    public void startLogging(SshConnection con) throws IOException {
        this.ctx.startLogging(con);
    }

    public void setupConnection(SshConnection con) {
        currentConnection.set(con);
        Log.setupCurrentContext((LoggerContext)this.ctx);
    }

    public void clearConnection() {
        currentConnection.remove();
        Log.clearCurrentContext();
    }

    public static SshConnection getCurrentConnection() {
        return currentConnection.get();
    }

    public static Connection<?> getConnection(String id) {
        for (ConnectionManager<?> instance : instances.values()) {
            SshConnection c = instance.getConnectionById(id);
            if (c == null) continue;
            return c;
        }
        return null;
    }

    public synchronized Connection<T> registerConnection(ConnectionProtocol<T> connection) {
        Connection<T> con;
        if (Log.isDebugEnabled()) {
            Log.debug((String)"Connection {} is now authenticated", (Object[])new Object[]{connection.getSessionIdentifier()});
        }
        if (Objects.isNull(con = this.activeConnections.get(connection.getSessionIdentifier()))) {
            throw new IllegalArgumentException("Cannot set connection instance on non-existent transport!");
        }
        con.connection = connection;
        if (Log.isDebugEnabled()) {
            Log.debug((String)"Notifying future that authentication is complete", (Object[])new Object[0]);
        }
        con.getAuthenticatedFuture().done(true);
        return con;
    }

    public Connection<T> getConnectionById(String sessionid) {
        if (sessionid != null && this.activeConnections.containsKey(sessionid)) {
            return this.activeConnections.get(sessionid);
        }
        return null;
    }

    public synchronized Collection<SshConnection> getAllConnections() {
        return Collections.unmodifiableCollection(this.activeConnections.values());
    }

    public synchronized Connection<T> registerTransport(TransportProtocol<T> transport, T sshContext) {
        Connection<ExecutorServiceProvider> con = new Connection<ExecutorServiceProvider>(transport.getContext());
        con.transport = transport;
        con.remoteAddress = (InetSocketAddress)transport.getRemoteAddress();
        con.localAddress = (InetSocketAddress)transport.getLocalAddress();
        this.activeConnections.put(con.getSessionId(), con);
        if (Log.isDebugEnabled()) {
            Log.debug((String)"There {} now {} active connections on {} connection manager", (Object[])new Object[]{this.activeConnections.size() > 1 ? "are" : "is", this.activeConnections.size(), this.getName()});
        }
        try {
            this.ctx.open(con);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return con;
    }

    public synchronized void unregisterTransport(TransportProtocol<T> transport) {
        Connection<T> con = this.activeConnections.remove(transport.getUUID());
        if (Objects.nonNull(con)) {
            con.close();
            this.ctx.close(con);
        }
    }

    public String[] getLoggedOnUsers() {
        HashSet<String> users = new HashSet<String>();
        for (Connection<T> c : this.activeConnections.values()) {
            if (!c.isAuthenticated()) continue;
            users.add(c.getUsername());
        }
        String[] result = new String[users.size()];
        users.toArray(result);
        return result;
    }

    public Integer getNumberOfConnections() {
        return this.activeConnections.size();
    }
}

