/*
 * Decompiled with CFR 0.152.
 */
package com.sshtools.synergy.ssh;

import com.sshtools.common.forwarding.ForwardingPolicy;
import com.sshtools.common.logger.Log;
import com.sshtools.common.nio.WriteOperationRequest;
import com.sshtools.common.ssh.ChannelOpenException;
import com.sshtools.common.ssh.ConnectionAwareTask;
import com.sshtools.common.ssh.SshConnection;
import com.sshtools.synergy.nio.ProtocolEngine;
import com.sshtools.synergy.nio.SelectorThread;
import com.sshtools.synergy.nio.SocketHandler;
import com.sshtools.synergy.nio.SshEngine;
import com.sshtools.synergy.ssh.CachingDataWindow;
import com.sshtools.synergy.ssh.ForwardingChannel;
import com.sshtools.synergy.ssh.ForwardingDataWindow;
import com.sshtools.synergy.ssh.SshContext;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.channels.SelectableChannel;
import java.nio.channels.SelectionKey;
import java.nio.channels.SocketChannel;
import java.util.concurrent.atomic.AtomicBoolean;

public abstract class SocketForwardingChannel<T extends SshContext>
extends ForwardingChannel<T>
implements SocketHandler {
    public static final String LOCAL_FORWARDING_CHANNEL_TYPE = "direct-tcpip";
    public static final String REMOTE_FORWARDING_CHANNEL_TYPE = "forwarded-tcpip";
    public static final String X11_FORWARDING_CHANNEL_TYPE = "x11";
    private static final int SOCKET_QUEUE = -252706816;
    protected SocketChannel socketChannel;
    protected SelectorThread selectorThread;
    protected SelectionKey key;
    boolean closePending = false;
    ForwardingDataWindow toChannel;
    long totalIn;
    long totalOut;
    AtomicBoolean socketEOF = new AtomicBoolean(false);

    public SocketForwardingChannel(String channeltype, SshConnection con) {
        super(channeltype, ((ForwardingPolicy)con.getContext().getPolicy(ForwardingPolicy.class)).getForwardingMaxPacketSize(), ((ForwardingPolicy)con.getContext().getPolicy(ForwardingPolicy.class)).getForwardingMaxWindowSize(), ((ForwardingPolicy)con.getContext().getPolicy(ForwardingPolicy.class)).getForwardingMaxWindowSize(), ((ForwardingPolicy)con.getContext().getPolicy(ForwardingPolicy.class)).getForwardingMinWindowSize());
        this.toChannel = new ForwardingDataWindow(((ForwardingPolicy)con.getContext().getPolicy(ForwardingPolicy.class)).getForwardingMaxWindowSize().intValue());
    }

    @Override
    protected CachingDataWindow createCache(int maximumWindowSpace) {
        return new ForwardingDataWindow(maximumWindowSpace);
    }

    @Override
    public void setSelectionKey(SelectionKey key) {
        this.key = key;
    }

    @Override
    protected void onChannelOpen() {
    }

    public void initialize(ProtocolEngine engine, SshEngine daemon) {
    }

    @Override
    protected abstract byte[] createChannel() throws IOException;

    @Override
    protected void onExtendedData(ByteBuffer data, int type) {
        throw new IllegalStateException("Extended data is not supported on forwarding channels");
    }

    protected abstract void onRegistrationComplete();

    @Override
    public void registrationCompleted(SelectableChannel channel, SelectionKey key, SelectorThread selectorThread) {
        if (Log.isTraceEnabled()) {
            this.log("Forwarding channel selector thread registration completed");
        }
        this.selectorThread = selectorThread;
        this.key = key;
        this.onRegistrationComplete();
    }

    @Override
    protected void onChannelData(ByteBuffer data) {
        super.onChannelData(data);
        this.changeInterestedOps();
        if (this.socketEOF.get() && this.canClose()) {
            this.close();
        }
    }

    @Override
    protected void onChannelRequest(String parm1, boolean parm2, byte[] parm3) {
        this.sendRequestResponse(false);
    }

    private void changeInterestedOps() {
        this.selectorThread.addSelectorOperation(new Runnable(){

            @Override
            public void run() {
                if (SocketForwardingChannel.this.key.isValid()) {
                    int ops = 0;
                    boolean wantsWrite = SocketForwardingChannel.this.wantsWrite();
                    boolean wantsRead = SocketForwardingChannel.this.wantsRead();
                    if (wantsWrite) {
                        ops |= 4;
                    }
                    if (wantsRead) {
                        ops |= 1;
                    }
                    if (Log.isTraceEnabled()) {
                        Log.trace((String)"{} channel={} ops={} has state {}", (Object[])new Object[]{SocketForwardingChannel.this.getName(), SocketForwardingChannel.this.getLocalId(), ops, wantsWrite && wantsRead ? "READ/WRITE" : (wantsWrite ? "WRITE" : (wantsRead ? "READ" : "NONE"))});
                    }
                    SocketForwardingChannel.this.key.interestOps(ops);
                }
            }
        });
    }

    @Override
    protected void onChannelFree() {
    }

    @Override
    protected void onChannelClosing() {
    }

    /*
     * Unable to fully structure code
     */
    protected synchronized void cleanupSocket() {
        block10: {
            if (this.socketChannel == null) break block10;
            if (this.socketChannel.isOpen()) {
                if (Log.isTraceEnabled()) {
                    this.log("Closing SocketChannel");
                }
                try {
                    this.socketChannel.close();
                    this.socketEOF.set(true);
                }
                catch (IOException ex) {
                    block9: {
                        try {
                            if (!Log.isTraceEnabled()) break block9;
                            this.log("Closing SocketChannel caused Exception", ex);
                        }
                        catch (Throwable var2_2) {
                            if (Log.isTraceEnabled()) {
                                Log.trace((String)"Socket is closed channel={} remote={}", (Object[])new Object[]{this.getLocalId(), this.getRemoteId()});
                            }
                            throw var2_2;
                        }
                    }
                    if (Log.isTraceEnabled()) {
                        Log.trace((String)"Socket is closed channel={} remote={}", (Object[])new Object[]{this.getLocalId(), this.getRemoteId()});
                    } else {
                        ** GOTO lbl23
                    }
                }
                if (Log.isTraceEnabled()) {
                    Log.trace((String)"Socket is closed channel={} remote={}", (Object[])new Object[]{this.getLocalId(), this.getRemoteId()});
                }
            }
            this.socketChannel = null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected synchronized boolean canClose() {
        if (!this.socketEOF.get() && this.cache.hasRemaining()) {
            if (Log.isTraceEnabled()) {
                this.log("Not closing due to socket cache");
            }
            return false;
        }
        ForwardingDataWindow forwardingDataWindow = this.toChannel;
        synchronized (forwardingDataWindow) {
            if (this.toChannel.hasRemaining() && this.isOpen() && !this.isLocalEOF()) {
                if (Log.isTraceEnabled()) {
                    this.log("Not closing due to channel cache");
                }
                return false;
            }
        }
        return super.canClose();
    }

    protected synchronized void evaluateClosure() {
        this.closePending = true;
        if (this.canClose() && this.isRemoteEOF()) {
            this.close();
        }
    }

    protected void shutdownSocket() {
        if (this.selectorThread != null && this.socketChannel != null) {
            if (Log.isTraceEnabled()) {
                this.log("Adding Socket close operation to selector");
            }
            this.selectorThread.addSelectorOperation(new Runnable(){

                @Override
                public void run() {
                    SocketForwardingChannel.this.cleanupSocket();
                    if (SocketForwardingChannel.this.key != null && SocketForwardingChannel.this.key.isValid()) {
                        if (Log.isTraceEnabled()) {
                            SocketForwardingChannel.this.log("Cancelling selection key because its still valid");
                        }
                        SocketForwardingChannel.this.key.cancel();
                        SocketForwardingChannel.this.key = null;
                    }
                }
            });
            if (Log.isTraceEnabled()) {
                this.log("Waking up selector");
            }
            this.selectorThread.wakeup();
        } else if (this.socketChannel != null) {
            if (Log.isTraceEnabled()) {
                this.log("Socket is not attached to selector so closing now");
            }
            this.cleanupSocket();
        }
    }

    @Override
    protected void onChannelClosed() {
        this.shutdownSocket();
    }

    @Override
    protected void onLocalEOF() {
        this.evaluateClosure();
    }

    @Override
    protected void onRemoteClose() {
        this.isRemoteEOF.set(true);
        this.evaluateClosure();
    }

    @Override
    protected void onRemoteEOF() {
        this.evaluateClosure();
    }

    @Override
    protected abstract void onChannelOpenConfirmation();

    protected void evaluateWindowSpace(int remaining) {
    }

    @Override
    protected abstract byte[] openChannel(byte[] var1) throws WriteOperationRequest, ChannelOpenException;

    @Override
    public boolean processReadEvent() {
        if (Log.isTraceEnabled()) {
            this.log("Processing FORWARDING READ");
        }
        if (this.socketChannel == null || !this.socketChannel.isConnected() || !this.isOpen()) {
            if (Log.isTraceEnabled()) {
                this.log("Forwarding socket is closed");
            }
            return true;
        }
        try {
            int numBytesRead = this.toChannel.read(this.socketChannel);
            if (Log.isDebugEnabled()) {
                this.log(String.format("Processed FORWARDING READ read=%d", numBytesRead));
            }
            if (numBytesRead <= 0) {
                if (numBytesRead == -1) {
                    this.socketEOF.set(true);
                    if (Log.isDebugEnabled()) {
                        this.log("Received EOF from forwarding socket");
                    }
                    this.getConnectionProtocol().addOutgoingTask(new ConnectionAwareTask(this.con){

                        protected void doTask() {
                            if (Log.isDebugEnabled()) {
                                SocketForwardingChannel.this.log("The socket has returned EOF");
                            }
                            SocketForwardingChannel.this.sendEOF();
                            SocketForwardingChannel.this.evaluateClosure();
                        }
                    });
                    return true;
                }
            } else if (numBytesRead > 0) {
                this.totalIn += (long)numBytesRead;
                if (Log.isDebugEnabled()) {
                    this.log("Processing FORWARDING READ read=" + numBytesRead);
                }
                this.getConnectionProtocol().addOutgoingTask(new QueueChannelDataTask(this.con, numBytesRead));
            }
        }
        catch (Throwable ex) {
            if (Log.isTraceEnabled()) {
                this.log("processReadEvent() failed to read from socket", ex);
            }
            this.socketEOF.set(true);
            this.getConnectionProtocol().addOutgoingTask(new ConnectionAwareTask(this.con){

                protected void doTask() {
                    SocketForwardingChannel.this.sendEOF();
                    SocketForwardingChannel.this.evaluateClosure();
                }
            });
            return true;
        }
        return !this.isOpen() && (this.socketChannel == null || !this.socketChannel.isConnected());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean processWriteEvent() {
        if (Log.isTraceEnabled()) {
            this.log("Processing FORWARDING WRITE");
        }
        if (this.socketChannel == null || !this.socketChannel.isConnected()) {
            if (Log.isTraceEnabled()) {
                this.log("Forwarding socket is closed");
            }
            return true;
        }
        int written = 0;
        try {
            CachingDataWindow cachingDataWindow = this.cache;
            synchronized (cachingDataWindow) {
                if (this.cache.hasRemaining()) {
                    written = ((ForwardingDataWindow)this.cache).write(this.socketChannel);
                    if (Log.isDebugEnabled()) {
                        this.log(String.format("Processed FORWARDING WRITE written=%d", written));
                    }
                    this.totalOut += (long)written;
                }
                if (Log.isTraceEnabled()) {
                    this.log("Completed FORWARDING WRITE");
                }
                if (this.localWindow.isAdjustRequired()) {
                    this.sendWindowAdjust();
                }
            }
            if (this.closePending && this.canClose()) {
                this.close();
            }
        }
        catch (Throwable t) {
            this.socketEOF.set(true);
            if (Log.isTraceEnabled()) {
                this.log("processWriteEvent() failed to write to socket", t);
            }
            this.evaluateClosure();
            return true;
        }
        return !this.isOpen() && (this.socketChannel == null || !this.socketChannel.isConnected());
    }

    @Override
    public boolean wantsWrite() {
        return this.cache.hasRemaining();
    }

    @Override
    public boolean wantsRead() {
        return true;
    }

    @Override
    public int getInitialOps() {
        return 1;
    }

    @Override
    public void setThread(SelectorThread thread) {
        this.selectorThread = thread;
    }

    @Override
    void log() {
        super.log();
        if (Log.isInfoEnabled()) {
            Log.info((String)"socketCache={} channelCache={} closePending={} connected={} in={} out={}", (Object[])new Object[]{this.cache == null ? -1 : this.cache.remaining(), this.toChannel == null ? -1 : this.toChannel.remaining(), this.closePending, this.socketChannel != null && this.socketChannel.isConnected(), this.totalIn, this.totalOut});
        }
    }

    @Override
    public void addTask(ConnectionAwareTask task) {
        this.getConnectionProtocol().addTask(0xF0F00000 & this.getLocalId(), task);
    }

    @Override
    public SelectorThread getSelectorThread() {
        return this.selectorThread;
    }

    @Override
    public String getName() {
        return this.getChannelType();
    }

    class QueueChannelDataTask
    extends ConnectionAwareTask {
        int count;

        QueueChannelDataTask(SshConnection con, int count) {
            super(con);
            this.count = count;
        }

        protected void doTask() {
            try {
                byte[] tmp = new byte[SocketForwardingChannel.this.getRemotePacket()];
                while (this.count > 0) {
                    int c = Math.min(Math.min(this.count, tmp.length), SocketForwardingChannel.this.toChannel.remaining());
                    SocketForwardingChannel.this.toChannel.get(tmp, 0, c);
                    this.count -= c;
                    SocketForwardingChannel.this.sendData(tmp, 0, c);
                }
                SocketForwardingChannel.this.changeInterestedOps();
                if (SocketForwardingChannel.this.closePending && SocketForwardingChannel.this.canClose()) {
                    SocketForwardingChannel.this.close();
                }
            }
            catch (IOException e) {
                SocketForwardingChannel.this.log("Channel I/O error", e);
                SocketForwardingChannel.this.close(e);
            }
        }
    }
}

