/*
 * Decompiled with CFR 0.152.
 */
package com.sshtools.synergy.ssh;

import com.sshtools.common.ssh.SshException;
import com.sshtools.common.ssh.components.ComponentManager;
import com.sshtools.common.util.ByteArrayWriter;
import com.sshtools.synergy.ssh.SshContext;
import java.io.IOException;

public class TransportProtocolHelper {
    public static byte[] generateKexInit(SshContext sshContext, boolean supportsExtInfo, String extInfo, String strictTransport) throws SshException, IOException {
        try (ByteArrayWriter baw = new ByteArrayWriter();){
            byte[] cookie = new byte[16];
            ComponentManager.getDefaultInstance().getRND().nextBytes(cookie);
            baw.write(20);
            baw.write(cookie);
            Object list = sshContext.supportedKeyExchanges().list(sshContext.getPreferredKeyExchange());
            if (supportsExtInfo) {
                list = (String)list + "," + extInfo;
            }
            baw.writeString((String)list + "," + strictTransport);
            list = sshContext.getSupportedPublicKeys();
            baw.writeString((String)list);
            list = sshContext.supportedCiphersCS().list(sshContext.getPreferredCipherCS());
            baw.writeString((String)list);
            list = sshContext.supportedCiphersSC().list(sshContext.getPreferredCipherSC());
            baw.writeString((String)list);
            list = sshContext.supportedMacsCS().list(sshContext.getPreferredMacCS());
            baw.writeString((String)list);
            list = sshContext.supportedMacsSC().list(sshContext.getPreferredMacSC());
            baw.writeString((String)list);
            list = sshContext.supportedCompressionsCS().list(sshContext.getPreferredCompressionCS());
            baw.writeString((String)list);
            list = sshContext.supportedCompressionsSC().list(sshContext.getPreferredCompressionSC());
            baw.writeString((String)list);
            baw.writeInt(0);
            baw.writeInt(0);
            baw.write(0);
            baw.writeInt(0);
            byte[] byArray = baw.toByteArray();
            return byArray;
        }
    }
}

