/*
 * Decompiled with CFR 0.152.
 */
package com.stripe.model;

import com.google.gson.annotations.SerializedName;
import com.stripe.Stripe;
import com.stripe.exception.StripeException;
import com.stripe.model.ExpandableField;
import com.stripe.model.HasId;
import com.stripe.model.PaymentMethod;
import com.stripe.model.StripeObject;
import com.stripe.net.ApiResource;
import com.stripe.net.RequestOptions;
import com.stripe.param.MandateRetrieveParams;
import java.util.Map;
import lombok.Generated;

public class Mandate
extends ApiResource
implements HasId {
    @SerializedName(value="customer_acceptance")
    CustomerAcceptance customerAcceptance;
    @SerializedName(value="id")
    String id;
    @SerializedName(value="livemode")
    Boolean livemode;
    @SerializedName(value="multi_use")
    MultiUse multiUse;
    @SerializedName(value="object")
    String object;
    @SerializedName(value="payment_method")
    ExpandableField<PaymentMethod> paymentMethod;
    @SerializedName(value="payment_method_details")
    PaymentMethodDetails paymentMethodDetails;
    @SerializedName(value="single_use")
    SingleUse singleUse;
    @SerializedName(value="status")
    String status;
    @SerializedName(value="type")
    String type;

    public String getPaymentMethod() {
        return this.paymentMethod != null ? this.paymentMethod.getId() : null;
    }

    public void setPaymentMethod(String id) {
        this.paymentMethod = ApiResource.setExpandableFieldId(id, this.paymentMethod);
    }

    public PaymentMethod getPaymentMethodObject() {
        return this.paymentMethod != null ? this.paymentMethod.getExpanded() : null;
    }

    public void setPaymentMethodObject(PaymentMethod expandableObject) {
        this.paymentMethod = new ExpandableField<PaymentMethod>(expandableObject.getId(), expandableObject);
    }

    public static Mandate retrieve(String mandate) throws StripeException {
        return Mandate.retrieve(mandate, (Map<String, Object>)null, (RequestOptions)null);
    }

    public static Mandate retrieve(String mandate, RequestOptions options) throws StripeException {
        return Mandate.retrieve(mandate, (Map<String, Object>)null, options);
    }

    public static Mandate retrieve(String mandate, Map<String, Object> params, RequestOptions options) throws StripeException {
        String url = String.format("%s%s", Stripe.getApiBase(), String.format("/v1/mandates/%s", ApiResource.urlEncodeId(mandate)));
        return ApiResource.request(ApiResource.RequestMethod.GET, url, params, Mandate.class, options);
    }

    public static Mandate retrieve(String mandate, MandateRetrieveParams params, RequestOptions options) throws StripeException {
        String url = String.format("%s%s", Stripe.getApiBase(), String.format("/v1/mandates/%s", ApiResource.urlEncodeId(mandate)));
        return ApiResource.request(ApiResource.RequestMethod.GET, url, params, Mandate.class, options);
    }

    @Generated
    public CustomerAcceptance getCustomerAcceptance() {
        return this.customerAcceptance;
    }

    @Generated
    public Boolean getLivemode() {
        return this.livemode;
    }

    @Generated
    public MultiUse getMultiUse() {
        return this.multiUse;
    }

    @Generated
    public String getObject() {
        return this.object;
    }

    @Generated
    public PaymentMethodDetails getPaymentMethodDetails() {
        return this.paymentMethodDetails;
    }

    @Generated
    public SingleUse getSingleUse() {
        return this.singleUse;
    }

    @Generated
    public String getStatus() {
        return this.status;
    }

    @Generated
    public String getType() {
        return this.type;
    }

    @Generated
    public void setCustomerAcceptance(CustomerAcceptance customerAcceptance) {
        this.customerAcceptance = customerAcceptance;
    }

    @Generated
    public void setId(String id) {
        this.id = id;
    }

    @Generated
    public void setLivemode(Boolean livemode) {
        this.livemode = livemode;
    }

    @Generated
    public void setMultiUse(MultiUse multiUse) {
        this.multiUse = multiUse;
    }

    @Generated
    public void setObject(String object) {
        this.object = object;
    }

    @Generated
    public void setPaymentMethodDetails(PaymentMethodDetails paymentMethodDetails) {
        this.paymentMethodDetails = paymentMethodDetails;
    }

    @Generated
    public void setSingleUse(SingleUse singleUse) {
        this.singleUse = singleUse;
    }

    @Generated
    public void setStatus(String status) {
        this.status = status;
    }

    @Generated
    public void setType(String type) {
        this.type = type;
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof Mandate)) {
            return false;
        }
        Mandate other = (Mandate)o;
        if (!other.canEqual(this)) {
            return false;
        }
        Boolean this$livemode = this.getLivemode();
        Boolean other$livemode = other.getLivemode();
        if (this$livemode == null ? other$livemode != null : !((Object)this$livemode).equals(other$livemode)) {
            return false;
        }
        CustomerAcceptance this$customerAcceptance = this.getCustomerAcceptance();
        CustomerAcceptance other$customerAcceptance = other.getCustomerAcceptance();
        if (this$customerAcceptance == null ? other$customerAcceptance != null : !((Object)this$customerAcceptance).equals(other$customerAcceptance)) {
            return false;
        }
        String this$id = this.getId();
        String other$id = other.getId();
        if (this$id == null ? other$id != null : !this$id.equals(other$id)) {
            return false;
        }
        MultiUse this$multiUse = this.getMultiUse();
        MultiUse other$multiUse = other.getMultiUse();
        if (this$multiUse == null ? other$multiUse != null : !((Object)this$multiUse).equals(other$multiUse)) {
            return false;
        }
        String this$object = this.getObject();
        String other$object = other.getObject();
        if (this$object == null ? other$object != null : !this$object.equals(other$object)) {
            return false;
        }
        String this$paymentMethod = this.getPaymentMethod();
        String other$paymentMethod = other.getPaymentMethod();
        if (this$paymentMethod == null ? other$paymentMethod != null : !this$paymentMethod.equals(other$paymentMethod)) {
            return false;
        }
        PaymentMethodDetails this$paymentMethodDetails = this.getPaymentMethodDetails();
        PaymentMethodDetails other$paymentMethodDetails = other.getPaymentMethodDetails();
        if (this$paymentMethodDetails == null ? other$paymentMethodDetails != null : !((Object)this$paymentMethodDetails).equals(other$paymentMethodDetails)) {
            return false;
        }
        SingleUse this$singleUse = this.getSingleUse();
        SingleUse other$singleUse = other.getSingleUse();
        if (this$singleUse == null ? other$singleUse != null : !((Object)this$singleUse).equals(other$singleUse)) {
            return false;
        }
        String this$status = this.getStatus();
        String other$status = other.getStatus();
        if (this$status == null ? other$status != null : !this$status.equals(other$status)) {
            return false;
        }
        String this$type = this.getType();
        String other$type = other.getType();
        return !(this$type == null ? other$type != null : !this$type.equals(other$type));
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof Mandate;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Boolean $livemode = this.getLivemode();
        result = result * 59 + ($livemode == null ? 43 : ((Object)$livemode).hashCode());
        CustomerAcceptance $customerAcceptance = this.getCustomerAcceptance();
        result = result * 59 + ($customerAcceptance == null ? 43 : ((Object)$customerAcceptance).hashCode());
        String $id = this.getId();
        result = result * 59 + ($id == null ? 43 : $id.hashCode());
        MultiUse $multiUse = this.getMultiUse();
        result = result * 59 + ($multiUse == null ? 43 : ((Object)$multiUse).hashCode());
        String $object = this.getObject();
        result = result * 59 + ($object == null ? 43 : $object.hashCode());
        String $paymentMethod = this.getPaymentMethod();
        result = result * 59 + ($paymentMethod == null ? 43 : $paymentMethod.hashCode());
        PaymentMethodDetails $paymentMethodDetails = this.getPaymentMethodDetails();
        result = result * 59 + ($paymentMethodDetails == null ? 43 : ((Object)$paymentMethodDetails).hashCode());
        SingleUse $singleUse = this.getSingleUse();
        result = result * 59 + ($singleUse == null ? 43 : ((Object)$singleUse).hashCode());
        String $status = this.getStatus();
        result = result * 59 + ($status == null ? 43 : $status.hashCode());
        String $type = this.getType();
        result = result * 59 + ($type == null ? 43 : $type.hashCode());
        return result;
    }

    @Override
    @Generated
    public String getId() {
        return this.id;
    }

    public static class SingleUse
    extends StripeObject {
        @SerializedName(value="amount")
        Long amount;
        @SerializedName(value="currency")
        String currency;

        @Generated
        public Long getAmount() {
            return this.amount;
        }

        @Generated
        public String getCurrency() {
            return this.currency;
        }

        @Generated
        public void setAmount(Long amount) {
            this.amount = amount;
        }

        @Generated
        public void setCurrency(String currency) {
            this.currency = currency;
        }

        @Generated
        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof SingleUse)) {
                return false;
            }
            SingleUse other = (SingleUse)o;
            if (!other.canEqual(this)) {
                return false;
            }
            Long this$amount = this.getAmount();
            Long other$amount = other.getAmount();
            if (this$amount == null ? other$amount != null : !((Object)this$amount).equals(other$amount)) {
                return false;
            }
            String this$currency = this.getCurrency();
            String other$currency = other.getCurrency();
            return !(this$currency == null ? other$currency != null : !this$currency.equals(other$currency));
        }

        @Generated
        protected boolean canEqual(Object other) {
            return other instanceof SingleUse;
        }

        @Generated
        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            Long $amount = this.getAmount();
            result = result * 59 + ($amount == null ? 43 : ((Object)$amount).hashCode());
            String $currency = this.getCurrency();
            result = result * 59 + ($currency == null ? 43 : $currency.hashCode());
            return result;
        }
    }

    public static class PaymentMethodDetails
    extends StripeObject {
        @SerializedName(value="acss_debit")
        AcssDebit acssDebit;
        @SerializedName(value="au_becs_debit")
        AuBecsDebit auBecsDebit;
        @SerializedName(value="bacs_debit")
        BacsDebit bacsDebit;
        @SerializedName(value="card")
        Card card;
        @SerializedName(value="sepa_debit")
        SepaDebit sepaDebit;
        @SerializedName(value="type")
        String type;

        @Generated
        public AcssDebit getAcssDebit() {
            return this.acssDebit;
        }

        @Generated
        public AuBecsDebit getAuBecsDebit() {
            return this.auBecsDebit;
        }

        @Generated
        public BacsDebit getBacsDebit() {
            return this.bacsDebit;
        }

        @Generated
        public Card getCard() {
            return this.card;
        }

        @Generated
        public SepaDebit getSepaDebit() {
            return this.sepaDebit;
        }

        @Generated
        public String getType() {
            return this.type;
        }

        @Generated
        public void setAcssDebit(AcssDebit acssDebit) {
            this.acssDebit = acssDebit;
        }

        @Generated
        public void setAuBecsDebit(AuBecsDebit auBecsDebit) {
            this.auBecsDebit = auBecsDebit;
        }

        @Generated
        public void setBacsDebit(BacsDebit bacsDebit) {
            this.bacsDebit = bacsDebit;
        }

        @Generated
        public void setCard(Card card) {
            this.card = card;
        }

        @Generated
        public void setSepaDebit(SepaDebit sepaDebit) {
            this.sepaDebit = sepaDebit;
        }

        @Generated
        public void setType(String type) {
            this.type = type;
        }

        @Generated
        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof PaymentMethodDetails)) {
                return false;
            }
            PaymentMethodDetails other = (PaymentMethodDetails)o;
            if (!other.canEqual(this)) {
                return false;
            }
            AcssDebit this$acssDebit = this.getAcssDebit();
            AcssDebit other$acssDebit = other.getAcssDebit();
            if (this$acssDebit == null ? other$acssDebit != null : !((Object)this$acssDebit).equals(other$acssDebit)) {
                return false;
            }
            AuBecsDebit this$auBecsDebit = this.getAuBecsDebit();
            AuBecsDebit other$auBecsDebit = other.getAuBecsDebit();
            if (this$auBecsDebit == null ? other$auBecsDebit != null : !((Object)this$auBecsDebit).equals(other$auBecsDebit)) {
                return false;
            }
            BacsDebit this$bacsDebit = this.getBacsDebit();
            BacsDebit other$bacsDebit = other.getBacsDebit();
            if (this$bacsDebit == null ? other$bacsDebit != null : !((Object)this$bacsDebit).equals(other$bacsDebit)) {
                return false;
            }
            Card this$card = this.getCard();
            Card other$card = other.getCard();
            if (this$card == null ? other$card != null : !((Object)this$card).equals(other$card)) {
                return false;
            }
            SepaDebit this$sepaDebit = this.getSepaDebit();
            SepaDebit other$sepaDebit = other.getSepaDebit();
            if (this$sepaDebit == null ? other$sepaDebit != null : !((Object)this$sepaDebit).equals(other$sepaDebit)) {
                return false;
            }
            String this$type = this.getType();
            String other$type = other.getType();
            return !(this$type == null ? other$type != null : !this$type.equals(other$type));
        }

        @Generated
        protected boolean canEqual(Object other) {
            return other instanceof PaymentMethodDetails;
        }

        @Generated
        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            AcssDebit $acssDebit = this.getAcssDebit();
            result = result * 59 + ($acssDebit == null ? 43 : ((Object)$acssDebit).hashCode());
            AuBecsDebit $auBecsDebit = this.getAuBecsDebit();
            result = result * 59 + ($auBecsDebit == null ? 43 : ((Object)$auBecsDebit).hashCode());
            BacsDebit $bacsDebit = this.getBacsDebit();
            result = result * 59 + ($bacsDebit == null ? 43 : ((Object)$bacsDebit).hashCode());
            Card $card = this.getCard();
            result = result * 59 + ($card == null ? 43 : ((Object)$card).hashCode());
            SepaDebit $sepaDebit = this.getSepaDebit();
            result = result * 59 + ($sepaDebit == null ? 43 : ((Object)$sepaDebit).hashCode());
            String $type = this.getType();
            result = result * 59 + ($type == null ? 43 : $type.hashCode());
            return result;
        }

        public static class SepaDebit
        extends StripeObject {
            @SerializedName(value="reference")
            String reference;
            @SerializedName(value="url")
            String url;

            @Generated
            public String getReference() {
                return this.reference;
            }

            @Generated
            public String getUrl() {
                return this.url;
            }

            @Generated
            public void setReference(String reference) {
                this.reference = reference;
            }

            @Generated
            public void setUrl(String url) {
                this.url = url;
            }

            @Generated
            public boolean equals(Object o) {
                if (o == this) {
                    return true;
                }
                if (!(o instanceof SepaDebit)) {
                    return false;
                }
                SepaDebit other = (SepaDebit)o;
                if (!other.canEqual(this)) {
                    return false;
                }
                String this$reference = this.getReference();
                String other$reference = other.getReference();
                if (this$reference == null ? other$reference != null : !this$reference.equals(other$reference)) {
                    return false;
                }
                String this$url = this.getUrl();
                String other$url = other.getUrl();
                return !(this$url == null ? other$url != null : !this$url.equals(other$url));
            }

            @Generated
            protected boolean canEqual(Object other) {
                return other instanceof SepaDebit;
            }

            @Generated
            public int hashCode() {
                int PRIME = 59;
                int result = 1;
                String $reference = this.getReference();
                result = result * 59 + ($reference == null ? 43 : $reference.hashCode());
                String $url = this.getUrl();
                result = result * 59 + ($url == null ? 43 : $url.hashCode());
                return result;
            }
        }

        public static class Card
        extends StripeObject {
            @Generated
            public boolean equals(Object o) {
                if (o == this) {
                    return true;
                }
                if (!(o instanceof Card)) {
                    return false;
                }
                Card other = (Card)o;
                return other.canEqual(this);
            }

            @Generated
            protected boolean canEqual(Object other) {
                return other instanceof Card;
            }

            @Generated
            public int hashCode() {
                boolean result = true;
                return 1;
            }
        }

        public static class AcssDebit
        extends StripeObject {
            @SerializedName(value="interval_description")
            String intervalDescription;
            @SerializedName(value="payment_schedule")
            String paymentSchedule;
            @SerializedName(value="transaction_type")
            String transactionType;

            @Generated
            public String getIntervalDescription() {
                return this.intervalDescription;
            }

            @Generated
            public String getPaymentSchedule() {
                return this.paymentSchedule;
            }

            @Generated
            public String getTransactionType() {
                return this.transactionType;
            }

            @Generated
            public void setIntervalDescription(String intervalDescription) {
                this.intervalDescription = intervalDescription;
            }

            @Generated
            public void setPaymentSchedule(String paymentSchedule) {
                this.paymentSchedule = paymentSchedule;
            }

            @Generated
            public void setTransactionType(String transactionType) {
                this.transactionType = transactionType;
            }

            @Generated
            public boolean equals(Object o) {
                if (o == this) {
                    return true;
                }
                if (!(o instanceof AcssDebit)) {
                    return false;
                }
                AcssDebit other = (AcssDebit)o;
                if (!other.canEqual(this)) {
                    return false;
                }
                String this$intervalDescription = this.getIntervalDescription();
                String other$intervalDescription = other.getIntervalDescription();
                if (this$intervalDescription == null ? other$intervalDescription != null : !this$intervalDescription.equals(other$intervalDescription)) {
                    return false;
                }
                String this$paymentSchedule = this.getPaymentSchedule();
                String other$paymentSchedule = other.getPaymentSchedule();
                if (this$paymentSchedule == null ? other$paymentSchedule != null : !this$paymentSchedule.equals(other$paymentSchedule)) {
                    return false;
                }
                String this$transactionType = this.getTransactionType();
                String other$transactionType = other.getTransactionType();
                return !(this$transactionType == null ? other$transactionType != null : !this$transactionType.equals(other$transactionType));
            }

            @Generated
            protected boolean canEqual(Object other) {
                return other instanceof AcssDebit;
            }

            @Generated
            public int hashCode() {
                int PRIME = 59;
                int result = 1;
                String $intervalDescription = this.getIntervalDescription();
                result = result * 59 + ($intervalDescription == null ? 43 : $intervalDescription.hashCode());
                String $paymentSchedule = this.getPaymentSchedule();
                result = result * 59 + ($paymentSchedule == null ? 43 : $paymentSchedule.hashCode());
                String $transactionType = this.getTransactionType();
                result = result * 59 + ($transactionType == null ? 43 : $transactionType.hashCode());
                return result;
            }
        }
    }

    public static class MultiUse
    extends StripeObject {
        @Generated
        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof MultiUse)) {
                return false;
            }
            MultiUse other = (MultiUse)o;
            return other.canEqual(this);
        }

        @Generated
        protected boolean canEqual(Object other) {
            return other instanceof MultiUse;
        }

        @Generated
        public int hashCode() {
            boolean result = true;
            return 1;
        }
    }

    public static class CustomerAcceptance
    extends StripeObject {
        @SerializedName(value="accepted_at")
        Long acceptedAt;
        @SerializedName(value="offline")
        Offline offline;
        @SerializedName(value="online")
        Online online;
        @SerializedName(value="type")
        String type;

        @Generated
        public Long getAcceptedAt() {
            return this.acceptedAt;
        }

        @Generated
        public Offline getOffline() {
            return this.offline;
        }

        @Generated
        public Online getOnline() {
            return this.online;
        }

        @Generated
        public String getType() {
            return this.type;
        }

        @Generated
        public void setAcceptedAt(Long acceptedAt) {
            this.acceptedAt = acceptedAt;
        }

        @Generated
        public void setOffline(Offline offline) {
            this.offline = offline;
        }

        @Generated
        public void setOnline(Online online) {
            this.online = online;
        }

        @Generated
        public void setType(String type) {
            this.type = type;
        }

        @Generated
        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof CustomerAcceptance)) {
                return false;
            }
            CustomerAcceptance other = (CustomerAcceptance)o;
            if (!other.canEqual(this)) {
                return false;
            }
            Long this$acceptedAt = this.getAcceptedAt();
            Long other$acceptedAt = other.getAcceptedAt();
            if (this$acceptedAt == null ? other$acceptedAt != null : !((Object)this$acceptedAt).equals(other$acceptedAt)) {
                return false;
            }
            Offline this$offline = this.getOffline();
            Offline other$offline = other.getOffline();
            if (this$offline == null ? other$offline != null : !((Object)this$offline).equals(other$offline)) {
                return false;
            }
            Online this$online = this.getOnline();
            Online other$online = other.getOnline();
            if (this$online == null ? other$online != null : !((Object)this$online).equals(other$online)) {
                return false;
            }
            String this$type = this.getType();
            String other$type = other.getType();
            return !(this$type == null ? other$type != null : !this$type.equals(other$type));
        }

        @Generated
        protected boolean canEqual(Object other) {
            return other instanceof CustomerAcceptance;
        }

        @Generated
        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            Long $acceptedAt = this.getAcceptedAt();
            result = result * 59 + ($acceptedAt == null ? 43 : ((Object)$acceptedAt).hashCode());
            Offline $offline = this.getOffline();
            result = result * 59 + ($offline == null ? 43 : ((Object)$offline).hashCode());
            Online $online = this.getOnline();
            result = result * 59 + ($online == null ? 43 : ((Object)$online).hashCode());
            String $type = this.getType();
            result = result * 59 + ($type == null ? 43 : $type.hashCode());
            return result;
        }

        public static class Online
        extends StripeObject {
            @SerializedName(value="ip_address")
            String ipAddress;
            @SerializedName(value="user_agent")
            String userAgent;

            @Generated
            public String getIpAddress() {
                return this.ipAddress;
            }

            @Generated
            public String getUserAgent() {
                return this.userAgent;
            }

            @Generated
            public void setIpAddress(String ipAddress) {
                this.ipAddress = ipAddress;
            }

            @Generated
            public void setUserAgent(String userAgent) {
                this.userAgent = userAgent;
            }

            @Generated
            public boolean equals(Object o) {
                if (o == this) {
                    return true;
                }
                if (!(o instanceof Online)) {
                    return false;
                }
                Online other = (Online)o;
                if (!other.canEqual(this)) {
                    return false;
                }
                String this$ipAddress = this.getIpAddress();
                String other$ipAddress = other.getIpAddress();
                if (this$ipAddress == null ? other$ipAddress != null : !this$ipAddress.equals(other$ipAddress)) {
                    return false;
                }
                String this$userAgent = this.getUserAgent();
                String other$userAgent = other.getUserAgent();
                return !(this$userAgent == null ? other$userAgent != null : !this$userAgent.equals(other$userAgent));
            }

            @Generated
            protected boolean canEqual(Object other) {
                return other instanceof Online;
            }

            @Generated
            public int hashCode() {
                int PRIME = 59;
                int result = 1;
                String $ipAddress = this.getIpAddress();
                result = result * 59 + ($ipAddress == null ? 43 : $ipAddress.hashCode());
                String $userAgent = this.getUserAgent();
                result = result * 59 + ($userAgent == null ? 43 : $userAgent.hashCode());
                return result;
            }
        }

        public static class Offline
        extends StripeObject {
            @Generated
            public boolean equals(Object o) {
                if (o == this) {
                    return true;
                }
                if (!(o instanceof Offline)) {
                    return false;
                }
                Offline other = (Offline)o;
                return other.canEqual(this);
            }

            @Generated
            protected boolean canEqual(Object other) {
                return other instanceof Offline;
            }

            @Generated
            public int hashCode() {
                boolean result = true;
                return 1;
            }
        }
    }

    public static class BacsDebit
    extends StripeObject {
        @SerializedName(value="network_status")
        String networkStatus;
        @SerializedName(value="reference")
        String reference;
        @SerializedName(value="url")
        String url;

        @Generated
        public String getNetworkStatus() {
            return this.networkStatus;
        }

        @Generated
        public String getReference() {
            return this.reference;
        }

        @Generated
        public String getUrl() {
            return this.url;
        }

        @Generated
        public void setNetworkStatus(String networkStatus) {
            this.networkStatus = networkStatus;
        }

        @Generated
        public void setReference(String reference) {
            this.reference = reference;
        }

        @Generated
        public void setUrl(String url) {
            this.url = url;
        }

        @Generated
        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof BacsDebit)) {
                return false;
            }
            BacsDebit other = (BacsDebit)o;
            if (!other.canEqual(this)) {
                return false;
            }
            String this$networkStatus = this.getNetworkStatus();
            String other$networkStatus = other.getNetworkStatus();
            if (this$networkStatus == null ? other$networkStatus != null : !this$networkStatus.equals(other$networkStatus)) {
                return false;
            }
            String this$reference = this.getReference();
            String other$reference = other.getReference();
            if (this$reference == null ? other$reference != null : !this$reference.equals(other$reference)) {
                return false;
            }
            String this$url = this.getUrl();
            String other$url = other.getUrl();
            return !(this$url == null ? other$url != null : !this$url.equals(other$url));
        }

        @Generated
        protected boolean canEqual(Object other) {
            return other instanceof BacsDebit;
        }

        @Generated
        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            String $networkStatus = this.getNetworkStatus();
            result = result * 59 + ($networkStatus == null ? 43 : $networkStatus.hashCode());
            String $reference = this.getReference();
            result = result * 59 + ($reference == null ? 43 : $reference.hashCode());
            String $url = this.getUrl();
            result = result * 59 + ($url == null ? 43 : $url.hashCode());
            return result;
        }
    }

    public static class AuBecsDebit
    extends StripeObject {
        @SerializedName(value="url")
        String url;

        @Generated
        public String getUrl() {
            return this.url;
        }

        @Generated
        public void setUrl(String url) {
            this.url = url;
        }

        @Generated
        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof AuBecsDebit)) {
                return false;
            }
            AuBecsDebit other = (AuBecsDebit)o;
            if (!other.canEqual(this)) {
                return false;
            }
            String this$url = this.getUrl();
            String other$url = other.getUrl();
            return !(this$url == null ? other$url != null : !this$url.equals(other$url));
        }

        @Generated
        protected boolean canEqual(Object other) {
            return other instanceof AuBecsDebit;
        }

        @Generated
        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            String $url = this.getUrl();
            result = result * 59 + ($url == null ? 43 : $url.hashCode());
            return result;
        }
    }
}

