/*
 * Decompiled with CFR 0.152.
 */
package com.stripe.net;

import com.stripe.net.ApiResource;
import com.stripe.net.HttpContent;
import com.stripe.net.KeyValuePair;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.UnsupportedEncodingException;
import java.lang.reflect.Array;
import java.net.URLEncoder;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;

public final class FormEncoder {
    public static HttpContent createHttpContent(Map<String, Object> params) throws IOException {
        if (params == null) {
            return HttpContent.buildFormURLEncodedContent(new ArrayList<KeyValuePair<String, String>>());
        }
        List<KeyValuePair<String, Object>> flatParams = FormEncoder.flattenParams(params);
        if (flatParams.stream().allMatch(kvp -> kvp.getValue() instanceof String)) {
            Collection flatParamsString = flatParams.stream().filter(kvp -> kvp.getValue() instanceof String).map(kvp -> new KeyValuePair<String, String>((String)kvp.getKey(), (String)kvp.getValue())).collect(Collectors.toList());
            return HttpContent.buildFormURLEncodedContent(flatParamsString);
        }
        return HttpContent.buildMultipartFormDataContent(flatParams);
    }

    public static String createQueryString(Map<String, Object> params) {
        if (params == null) {
            return "";
        }
        Collection flatParams = FormEncoder.flattenParams(params).stream().filter(kvp -> kvp.getValue() instanceof String).map(kvp -> new KeyValuePair<String, String>((String)kvp.getKey(), (String)kvp.getValue())).collect(Collectors.toList());
        return FormEncoder.createQueryString(flatParams);
    }

    public static String createQueryString(Collection<KeyValuePair<String, String>> nameValueCollection) {
        if (nameValueCollection == null) {
            return "";
        }
        return String.join((CharSequence)"&", nameValueCollection.stream().map(kvp -> String.format("%s=%s", FormEncoder.urlEncode((String)kvp.getKey()), FormEncoder.urlEncode((String)kvp.getValue()))).collect(Collectors.toList()));
    }

    public static List<KeyValuePair<String, Object>> flattenParams(Map<String, Object> params) {
        return FormEncoder.flattenParamsValue(params, null);
    }

    private static String urlEncode(String value) {
        if (value == null) {
            return null;
        }
        try {
            return URLEncoder.encode(value, StandardCharsets.UTF_8.name()).replaceAll("%5B", "[").replaceAll("%5D", "]");
        }
        catch (UnsupportedEncodingException e) {
            throw new AssertionError((Object)"UTF-8 is unknown");
        }
    }

    private static List<KeyValuePair<String, Object>> flattenParamsValue(Object value, String keyPrefix) {
        List<KeyValuePair<String, Object>> flatParams = null;
        if (value == null) {
            flatParams = FormEncoder.singleParam(keyPrefix, "");
        } else if (value instanceof Map) {
            flatParams = FormEncoder.flattenParamsMap((Map)value, keyPrefix);
        } else if (value instanceof String) {
            flatParams = FormEncoder.singleParam(keyPrefix, value);
        } else if (value instanceof File) {
            flatParams = FormEncoder.singleParam(keyPrefix, value);
        } else if (value instanceof InputStream) {
            flatParams = FormEncoder.singleParam(keyPrefix, value);
        } else if (value instanceof Collection) {
            flatParams = FormEncoder.flattenParamsCollection((Collection)value, keyPrefix);
        } else if (value.getClass().isArray()) {
            Object[] array = FormEncoder.getArrayForObject(value);
            Collection collection = Arrays.stream(array).collect(Collectors.toList());
            flatParams = FormEncoder.flattenParamsCollection(collection, keyPrefix);
        } else {
            flatParams = value.getClass().isEnum() ? FormEncoder.singleParam(keyPrefix, ApiResource.GSON.toJson(value).replaceAll("\"", "")) : FormEncoder.singleParam(keyPrefix, value.toString());
        }
        return flatParams;
    }

    private static List<KeyValuePair<String, Object>> flattenParamsMap(Map<?, ?> map, String keyPrefix) {
        ArrayList<KeyValuePair<String, Object>> flatParams = new ArrayList<KeyValuePair<String, Object>>();
        if (map == null) {
            return flatParams;
        }
        for (Map.Entry<?, ?> entry : map.entrySet()) {
            String key = entry.getKey().toString();
            Object value = entry.getValue();
            String newPrefix = FormEncoder.newPrefix(key, keyPrefix);
            flatParams.addAll(FormEncoder.flattenParamsValue(value, newPrefix));
        }
        return flatParams;
    }

    private static List<KeyValuePair<String, Object>> flattenParamsCollection(Collection<?> collection, String keyPrefix) {
        ArrayList<KeyValuePair<String, Object>> flatParams = new ArrayList<KeyValuePair<String, Object>>();
        if (collection == null) {
            return flatParams;
        }
        int index = 0;
        for (Object value : collection) {
            String newPrefix = String.format("%s[%d]", keyPrefix, index);
            flatParams.addAll(FormEncoder.flattenParamsValue(value, newPrefix));
            ++index;
        }
        if (flatParams.isEmpty()) {
            flatParams.add(new KeyValuePair<String, String>(keyPrefix, ""));
        }
        return flatParams;
    }

    private static List<KeyValuePair<String, Object>> singleParam(String key, Object value) {
        ArrayList<KeyValuePair<String, Object>> flatParams = new ArrayList<KeyValuePair<String, Object>>();
        flatParams.add(new KeyValuePair<String, Object>(key, value));
        return flatParams;
    }

    private static String newPrefix(String key, String keyPrefix) {
        if (keyPrefix == null || keyPrefix.isEmpty()) {
            return key;
        }
        int i = key.indexOf("[");
        if (i == -1) {
            return String.format("%s[%s]", keyPrefix, key);
        }
        return String.format("%s[%s][%s]", keyPrefix, key.substring(0, i), key.substring(i));
    }

    private static Object[] getArrayForObject(Object array) {
        if (!array.getClass().isArray()) {
            throw new IllegalArgumentException("parameter is not an array");
        }
        if (!array.getClass().getComponentType().isPrimitive()) {
            return (Object[])array;
        }
        int length = Array.getLength(array);
        Object[] newArray = new Object[length];
        for (int index = 0; index < length; ++index) {
            newArray[index] = Array.get(array, index);
        }
        return newArray;
    }
}

