/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.module.common_impl;

import com.sun.enterprise.module.ModuleDefinition;
import com.sun.enterprise.module.ModuleDependency;
import com.sun.enterprise.module.ModuleMetadata;
import com.sun.enterprise.module.common_impl.Jar;
import com.sun.enterprise.module.common_impl.Tokenizer;
import java.io.File;
import java.io.IOException;
import java.net.URI;
import java.net.URLConnection;
import java.util.ArrayList;
import java.util.List;
import java.util.jar.Attributes;
import java.util.jar.Manifest;
import java.util.logging.Logger;

public class DefaultModuleDefinition
implements ModuleDefinition {
    private final String name;
    private final String version;
    private final String[] publicPkgs;
    protected final List<ModuleDependency> dependencies = new ArrayList<ModuleDependency>();
    protected final List<URI> classPath = new ArrayList<URI>();
    private final String importPolicy;
    private final String lifecyclePolicy;
    private final Manifest manifest;
    protected final Attributes mainAttributes;
    private final ModuleMetadata metadata = new ModuleMetadata();
    private static final Manifest EMPTY_MANIFEST = new Manifest();
    private static final Logger LOGGER = Logger.getLogger(DefaultModuleDefinition.class.getName());

    public DefaultModuleDefinition(File location) throws IOException {
        this(location, null);
    }

    public DefaultModuleDefinition(File location, Attributes attr) throws IOException {
        this.classPath.add(location.toURI());
        Jar jarFile = Jar.create(location);
        Manifest m = jarFile.getManifest();
        if (m == null) {
            m = EMPTY_MANIFEST;
        }
        this.manifest = m;
        if (attr == null) {
            attr = this.manifest.getMainAttributes();
        }
        if (attr == null) {
            attr = new Attributes();
        }
        this.mainAttributes = attr;
        this.name = attr.getValue("Bundle-SymbolicName") != null ? attr.getValue("Bundle-SymbolicName") : location.getName();
        this.parseClassPath(attr, location.toURI());
        String exported = attr.getValue("HK2-Export-Package");
        ArrayList<String> tmpList = new ArrayList<String>();
        for (String token : new Tokenizer(exported, ",")) {
            tmpList.add(token);
        }
        this.publicPkgs = tmpList.toArray(new String[tmpList.size()]);
        this.importPolicy = attr.getValue("HK2-Module-Import-Policy");
        this.lifecyclePolicy = attr.getValue("HK2-Module-Lifecycle-Policy");
        this.version = "1.0";
        this.parseAttributes(attr);
        jarFile.loadMetadata(this.metadata);
    }

    protected void parseClassPath(Attributes attr, URI baseURI) throws IOException {
        String classpath = attr.getValue("Class-Path");
        for (String classpathElement : new Tokenizer(classpath, " ")) {
            URI result;
            File ref = new File(classpathElement = this.decorateClassPath(classpathElement));
            if (!ref.isAbsolute()) {
                try {
                    result = baseURI.resolve(classpathElement);
                }
                catch (IllegalArgumentException e) {
                    throw new IllegalArgumentException("Unable to parse Class-Path entry '" + classpath + "' in " + baseURI);
                }
            } else {
                result = ref.toURI();
            }
            assert (this.testClassPath(result));
            File file = new File(result);
            if (!file.exists()) continue;
            Jar jar = Jar.create(file);
            Manifest m = jar.getManifest();
            if (m != null && m.getMainAttributes().getValue("HK2-Bundle-Name") == null) {
                jar.loadMetadata(this.metadata);
            }
            this.classPath.add(result);
        }
    }

    private boolean testClassPath(URI uri) {
        try {
            URLConnection c;
            if (uri.getScheme().equals("file") && (c = uri.toURL().openConnection()).getContentLength() == -1) {
                LOGGER.warning(uri + " pointed from " + this.name + " in classpath doesn't exist");
            }
        }
        catch (IOException e) {
            throw new AssertionError((Object)e);
        }
        return true;
    }

    protected String decorateClassPath(String classpathElement) {
        return classpathElement;
    }

    protected void parseAttributes(Attributes attr) {
    }

    public String getName() {
        return this.name;
    }

    public String[] getPublicInterfaces() {
        return (String[])this.publicPkgs.clone();
    }

    public ModuleDependency[] getDependencies() {
        return this.dependencies.toArray(new ModuleDependency[this.dependencies.size()]);
    }

    public URI[] getLocations() {
        return this.classPath.toArray(new URI[this.classPath.size()]);
    }

    public String getVersion() {
        return this.version;
    }

    public String getImportPolicyClassName() {
        return this.importPolicy;
    }

    public String getLifecyclePolicyClassName() {
        return this.lifecyclePolicy;
    }

    public Manifest getManifest() {
        return this.manifest;
    }

    public ModuleMetadata getMetadata() {
        return this.metadata;
    }

    public String toString() {
        return this.name + ':' + this.version;
    }
}

