/*
 * Decompiled with CFR 0.152.
 */
package com.sun.faces.facelets.tag.ui;

import com.sun.faces.facelets.util.DevTools;
import com.sun.faces.facelets.util.FastWriter;
import java.io.IOException;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import javax.faces.component.UIComponent;
import javax.faces.component.UIComponentBase;
import javax.faces.context.FacesContext;
import javax.faces.context.ResponseWriter;
import javax.servlet.http.HttpServletResponse;

public final class UIDebug
extends UIComponentBase {
    public static final String COMPONENT_TYPE = "facelets.ui.Debug";
    public static final String COMPONENT_FAMILY = "facelets";
    private static long nextId = System.currentTimeMillis();
    private static final String KEY = "facelets.ui.DebugOutput";
    public static final String DEFAULT_HOTKEY = "D";
    private String hotkey = "D";

    public UIDebug() {
        this.setTransient(true);
        this.setRendererType(null);
    }

    public String getFamily() {
        return COMPONENT_FAMILY;
    }

    public List getChildren() {
        return new ArrayList(){

            @Override
            public boolean add(Object o) {
                throw new IllegalStateException("<ui:debug> does not support children");
            }

            @Override
            public void add(int index, Object o) {
                throw new IllegalStateException("<ui:debug> does not support children");
            }
        };
    }

    public void encodeBegin(FacesContext facesContext) throws IOException {
        if (this.isRendered()) {
            this.pushComponentToEL(facesContext, (UIComponent)this);
            String actionId = facesContext.getApplication().getViewHandler().getActionURL(facesContext, facesContext.getViewRoot().getViewId());
            StringBuffer sb = new StringBuffer(512);
            sb.append("//<![CDATA[\n");
            sb.append("function faceletsDebug(URL) {");
            sb.append("day = new Date();");
            sb.append("id = day.getTime();");
            sb.append("eval(\"page\" + id + \" = window.open(URL, '\" + id + \"', 'toolbar=0,scrollbars=1,location=0,statusbar=0,menubar=0,resizable=1,width=800,height=600,left = 240,top = 212');\"); };");
            sb.append("(function() { if (typeof jsfFaceletsDebug === 'undefined') { var jsfFaceletsDebug = false; } if (!jsfFaceletsDebug) {");
            sb.append("var faceletsOrigKeyup = document.onkeyup;");
            sb.append("document.onkeyup = function(e) { if (window.event) e = window.event; if (String.fromCharCode(e.keyCode) == '" + this.getHotkey() + "' & e.shiftKey & e.ctrlKey) faceletsDebug('");
            sb.append(actionId);
            sb.append(actionId.indexOf(63) == -1 ? (char)'?' : '&');
            sb.append(KEY);
            sb.append('=');
            sb.append(UIDebug.writeDebugOutput(facesContext));
            sb.append("'); jsfFaceletsDebug = true; if (faceletsOrigKeyup) faceletsOrigKeyup(e); };\n");
            sb.append("}})();");
            sb.append("//]]>\n");
            ResponseWriter writer = facesContext.getResponseWriter();
            writer.startElement("span", (UIComponent)this);
            writer.writeAttribute("id", (Object)this.getClientId(facesContext), "id");
            writer.startElement("script", (UIComponent)this);
            writer.writeAttribute("language", (Object)"javascript", "language");
            writer.writeAttribute("type", (Object)"text/javascript", "type");
            writer.writeText((Object)sb.toString(), (UIComponent)this, null);
            writer.endElement("script");
            writer.endElement("span");
        }
    }

    private static String writeDebugOutput(FacesContext faces) throws IOException {
        FastWriter fw = new FastWriter();
        DevTools.debugHtml(fw, faces);
        Map session = faces.getExternalContext().getSessionMap();
        Map debugs = (Map)session.get(KEY);
        if (debugs == null) {
            debugs = new LinkedHashMap(){

                protected boolean removeEldestEntry(Map.Entry eldest) {
                    return this.size() > 5;
                }
            };
        }
        session.put(KEY, debugs);
        String id = "" + nextId++;
        debugs.put(id, fw.toString());
        return id;
    }

    private static String fetchDebugOutput(FacesContext faces, String id) {
        Map session = faces.getExternalContext().getSessionMap();
        Map debugs = (Map)session.get(KEY);
        if (debugs != null) {
            return (String)debugs.get(id);
        }
        return null;
    }

    public static boolean debugRequest(FacesContext faces) {
        String id = (String)faces.getExternalContext().getRequestParameterMap().get(KEY);
        if (id != null) {
            Object resp = faces.getExternalContext().getResponse();
            if (!faces.getResponseComplete() && resp instanceof HttpServletResponse) {
                try {
                    HttpServletResponse httpResp = (HttpServletResponse)resp;
                    String page = UIDebug.fetchDebugOutput(faces, id);
                    if (page != null) {
                        httpResp.setContentType("text/html");
                        httpResp.getWriter().write(page);
                    } else {
                        httpResp.setContentType("text/plain");
                        httpResp.getWriter().write("No Debug Output Available");
                    }
                    httpResp.flushBuffer();
                    faces.responseComplete();
                }
                catch (IOException e) {
                    return false;
                }
                return true;
            }
        }
        return false;
    }

    public String getHotkey() {
        return this.hotkey;
    }

    public void setHotkey(String hotkey) {
        this.hotkey = hotkey != null ? hotkey.toUpperCase() : "";
    }
}

