/*
 * Decompiled with CFR 0.152.
 */
package com.sun.faces.application.resource;

import com.sun.faces.application.resource.ContractInfo;
import com.sun.faces.application.resource.LibraryInfo;
import com.sun.faces.application.resource.ResourceHelper;
import com.sun.faces.application.resource.VersionInfo;

public class ResourceInfo {
    ResourceHelper helper;
    LibraryInfo library;
    ContractInfo contract;
    String libraryName;
    String localePrefix;
    String name;
    String path;
    VersionInfo version;
    boolean doNotCache = false;

    public ResourceInfo(LibraryInfo libraryInfo, ContractInfo contractInfo, String string, VersionInfo versionInfo) {
        this.contract = contractInfo;
        this.library = libraryInfo;
        this.helper = libraryInfo.getHelper();
        this.localePrefix = libraryInfo.getLocalePrefix();
        this.name = string;
        this.version = versionInfo;
        this.libraryName = libraryInfo.getName();
    }

    public ResourceInfo(ContractInfo contractInfo, String string, VersionInfo versionInfo, ResourceHelper resourceHelper) {
        this.contract = contractInfo;
        this.name = string;
        this.version = versionInfo;
        this.helper = resourceHelper;
    }

    public ResourceInfo(ResourceInfo resourceInfo, boolean bl) {
        this.helper = resourceInfo.helper;
        this.library = new LibraryInfo(resourceInfo.library, bl);
        this.libraryName = this.library.getName();
        if (bl) {
            this.localePrefix = resourceInfo.localePrefix;
        }
        this.name = resourceInfo.name;
        this.path = resourceInfo.path;
        this.version = resourceInfo.version;
    }

    public void copy(ResourceInfo resourceInfo) {
        this.helper = resourceInfo.helper;
        this.library = resourceInfo.library;
        this.libraryName = resourceInfo.libraryName;
        this.localePrefix = resourceInfo.localePrefix;
        this.name = resourceInfo.name;
        this.path = resourceInfo.path;
        this.version = resourceInfo.version;
    }

    public boolean equals(Object object) {
        if (object == null) {
            return false;
        }
        if (this.getClass() != object.getClass()) {
            return false;
        }
        ResourceInfo resourceInfo = (ResourceInfo)object;
        if (!(this.helper == resourceInfo.helper || this.helper != null && this.helper.equals(resourceInfo.helper))) {
            return false;
        }
        if (!(this.library == resourceInfo.library || this.library != null && this.library.equals(resourceInfo.library))) {
            return false;
        }
        if (this.libraryName == null ? resourceInfo.libraryName != null : !this.libraryName.equals(resourceInfo.libraryName)) {
            return false;
        }
        if (this.localePrefix == null ? resourceInfo.localePrefix != null : !this.localePrefix.equals(resourceInfo.localePrefix)) {
            return false;
        }
        if (this.name == null ? resourceInfo.name != null : !this.name.equals(resourceInfo.name)) {
            return false;
        }
        if (this.path == null ? resourceInfo.path != null : !this.path.equals(resourceInfo.path)) {
            return false;
        }
        if (!(this.version == resourceInfo.version || this.version != null && this.version.equals(resourceInfo.version))) {
            return false;
        }
        return this.doNotCache == resourceInfo.doNotCache;
    }

    public int hashCode() {
        int n = 7;
        n = 17 * n + (this.helper != null ? this.helper.hashCode() : 0);
        n = 17 * n + (this.library != null ? this.library.hashCode() : 0);
        n = 17 * n + (this.libraryName != null ? this.libraryName.hashCode() : 0);
        n = 17 * n + (this.localePrefix != null ? this.localePrefix.hashCode() : 0);
        n = 17 * n + (this.name != null ? this.name.hashCode() : 0);
        n = 17 * n + (this.path != null ? this.path.hashCode() : 0);
        n = 17 * n + (this.version != null ? this.version.hashCode() : 0);
        n = 17 * n + (this.doNotCache ? 1 : 0);
        return n;
    }

    public boolean isDoNotCache() {
        return this.doNotCache;
    }

    public void setDoNotCache(boolean bl) {
        this.doNotCache = bl;
    }

    public ResourceHelper getHelper() {
        return this.helper;
    }

    public LibraryInfo getLibraryInfo() {
        return this.library;
    }

    public String getLocalePrefix() {
        return this.localePrefix;
    }

    public String getName() {
        return this.name;
    }

    public String getPath() {
        return this.path;
    }

    public String getContract() {
        return null != this.contract ? this.contract.toString() : null;
    }

    public VersionInfo getVersion() {
        return this.version;
    }
}

