/*
 * Decompiled with CFR 0.152.
 */
package com.sun.faces.application.view;

import com.sun.faces.application.view.WriteBehindStateWriter;
import com.sun.faces.config.WebConfiguration;
import com.sun.faces.renderkit.RenderKitUtils;
import com.sun.faces.util.FacesLogger;
import com.sun.faces.util.MessageUtils;
import com.sun.faces.util.Util;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.net.URLDecoder;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.CopyOnWriteArraySet;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.faces.FacesException;
import javax.faces.FactoryFinder;
import javax.faces.application.ViewHandler;
import javax.faces.component.UIViewParameter;
import javax.faces.component.UIViewRoot;
import javax.faces.context.ExternalContext;
import javax.faces.context.FacesContext;
import javax.faces.render.ResponseStateManager;
import javax.faces.view.ViewDeclarationLanguage;
import javax.faces.view.ViewDeclarationLanguageFactory;
import javax.faces.view.ViewMetadata;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MultiViewHandler
extends ViewHandler {
    private static final Logger logger = FacesLogger.APPLICATION.getLogger();
    private String[] configuredExtensions;
    private Set<String> protectedViews;
    private boolean extensionsSet;
    private ViewDeclarationLanguageFactory vdlFactory;

    public MultiViewHandler() {
        WebConfiguration webConfiguration = WebConfiguration.getInstance();
        this.configuredExtensions = webConfiguration.getOptionValue(WebConfiguration.WebContextInitParameter.DefaultSuffix, " ");
        this.extensionsSet = webConfiguration.isSet(WebConfiguration.WebContextInitParameter.DefaultSuffix);
        this.vdlFactory = (ViewDeclarationLanguageFactory)FactoryFinder.getFactory((String)"javax.faces.view.ViewDeclarationLanguageFactory");
        this.protectedViews = new CopyOnWriteArraySet<String>();
    }

    public void initView(FacesContext facesContext) throws FacesException {
        super.initView(facesContext);
    }

    public void renderView(FacesContext facesContext, UIViewRoot uIViewRoot) throws IOException, FacesException {
        Util.notNull("context", facesContext);
        Util.notNull("viewToRender", uIViewRoot);
        this.vdlFactory.getViewDeclarationLanguage(uIViewRoot.getViewId()).renderView(facesContext, uIViewRoot);
    }

    public UIViewRoot restoreView(FacesContext facesContext, String string) {
        Util.notNull("context", facesContext);
        String string2 = this.derivePhysicalViewId(facesContext, string, false);
        return this.vdlFactory.getViewDeclarationLanguage(string2).restoreView(facesContext, string2);
    }

    public UIViewRoot createView(FacesContext facesContext, String string) {
        Util.notNull("context", facesContext);
        String string2 = this.derivePhysicalViewId(facesContext, string, false);
        return this.vdlFactory.getViewDeclarationLanguage(string2).createView(facesContext, string2);
    }

    public Locale calculateLocale(FacesContext facesContext) {
        Locale locale;
        Util.notNull("context", facesContext);
        Locale locale2 = null;
        Iterator iterator = facesContext.getExternalContext().getRequestLocales();
        while (iterator.hasNext() && (locale2 = this.findMatch(facesContext, locale = (Locale)iterator.next())) == null) {
        }
        if (locale2 == null) {
            locale2 = facesContext.getApplication().getDefaultLocale() == null ? Locale.getDefault() : facesContext.getApplication().getDefaultLocale();
        }
        return locale2;
    }

    public String calculateRenderKitId(FacesContext facesContext) {
        Util.notNull("context", facesContext);
        Map map = facesContext.getExternalContext().getRequestParameterMap();
        String string = (String)map.get("javax.faces.RenderKitId");
        if (string == null && null == (string = facesContext.getApplication().getDefaultRenderKitId())) {
            string = "HTML_BASIC";
        }
        return string;
    }

    public void writeState(FacesContext facesContext) throws IOException {
        Util.notNull("context", facesContext);
        if (!facesContext.getPartialViewContext().isAjaxRequest()) {
            WriteBehindStateWriter writeBehindStateWriter;
            if (logger.isLoggable(Level.FINE)) {
                logger.fine("Begin writing marker for viewId " + facesContext.getViewRoot().getViewId());
            }
            if ((writeBehindStateWriter = WriteBehindStateWriter.getCurrentInstance()) != null) {
                writeBehindStateWriter.writingState();
            }
            facesContext.getResponseWriter().write("~com.sun.faces.saveStateFieldMarker~");
            if (logger.isLoggable(Level.FINE)) {
                logger.fine("End writing marker for viewId " + facesContext.getViewRoot().getViewId());
            }
        }
    }

    public String getActionURL(FacesContext facesContext, String string) {
        String string2 = this.getActionURLWithoutViewProtection(facesContext, string);
        ViewHandler viewHandler = facesContext.getApplication().getViewHandler();
        Set set = viewHandler.getProtectedViewsUnmodifiable();
        boolean bl = false;
        for (String string3 : set) {
            if (string3.equals(string)) {
                bl = true;
            }
            if (!bl) continue;
            break;
        }
        if (bl) {
            String string3;
            StringBuilder stringBuilder = new StringBuilder(string2);
            if (string2.contains("?")) {
                stringBuilder.append("&");
            } else {
                stringBuilder.append("?");
            }
            string3 = viewHandler.calculateRenderKitId(facesContext);
            ResponseStateManager responseStateManager = RenderKitUtils.getResponseStateManager(facesContext, string3);
            String string4 = responseStateManager.getCryptographicallyStrongTokenFromSession(facesContext);
            stringBuilder.append("javax.faces.Token").append("=").append(string4);
            string2 = stringBuilder.toString();
        }
        return string2;
    }

    private String getActionURLWithoutViewProtection(FacesContext facesContext, String string) {
        Util.notNull("context", facesContext);
        Util.notNull("viewId", string);
        if (0 == string.length() || string.charAt(0) != '/') {
            String string2 = MessageUtils.getExceptionMessageString("com.sun.faces.ILLEGAL_VIEW_ID", string);
            if (logger.isLoggable(Level.SEVERE)) {
                logger.log(Level.SEVERE, "jsf.illegal_view_id_error", string);
            }
            throw new IllegalArgumentException(string2);
        }
        ExternalContext externalContext = facesContext.getExternalContext();
        String string3 = externalContext.getRequestContextPath();
        String string4 = Util.getFacesMapping(facesContext);
        if (string4 == null) {
            return string3 + string;
        }
        if (Util.isPrefixMapped(string4)) {
            if (string4.equals("/*")) {
                return string3 + string;
            }
            return string3 + string4 + string;
        }
        int n = string.lastIndexOf(46);
        if (n < 0) {
            return string3 + string + string4;
        }
        if (!string.endsWith(string4)) {
            for (String string5 : this.configuredExtensions) {
                if (!string.endsWith(string5)) continue;
                return string3 + string.substring(0, string.indexOf(string5)) + string4;
            }
            return string3 + string.substring(0, n) + string4;
        }
        return string3 + string;
    }

    public String getResourceURL(FacesContext facesContext, String string) {
        ExternalContext externalContext = facesContext.getExternalContext();
        if (string.charAt(0) == '/') {
            return externalContext.getRequestContextPath() + string;
        }
        return string;
    }

    public String getBookmarkableURL(FacesContext facesContext, String string, Map<String, List<String>> map, boolean bl) {
        Map<String, List<String>> map2 = bl ? this.getFullParameterList(facesContext, string, map) : map;
        ExternalContext externalContext = facesContext.getExternalContext();
        return externalContext.encodeActionURL(externalContext.encodeBookmarkableURL(Util.getViewHandler(facesContext).getActionURL(facesContext, string), map2));
    }

    public void addProtectedView(String string) {
        this.protectedViews.add(string);
    }

    public Set<String> getProtectedViewsUnmodifiable() {
        return Collections.unmodifiableSet(this.protectedViews);
    }

    public boolean removeProtectedView(String string) {
        return this.protectedViews.remove(string);
    }

    public String getRedirectURL(FacesContext facesContext, String string, Map<String, List<String>> map, boolean bl) {
        Map<Object, Object> map2;
        String string2;
        String string3 = (String)facesContext.getAttributes().get("facelets.Encoding");
        if (null == string3) {
            string3 = (String)facesContext.getViewRoot().getAttributes().get("facelets.Encoding");
        }
        String string4 = string2 = null != string3 ? string3 : facesContext.getExternalContext().getResponseCharacterEncoding();
        if (map != null) {
            map2 = new HashMap();
            for (Map.Entry entry : map.entrySet()) {
                String string5 = (String)entry.getKey();
                List list = (List)entry.getValue();
                ArrayList<String> arrayList = new ArrayList<String>();
                for (String string6 : list) {
                    try {
                        string6 = URLDecoder.decode(string6, string2);
                    }
                    catch (UnsupportedEncodingException unsupportedEncodingException) {
                        throw new RuntimeException("Unable to decode");
                    }
                    arrayList.add(string6);
                }
                map2.put(string5, arrayList);
            }
            map = map2;
        }
        map2 = bl ? this.getFullParameterList(facesContext, string, map) : map;
        ExternalContext externalContext = facesContext.getExternalContext();
        return externalContext.encodeActionURL(externalContext.encodeRedirectURL(Util.getViewHandler(facesContext).getActionURL(facesContext, string), map2));
    }

    public ViewDeclarationLanguage getViewDeclarationLanguage(FacesContext facesContext, String string) {
        return this.vdlFactory.getViewDeclarationLanguage(string);
    }

    public String deriveViewId(FacesContext facesContext, String string) {
        return this.derivePhysicalViewId(facesContext, string, true);
    }

    public String deriveLogicalViewId(FacesContext facesContext, String string) {
        return this.derivePhysicalViewId(facesContext, string, false);
    }

    protected String normalizeRequestURI(String string, String string2) {
        if (string2 == null || !Util.isPrefixMapped(string2)) {
            return string;
        }
        int n = string2.length() + 1;
        StringBuilder stringBuilder = new StringBuilder(n);
        stringBuilder.append(string2).append('/');
        String string3 = stringBuilder.toString();
        boolean bl = false;
        while (string.startsWith(string3)) {
            if (!bl && logger.isLoggable(Level.WARNING)) {
                bl = true;
                logger.log(Level.WARNING, "jsf.viewhandler.requestpath.recursion", new Object[]{string, string2});
            }
            string = string.substring(n - 1);
        }
        return string;
    }

    protected String convertViewId(FacesContext facesContext, String string) {
        int n = string.lastIndexOf(46);
        int n2 = string.length();
        StringBuilder stringBuilder = new StringBuilder(n2);
        for (String string2 : this.configuredExtensions) {
            if (string.endsWith(string2)) {
                return string;
            }
            this.appendOrReplaceExtension(string, string2, n2, n, stringBuilder);
            String string3 = stringBuilder.toString();
            ViewDeclarationLanguage viewDeclarationLanguage = this.getViewDeclarationLanguage(facesContext, string3);
            if (!viewDeclarationLanguage.viewExists(facesContext, string3)) continue;
            return string3;
        }
        return this.legacyConvertViewId(string, n2, n, stringBuilder);
    }

    protected String derivePhysicalViewId(FacesContext facesContext, String string, boolean bl) {
        String string2;
        if (string != null && (string2 = Util.getFacesMapping(facesContext)) != null) {
            String string3;
            if (!Util.isPrefixMapped(string2)) {
                string3 = this.convertViewId(facesContext, string);
            } else {
                string3 = this.normalizeRequestURI(string, string2);
                if (string3.equals(string2)) {
                    this.send404Error(facesContext);
                }
            }
            if (bl) {
                ViewDeclarationLanguage viewDeclarationLanguage = this.getViewDeclarationLanguage(facesContext, string3);
                return viewDeclarationLanguage.viewExists(facesContext, string3) ? string3 : null;
            }
            return string3;
        }
        return string;
    }

    protected Map<String, List<String>> getFullParameterList(FacesContext facesContext, String string, Map<String, List<String>> map) {
        LinkedHashMap<Object, Object> linkedHashMap = map == null || map.isEmpty() ? new LinkedHashMap(4) : new LinkedHashMap<String, List<String>>(map);
        this.addViewParameters(facesContext, string, linkedHashMap);
        return linkedHashMap;
    }

    protected void addViewParameters(FacesContext facesContext, String string, Map<String, List<String>> map) {
        Object object;
        UIViewRoot uIViewRoot = facesContext.getViewRoot();
        String string2 = uIViewRoot.getViewId();
        Collection<Object> collection = Collections.emptyList();
        boolean bl = false;
        Collection collection2 = ViewMetadata.getViewParameters((UIViewRoot)uIViewRoot);
        if (string2.equals(string)) {
            bl = true;
            collection = collection2;
        } else {
            ViewDeclarationLanguage viewDeclarationLanguage = this.getViewDeclarationLanguage(facesContext, string);
            ViewMetadata viewMetadata = viewDeclarationLanguage.getViewMetadata(facesContext, string);
            if (null != viewMetadata) {
                object = viewMetadata.createMetadataView(facesContext);
                collection = ViewMetadata.getViewParameters((UIViewRoot)object);
            }
        }
        if (collection.isEmpty()) {
            return;
        }
        for (UIViewParameter uIViewParameter : collection) {
            object = null;
            if (map.containsKey(uIViewParameter.getName())) continue;
            if (MultiViewHandler.paramHasValueExpression(uIViewParameter)) {
                object = uIViewParameter.getStringValueFromModel(facesContext);
            }
            if (object == null) {
                object = bl ? uIViewParameter.getStringValue(facesContext) : MultiViewHandler.getStringValueToTransfer(facesContext, uIViewParameter, collection2);
            }
            if (object == null) continue;
            List<String> list = map.get(uIViewParameter.getName());
            if (list == null) {
                list = new ArrayList<String>(4);
                map.put(uIViewParameter.getName(), list);
            }
            list.add((String)object);
        }
    }

    protected Locale findMatch(FacesContext facesContext, Locale locale) {
        Locale locale2;
        Locale locale3 = null;
        Iterator iterator = facesContext.getApplication().getSupportedLocales();
        while (iterator.hasNext()) {
            locale2 = (Locale)iterator.next();
            if (locale.equals(locale2)) {
                locale3 = locale2;
                break;
            }
            if (!locale.getLanguage().equals(locale2.getLanguage()) || locale2.getCountry().length() != 0) continue;
            locale3 = locale2;
        }
        if (null == locale3 && (locale2 = facesContext.getApplication().getDefaultLocale()) != null) {
            if (locale.equals(locale2)) {
                locale3 = locale2;
            } else if (locale.getLanguage().equals(locale2.getLanguage()) && locale2.getCountry().length() == 0) {
                locale3 = locale2;
            }
        }
        return locale3;
    }

    protected void send404Error(FacesContext facesContext) {
        try {
            facesContext.responseComplete();
            facesContext.getExternalContext().responseSendError(404, "");
        }
        catch (IOException iOException) {
            throw new FacesException((Throwable)iOException);
        }
    }

    private static boolean paramHasValueExpression(UIViewParameter uIViewParameter) {
        return uIViewParameter.getValueExpression("value") != null;
    }

    private static String getStringValueToTransfer(FacesContext facesContext, UIViewParameter uIViewParameter, Collection<UIViewParameter> collection) {
        if (collection != null && !collection.isEmpty()) {
            for (UIViewParameter uIViewParameter2 : collection) {
                if (null == uIViewParameter2.getName() || null == uIViewParameter.getName() || !uIViewParameter2.getName().equals(uIViewParameter.getName())) continue;
                return uIViewParameter2.getStringValue(facesContext);
            }
        }
        return uIViewParameter.getStringValue(facesContext);
    }

    private void appendOrReplaceExtension(String string, String string2, int n, int n2, StringBuilder stringBuilder) {
        stringBuilder.setLength(0);
        stringBuilder.append(string);
        if (n2 != -1) {
            stringBuilder.replace(n2, n, string2);
        } else {
            stringBuilder.append(string2);
        }
    }

    private String legacyConvertViewId(String string, int n, int n2, StringBuilder stringBuilder) {
        String string2;
        String string3 = string2 = this.extensionsSet && this.configuredExtensions.length != 0 ? this.configuredExtensions[0] : ".jsp";
        if (string.endsWith(string2)) {
            return string;
        }
        this.appendOrReplaceExtension(string, string2, n, n2, stringBuilder);
        return stringBuilder.toString();
    }
}

