/*
 * Decompiled with CFR 0.152.
 */
package com.sun.faces.context;

import com.sun.faces.el.ELContextImpl;
import com.sun.faces.el.ELUtils;
import com.sun.faces.renderkit.RenderKitUtils;
import com.sun.faces.util.FacesLogger;
import com.sun.faces.util.Util;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.el.ELContext;
import javax.el.ELContextEvent;
import javax.el.ELContextListener;
import javax.el.ExpressionFactory;
import javax.faces.FactoryFinder;
import javax.faces.application.Application;
import javax.faces.application.ApplicationFactory;
import javax.faces.application.FacesMessage;
import javax.faces.application.ViewHandler;
import javax.faces.component.UIViewRoot;
import javax.faces.context.ExceptionHandler;
import javax.faces.context.ExternalContext;
import javax.faces.context.FacesContext;
import javax.faces.context.PartialViewContext;
import javax.faces.context.PartialViewContextFactory;
import javax.faces.context.ResponseStream;
import javax.faces.context.ResponseWriter;
import javax.faces.event.PhaseId;
import javax.faces.lifecycle.Lifecycle;
import javax.faces.render.RenderKit;
import javax.faces.render.RenderKitFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class FacesContextImpl
extends FacesContext {
    private static final String POST_BACK_MARKER = FacesContextImpl.class.getName() + "_POST_BACK";
    private static final ThreadLocal<FacesContext> DEFAULT_FACES_CONTEXT = new ThreadLocal();
    private static final Logger LOGGER = FacesLogger.CONTEXT.getLogger();
    private boolean released;
    private ResponseStream responseStream = null;
    private ResponseWriter responseWriter = null;
    private ExternalContext externalContext = null;
    private Application application = null;
    private UIViewRoot viewRoot = null;
    private ELContext elContext = null;
    private RenderKitFactory rkFactory;
    private RenderKit lastRk;
    private String lastRkId;
    private FacesMessage.Severity maxSeverity;
    private boolean renderResponse = false;
    private boolean responseComplete = false;
    private boolean validationFailed = false;
    private Map<Object, Object> attributes;
    private List<String> resourceLibraryContracts;
    private PhaseId currentPhaseId;
    private PartialViewContext partialViewContext = null;
    private ExceptionHandler exceptionHandler = null;
    private Map<String, List<FacesMessage>> componentMessageLists;

    public FacesContextImpl(ExternalContext externalContext, Lifecycle lifecycle) {
        Util.notNull("ec", externalContext);
        Util.notNull("lifecycle", lifecycle);
        this.externalContext = externalContext;
        FacesContextImpl.setCurrentInstance((FacesContext)this);
        DEFAULT_FACES_CONTEXT.set(this);
        this.rkFactory = (RenderKitFactory)FactoryFinder.getFactory((String)"javax.faces.render.RenderKitFactory");
    }

    public ExternalContext getExternalContext() {
        this.assertNotReleased();
        return this.externalContext;
    }

    public Application getApplication() {
        this.assertNotReleased();
        if (null != this.application) {
            return this.application;
        }
        ApplicationFactory applicationFactory = (ApplicationFactory)FactoryFinder.getFactory((String)"javax.faces.application.ApplicationFactory");
        this.application = applicationFactory.getApplication();
        assert (null != this.application);
        return this.application;
    }

    public ExceptionHandler getExceptionHandler() {
        return this.exceptionHandler;
    }

    public void setExceptionHandler(ExceptionHandler exceptionHandler) {
        this.exceptionHandler = exceptionHandler;
    }

    public PartialViewContext getPartialViewContext() {
        this.assertNotReleased();
        if (this.partialViewContext == null) {
            PartialViewContextFactory partialViewContextFactory = (PartialViewContextFactory)FactoryFinder.getFactory((String)"javax.faces.context.PartialViewContextFactory");
            this.partialViewContext = partialViewContextFactory.getPartialViewContext(FacesContext.getCurrentInstance());
        }
        return this.partialViewContext;
    }

    public boolean isPostback() {
        this.assertNotReleased();
        Boolean bl = (Boolean)this.getAttributes().get(POST_BACK_MARKER);
        if (bl == null) {
            RenderKit renderKit = this.getRenderKit();
            if (renderKit != null) {
                bl = renderKit.getResponseStateManager().isPostback((FacesContext)this);
            } else {
                ViewHandler viewHandler = this.getApplication().getViewHandler();
                String string = viewHandler.calculateRenderKitId((FacesContext)this);
                bl = RenderKitUtils.getResponseStateManager(this, string).isPostback((FacesContext)this);
            }
            this.getAttributes().put(POST_BACK_MARKER, bl);
        }
        return bl;
    }

    public boolean isReleased() {
        return this.released;
    }

    public Map<Object, Object> getAttributes() {
        this.assertNotReleased();
        if (this.attributes == null) {
            this.attributes = new HashMap<Object, Object>();
        }
        return this.attributes;
    }

    public ELContext getELContext() {
        this.assertNotReleased();
        if (this.elContext == null) {
            ELContextListener[] eLContextListenerArray;
            UIViewRoot uIViewRoot;
            Application application = this.getApplication();
            this.elContext = new ELContextImpl(application.getELResolver());
            FacesContext facesContext = FacesContext.getCurrentInstance();
            this.elContext.putContext(FacesContext.class, (Object)facesContext);
            ExpressionFactory expressionFactory = ELUtils.getDefaultExpressionFactory(facesContext);
            if (null != expressionFactory) {
                this.elContext.putContext(ExpressionFactory.class, (Object)expressionFactory);
            }
            if (null != (uIViewRoot = this.getViewRoot())) {
                this.elContext.setLocale(uIViewRoot.getLocale());
            }
            if ((eLContextListenerArray = application.getELContextListeners()).length > 0) {
                ELContextEvent eLContextEvent = new ELContextEvent(this.elContext);
                for (ELContextListener eLContextListener : eLContextListenerArray) {
                    eLContextListener.contextCreated(eLContextEvent);
                }
            }
        }
        return this.elContext;
    }

    public Iterator<String> getClientIdsWithMessages() {
        this.assertNotReleased();
        return this.componentMessageLists == null ? Collections.emptyList().iterator() : this.componentMessageLists.keySet().iterator();
    }

    public FacesMessage.Severity getMaximumSeverity() {
        this.assertNotReleased();
        FacesMessage.Severity severity = null;
        if (this.componentMessageLists != null && !this.componentMessageLists.isEmpty()) {
            ComponentMessagesIterator componentMessagesIterator = new ComponentMessagesIterator(this.componentMessageLists);
            while (componentMessagesIterator.hasNext()) {
                FacesMessage.Severity severity2 = ((FacesMessage)componentMessagesIterator.next()).getSeverity();
                if (severity == null || severity2.compareTo((Object)severity) > 0) {
                    severity = severity2;
                }
                if (severity != FacesMessage.SEVERITY_FATAL) continue;
                break;
            }
        }
        return severity;
    }

    public List<FacesMessage> getMessageList() {
        this.assertNotReleased();
        if (null == this.componentMessageLists) {
            return Collections.unmodifiableList(Collections.emptyList());
        }
        ArrayList<FacesMessage> arrayList = new ArrayList<FacesMessage>();
        for (List<FacesMessage> list : this.componentMessageLists.values()) {
            arrayList.addAll(list);
        }
        return Collections.unmodifiableList(arrayList);
    }

    public List<FacesMessage> getMessageList(String string) {
        this.assertNotReleased();
        if (null == this.componentMessageLists) {
            return Collections.unmodifiableList(Collections.emptyList());
        }
        List<FacesMessage> list = this.componentMessageLists.get(string);
        return Collections.unmodifiableList(list != null ? list : Collections.emptyList());
    }

    public Iterator<FacesMessage> getMessages() {
        this.assertNotReleased();
        if (null == this.componentMessageLists) {
            List list = Collections.emptyList();
            return list.iterator();
        }
        if (this.componentMessageLists.size() > 0) {
            return new ComponentMessagesIterator(this.componentMessageLists);
        }
        List list = Collections.emptyList();
        return list.iterator();
    }

    public Iterator<FacesMessage> getMessages(String string) {
        this.assertNotReleased();
        if (null == this.componentMessageLists) {
            List list = Collections.emptyList();
            return list.iterator();
        }
        List<FacesMessage> list = this.componentMessageLists.get(string);
        if (list == null) {
            List list2 = Collections.emptyList();
            return list2.iterator();
        }
        return list.iterator();
    }

    public RenderKit getRenderKit() {
        this.assertNotReleased();
        UIViewRoot uIViewRoot = this.getViewRoot();
        if (uIViewRoot == null) {
            return null;
        }
        String string = uIViewRoot.getRenderKitId();
        if (string == null) {
            return null;
        }
        if (string.equals(this.lastRkId)) {
            return this.lastRk;
        }
        this.lastRk = this.rkFactory.getRenderKit((FacesContext)this, string);
        if (this.lastRk == null && LOGGER.isLoggable(Level.SEVERE)) {
            LOGGER.log(Level.SEVERE, "Unable to locate renderkit instance for render-kit-id {0}.  Using {1} instead.", new String[]{string, "HTML_BASIC"});
        }
        this.lastRkId = string;
        return this.lastRk;
    }

    public ResponseStream getResponseStream() {
        this.assertNotReleased();
        return this.responseStream;
    }

    public void setResponseStream(ResponseStream responseStream) {
        this.assertNotReleased();
        Util.notNull("responseStrean", responseStream);
        this.responseStream = responseStream;
    }

    public UIViewRoot getViewRoot() {
        this.assertNotReleased();
        return this.viewRoot;
    }

    public void setViewRoot(UIViewRoot uIViewRoot) {
        Map map;
        this.assertNotReleased();
        Util.notNull("root", uIViewRoot);
        if (this.viewRoot != null && !this.viewRoot.equals(uIViewRoot) && (map = this.viewRoot.getViewMap(false)) != null) {
            this.viewRoot.getViewMap().clear();
        }
        this.viewRoot = uIViewRoot;
    }

    public ResponseWriter getResponseWriter() {
        this.assertNotReleased();
        return this.responseWriter;
    }

    public void setResponseWriter(ResponseWriter responseWriter) {
        this.assertNotReleased();
        Util.notNull("responseWriter", responseWriter);
        this.responseWriter = responseWriter;
    }

    public void addMessage(String string, FacesMessage facesMessage) {
        Object object;
        this.assertNotReleased();
        Util.notNull("message", facesMessage);
        if (this.maxSeverity == null) {
            this.maxSeverity = facesMessage.getSeverity();
        } else {
            object = facesMessage.getSeverity();
            if (object.getOrdinal() > this.maxSeverity.getOrdinal()) {
                this.maxSeverity = object;
            }
        }
        if (this.componentMessageLists == null) {
            this.componentMessageLists = new LinkedHashMap<String, List<FacesMessage>>();
        }
        if ((object = this.componentMessageLists.get(string)) == null) {
            object = new ArrayList();
            this.componentMessageLists.put(string, (List<FacesMessage>)object);
        }
        object.add(facesMessage);
        if (LOGGER.isLoggable(Level.FINE)) {
            LOGGER.fine("Adding Message[sourceId=" + (string != null ? string : "<<NONE>>") + ",summary=" + facesMessage.getSummary() + ")");
        }
    }

    public PhaseId getCurrentPhaseId() {
        this.assertNotReleased();
        return this.currentPhaseId;
    }

    public void setCurrentPhaseId(PhaseId phaseId) {
        this.assertNotReleased();
        this.currentPhaseId = phaseId;
    }

    public void release() {
        this.released = true;
        this.externalContext = null;
        this.responseStream = null;
        this.responseWriter = null;
        this.componentMessageLists = null;
        this.renderResponse = false;
        this.responseComplete = false;
        this.validationFailed = false;
        this.viewRoot = null;
        this.maxSeverity = null;
        this.application = null;
        this.currentPhaseId = null;
        if (this.attributes != null) {
            this.attributes.clear();
            this.attributes = null;
        }
        if (null != this.resourceLibraryContracts) {
            this.resourceLibraryContracts.clear();
            this.resourceLibraryContracts = null;
        }
        if (this.partialViewContext != null) {
            this.partialViewContext.release();
        }
        this.partialViewContext = null;
        this.exceptionHandler = null;
        this.elContext = null;
        this.rkFactory = null;
        this.lastRk = null;
        this.lastRkId = null;
        FacesContextImpl.setCurrentInstance(null);
        DEFAULT_FACES_CONTEXT.remove();
    }

    public void renderResponse() {
        this.assertNotReleased();
        this.renderResponse = true;
    }

    public void responseComplete() {
        this.assertNotReleased();
        this.responseComplete = true;
    }

    public void validationFailed() {
        this.assertNotReleased();
        this.validationFailed = true;
    }

    public boolean getRenderResponse() {
        this.assertNotReleased();
        return this.renderResponse;
    }

    public List<String> getResourceLibraryContracts() {
        this.assertNotReleased();
        return null == this.resourceLibraryContracts ? Collections.EMPTY_LIST : this.resourceLibraryContracts;
    }

    public void setResourceLibraryContracts(List<String> list) {
        this.assertNotReleased();
        if (null == list || list.isEmpty()) {
            if (null != this.resourceLibraryContracts) {
                this.resourceLibraryContracts.clear();
                this.resourceLibraryContracts = null;
            }
        } else {
            this.resourceLibraryContracts = new ArrayList<String>(list);
        }
    }

    public boolean getResponseComplete() {
        this.assertNotReleased();
        return this.responseComplete;
    }

    public boolean isValidationFailed() {
        this.assertNotReleased();
        return this.validationFailed;
    }

    public static FacesContext getDefaultFacesContext() {
        return DEFAULT_FACES_CONTEXT.get();
    }

    private final void assertNotReleased() {
        if (this.released) {
            throw new IllegalStateException();
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static final class ComponentMessagesIterator
    implements Iterator<FacesMessage> {
        private Map<String, List<FacesMessage>> messages;
        private int outerIndex = -1;
        private int messagesSize;
        private Iterator<FacesMessage> inner;
        private Iterator<String> keys;

        ComponentMessagesIterator(Map<String, List<FacesMessage>> map) {
            this.messages = map;
            this.messagesSize = map.size();
            this.keys = map.keySet().iterator();
        }

        @Override
        public boolean hasNext() {
            if (this.outerIndex == -1) {
                ++this.outerIndex;
                this.inner = this.messages.get(this.keys.next()).iterator();
            }
            while (!this.inner.hasNext()) {
                ++this.outerIndex;
                if (this.outerIndex < this.messagesSize) {
                    this.inner = this.messages.get(this.keys.next()).iterator();
                    continue;
                }
                return false;
            }
            return this.inner.hasNext();
        }

        @Override
        public FacesMessage next() {
            if (this.outerIndex >= this.messagesSize) {
                throw new NoSuchElementException();
            }
            if (this.inner != null && this.inner.hasNext()) {
                return this.inner.next();
            }
            if (!this.hasNext()) {
                throw new NoSuchElementException();
            }
            return this.inner.next();
        }

        @Override
        public void remove() {
            if (this.outerIndex == -1) {
                throw new IllegalStateException();
            }
            this.inner.remove();
        }
    }
}

