/*
 * Decompiled with CFR 0.152.
 */
package com.sun.faces.facelets.tag.jsf.core;

import com.sun.faces.facelets.tag.TagHandlerImpl;
import com.sun.faces.facelets.tag.jsf.ComponentSupport;
import com.sun.faces.facelets.util.ReflectionUtil;
import java.io.IOException;
import java.io.Serializable;
import java.util.List;
import javax.el.ELContext;
import javax.el.ValueExpression;
import javax.faces.component.UIComponent;
import javax.faces.component.UIViewRoot;
import javax.faces.context.FacesContext;
import javax.faces.event.AbortProcessingException;
import javax.faces.event.PhaseEvent;
import javax.faces.event.PhaseId;
import javax.faces.event.PhaseListener;
import javax.faces.view.facelets.ComponentHandler;
import javax.faces.view.facelets.FaceletContext;
import javax.faces.view.facelets.TagAttribute;
import javax.faces.view.facelets.TagAttributeException;
import javax.faces.view.facelets.TagConfig;
import javax.faces.view.facelets.TagException;

public class PhaseListenerHandler
extends TagHandlerImpl {
    private final TagAttribute binding = this.getAttribute("binding");
    private final String listenerType;
    private final TagAttribute typeAttribute = this.getAttribute("type");

    public PhaseListenerHandler(TagConfig tagConfig) {
        super(tagConfig);
        if (null != this.typeAttribute) {
            String string = null;
            if (!this.typeAttribute.isLiteral()) {
                FacesContext facesContext = FacesContext.getCurrentInstance();
                FaceletContext faceletContext = (FaceletContext)facesContext.getAttributes().get("javax.faces.FACELET_CONTEXT");
                string = (String)this.typeAttribute.getValueExpression(faceletContext, String.class).getValue((ELContext)faceletContext);
            } else {
                string = this.typeAttribute.getValue();
            }
            this.checkType(string);
            this.listenerType = string;
        } else {
            this.listenerType = null;
        }
    }

    public void apply(FaceletContext faceletContext, UIComponent uIComponent) throws IOException {
        if (ComponentHandler.isNew((UIComponent)uIComponent)) {
            UIViewRoot uIViewRoot = ComponentSupport.getViewRoot(faceletContext, uIComponent);
            if (uIViewRoot == null) {
                throw new TagException(this.tag, "UIViewRoot not available");
            }
            ValueExpression valueExpression = null;
            if (this.binding != null) {
                valueExpression = this.binding.getValueExpression(faceletContext, PhaseListener.class);
            }
            LazyPhaseListener lazyPhaseListener = new LazyPhaseListener(this.listenerType, valueExpression);
            List list = uIViewRoot.getPhaseListeners();
            if (!list.contains(lazyPhaseListener)) {
                uIViewRoot.addPhaseListener((PhaseListener)lazyPhaseListener);
            }
        }
    }

    private void checkType(String string) {
        try {
            ReflectionUtil.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new TagAttributeException(this.typeAttribute, "Couldn't qualify ActionListener", (Throwable)classNotFoundException);
        }
    }

    private static final class LazyPhaseListener
    implements PhaseListener,
    Serializable {
        private static final long serialVersionUID = -6496143057319213401L;
        private final String type;
        private final ValueExpression binding;

        public LazyPhaseListener(String string, ValueExpression valueExpression) {
            this.type = string;
            this.binding = valueExpression;
        }

        private PhaseListener getInstance() {
            PhaseListener phaseListener = null;
            FacesContext facesContext = FacesContext.getCurrentInstance();
            if (facesContext == null) {
                return null;
            }
            if (this.binding != null) {
                phaseListener = (PhaseListener)this.binding.getValue(facesContext.getELContext());
            }
            if (phaseListener == null && this.type != null) {
                try {
                    phaseListener = (PhaseListener)ReflectionUtil.forName(this.type).newInstance();
                }
                catch (Exception exception) {
                    throw new AbortProcessingException("Couldn't Lazily instantiate PhaseListener", (Throwable)exception);
                }
                if (this.binding != null) {
                    this.binding.setValue(facesContext.getELContext(), (Object)phaseListener);
                }
            }
            return phaseListener;
        }

        public void afterPhase(PhaseEvent phaseEvent) {
            PhaseListener phaseListener = this.getInstance();
            if (phaseListener != null) {
                phaseListener.afterPhase(phaseEvent);
            }
        }

        public void beforePhase(PhaseEvent phaseEvent) {
            PhaseListener phaseListener = this.getInstance();
            if (phaseListener != null) {
                phaseListener.beforePhase(phaseEvent);
            }
        }

        public PhaseId getPhaseId() {
            PhaseListener phaseListener = this.getInstance();
            return phaseListener != null ? phaseListener.getPhaseId() : PhaseId.ANY_PHASE;
        }

        public boolean equals(Object object) {
            if (this == object) {
                return true;
            }
            if (object == null || this.getClass() != object.getClass()) {
                return false;
            }
            LazyPhaseListener lazyPhaseListener = (LazyPhaseListener)object;
            if (this.binding != null ? !this.binding.equals((Object)lazyPhaseListener.binding) : lazyPhaseListener.binding != null) {
                return false;
            }
            return !(this.type != null ? !this.type.equals(lazyPhaseListener.type) : lazyPhaseListener.type != null);
        }

        public int hashCode() {
            int n = this.type != null ? this.type.hashCode() : 0;
            n = 31 * n + (this.binding != null ? this.binding.hashCode() : 0);
            return n;
        }
    }
}

