/*
 * Decompiled with CFR 0.152.
 */
package com.sun.faces.lifecycle;

import com.sun.faces.config.WebConfiguration;
import com.sun.faces.lifecycle.Phase;
import com.sun.faces.renderkit.RenderKitUtils;
import com.sun.faces.util.FacesLogger;
import com.sun.faces.util.MessageUtils;
import com.sun.faces.util.Util;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.EnumSet;
import java.util.ListIterator;
import java.util.Map;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.el.MethodExpression;
import javax.faces.FacesException;
import javax.faces.application.ProtectedViewException;
import javax.faces.application.ViewExpiredException;
import javax.faces.application.ViewHandler;
import javax.faces.component.UIComponent;
import javax.faces.component.UIViewRoot;
import javax.faces.component.visit.VisitCallback;
import javax.faces.component.visit.VisitContext;
import javax.faces.component.visit.VisitHint;
import javax.faces.component.visit.VisitResult;
import javax.faces.context.ExternalContext;
import javax.faces.context.FacesContext;
import javax.faces.event.AbortProcessingException;
import javax.faces.event.ComponentSystemEvent;
import javax.faces.event.ExceptionQueuedEvent;
import javax.faces.event.ExceptionQueuedEventContext;
import javax.faces.event.PhaseEvent;
import javax.faces.event.PhaseId;
import javax.faces.event.PhaseListener;
import javax.faces.event.PostRestoreStateEvent;
import javax.faces.lifecycle.Lifecycle;
import javax.faces.render.ResponseStateManager;
import javax.faces.view.ViewDeclarationLanguage;
import javax.faces.view.ViewMetadata;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class RestoreViewPhase
extends Phase {
    private static final String WEBAPP_ERROR_PAGE_MARKER = "javax.servlet.error.message";
    private static final Logger LOGGER = FacesLogger.LIFECYCLE.getLogger();
    private WebConfiguration webConfig;
    private static String SKIP_ITERATION_HINT = "javax.faces.visit.SKIP_ITERATION";

    @Override
    public PhaseId getId() {
        return PhaseId.RESTORE_VIEW;
    }

    @Override
    public void doPhase(FacesContext facesContext, Lifecycle lifecycle, ListIterator<PhaseListener> listIterator) {
        Util.getViewHandler(facesContext).initView(facesContext);
        super.doPhase(facesContext, lifecycle, listIterator);
        this.notifyAfter(facesContext, lifecycle);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void execute(FacesContext facesContext) throws FacesException {
        Map map;
        if (LOGGER.isLoggable(Level.FINE)) {
            LOGGER.fine("Entering RestoreViewPhase");
        }
        if (null == facesContext) {
            throw new FacesException(MessageUtils.getExceptionMessageString("com.sun.faces.NULL_CONTEXT_ERROR", new Object[0]));
        }
        UIViewRoot uIViewRoot = facesContext.getViewRoot();
        if (uIViewRoot != null) {
            if (LOGGER.isLoggable(Level.FINE)) {
                LOGGER.fine("Found a pre created view in FacesContext");
            }
            facesContext.getViewRoot().setLocale(facesContext.getExternalContext().getRequestLocale());
            this.deliverPostRestoreStateEvent(facesContext);
            if (!facesContext.isPostback()) {
                facesContext.renderResponse();
            }
            return;
        }
        FacesException facesException = null;
        try {
            boolean bl;
            map = facesContext.getExternalContext().getRequestMap();
            String string = (String)map.get("javax.servlet.include.path_info");
            if (string == null) {
                string = facesContext.getExternalContext().getRequestPathInfo();
            }
            if (string == null) {
                string = (String)map.get("javax.servlet.include.servlet_path");
            }
            if (string == null) {
                string = facesContext.getExternalContext().getRequestServletPath();
            }
            if (string == null) {
                throw new FacesException(MessageUtils.getExceptionMessageString("com.sun.faces.NULL_REQUEST_VIEW_ERROR", new Object[0]));
            }
            ViewHandler viewHandler = Util.getViewHandler(facesContext);
            boolean bl2 = bl = facesContext.isPostback() && !RestoreViewPhase.isErrorPage(facesContext);
            if (bl) {
                facesContext.setProcessingEvents(false);
                uIViewRoot = viewHandler.restoreView(facesContext, string);
                if (uIViewRoot == null) {
                    if (this.is11CompatEnabled(facesContext)) {
                        if (LOGGER.isLoggable(Level.FINE)) {
                            LOGGER.fine("Postback: recreating a view for " + string);
                        }
                        uIViewRoot = viewHandler.createView(facesContext, string);
                        facesContext.renderResponse();
                    } else {
                        Object[] objectArray = new Object[]{string};
                        throw new ViewExpiredException(MessageUtils.getExceptionMessageString("com.sun.faces.RESTORE_VIEW_ERROR", objectArray), string);
                    }
                }
                facesContext.setViewRoot(uIViewRoot);
                facesContext.setProcessingEvents(true);
                if (LOGGER.isLoggable(Level.FINE)) {
                    LOGGER.fine("Postback: restored view for " + string);
                }
            } else {
                if (LOGGER.isLoggable(Level.FINE)) {
                    LOGGER.fine("New request: creating a view for " + string);
                }
                String string2 = viewHandler.deriveLogicalViewId(facesContext, string);
                ViewDeclarationLanguage viewDeclarationLanguage = viewHandler.getViewDeclarationLanguage(facesContext, string2);
                this.maybeTakeProtectedViewAction(facesContext, viewHandler, viewDeclarationLanguage, string);
                ViewMetadata viewMetadata = null;
                if (viewDeclarationLanguage != null && (viewMetadata = viewDeclarationLanguage.getViewMetadata(facesContext, string)) != null && !ViewMetadata.hasMetadata((UIViewRoot)(uIViewRoot = viewMetadata.createMetadataView(facesContext)))) {
                    facesContext.renderResponse();
                }
                if (null == viewDeclarationLanguage || null == viewMetadata) {
                    facesContext.renderResponse();
                }
                if (null == uIViewRoot) {
                    uIViewRoot = Util.getViewHandler(facesContext).createView(facesContext, string);
                }
                facesContext.setViewRoot(uIViewRoot);
                assert (null != uIViewRoot);
            }
        }
        catch (Throwable throwable) {
            facesException = throwable instanceof FacesException ? (FacesException)throwable : new FacesException(throwable);
        }
        finally {
            if (null == facesException) {
                map = facesContext.getApplication().getFlowHandler();
                if (null != map) {
                    map.clientWindowTransition(facesContext);
                }
            } else {
                throw facesException;
            }
            this.deliverPostRestoreStateEvent(facesContext);
        }
        if (LOGGER.isLoggable(Level.FINE)) {
            LOGGER.fine("Exiting RestoreViewPhase");
        }
    }

    private void maybeTakeProtectedViewAction(FacesContext facesContext, ViewHandler viewHandler, ViewDeclarationLanguage viewDeclarationLanguage, String string) {
        Set set = viewHandler.getProtectedViewsUnmodifiable();
        boolean bl = this.isProtectedView(string, set);
        if (bl) {
            boolean bl2;
            String string2;
            boolean bl3;
            ExternalContext externalContext = facesContext.getExternalContext();
            Map map = externalContext.getRequestHeaderMap();
            String string3 = viewHandler.calculateRenderKitId(facesContext);
            ResponseStateManager responseStateManager = RenderKitUtils.getResponseStateManager(facesContext, string3);
            String string4 = (String)externalContext.getRequestParameterMap().get("javax.faces.Token");
            String string5 = responseStateManager.getCryptographicallyStrongTokenFromSession(facesContext);
            if (null == string4 || !string5.equals(string4)) {
                throw new ProtectedViewException();
            }
            String string6 = "/";
            if (map.containsKey("Referer") && !(bl3 = this.isProtectedView(string2 = (String)map.get("Referer"), set))) {
                bl2 = false;
                try {
                    bl2 = this.originatesInWebapp(facesContext, string2, viewDeclarationLanguage);
                }
                catch (URISyntaxException uRISyntaxException) {
                    throw new ProtectedViewException((Throwable)uRISyntaxException);
                }
                if (!bl2) {
                    String string7 = FacesLogger.LIFECYCLE.interpolateMessage(facesContext, "jsf.lifecycle.invalid.referer", new String[]{string2, string});
                    if (LOGGER.isLoggable(Level.SEVERE)) {
                        LOGGER.log(Level.SEVERE, string7);
                    }
                    throw new ProtectedViewException(string7);
                }
            }
            if (map.containsKey("Origin") && !(bl3 = this.isProtectedView(string2 = (String)map.get("Origin"), set))) {
                bl2 = false;
                try {
                    bl2 = this.originatesInWebapp(facesContext, string2, viewDeclarationLanguage);
                }
                catch (URISyntaxException uRISyntaxException) {
                    throw new ProtectedViewException((Throwable)uRISyntaxException);
                }
                if (!bl2) {
                    String string8 = FacesLogger.LIFECYCLE.interpolateMessage(facesContext, "jsf.lifecycle.invalid.origin", new String[]{string2, string});
                    if (LOGGER.isLoggable(Level.SEVERE)) {
                        LOGGER.log(Level.SEVERE, string8);
                    }
                    throw new ProtectedViewException(string8);
                }
            }
        }
    }

    private boolean isProtectedView(String string, Set<String> set) {
        boolean bl = false;
        for (String string2 : set) {
            if (!string2.equals(string)) continue;
            bl = true;
            break;
        }
        return bl;
    }

    private boolean originatesInWebapp(FacesContext facesContext, String string, ViewDeclarationLanguage viewDeclarationLanguage) throws URISyntaxException {
        boolean bl = false;
        ExternalContext externalContext = facesContext.getExternalContext();
        String string2 = "/";
        URI uRI = null;
        String string3 = null;
        boolean bl2 = string.matches("^[a-z]+://.*");
        if (!bl2) {
            URI uRI2 = null;
            URI uRI3 = null;
            String string4 = externalContext.getRequestScheme() + ":" + string2 + string2 + externalContext.getRequestServerName() + ":" + externalContext.getRequestServerPort();
            uRI2 = new URI(string4);
            uRI3 = new URI(string);
            uRI = uRI2.resolve(uRI3);
        }
        boolean bl3 = false;
        boolean bl4 = false;
        boolean bl5 = false;
        boolean bl6 = false;
        if (null == uRI) {
            uRI = new URI(string);
        }
        bl3 = null == uRI.getHost() ? false : uRI.getHost().equals(externalContext.getRequestServerName());
        bl4 = -1 == uRI.getPort() ? false : uRI.getPort() == externalContext.getRequestServerPort();
        string3 = uRI.getPath();
        bl5 = string3.contains(externalContext.getApplicationContextPath());
        boolean bl7 = bl = bl3 && bl4 && bl5;
        if (!bl) {
            int n = string3.lastIndexOf(string2);
            if (-1 != n) {
                string3 = string3.substring(n);
            }
            bl = null != string3 && viewDeclarationLanguage.viewExists(facesContext, string3);
        }
        return bl;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void deliverPostRestoreStateEvent(FacesContext facesContext) throws FacesException {
        UIViewRoot uIViewRoot = facesContext.getViewRoot();
        final PostRestoreStateEvent postRestoreStateEvent = new PostRestoreStateEvent((UIComponent)uIViewRoot);
        try {
            facesContext.getAttributes().put(SKIP_ITERATION_HINT, true);
            facesContext.getApplication().publishEvent(facesContext, PostRestoreStateEvent.class, (Object)uIViewRoot);
            EnumSet<VisitHint> enumSet = EnumSet.of(VisitHint.SKIP_ITERATION);
            VisitContext visitContext = VisitContext.createVisitContext((FacesContext)facesContext, null, enumSet);
            uIViewRoot.visitTree(visitContext, new VisitCallback(){

                public VisitResult visit(VisitContext visitContext, UIComponent uIComponent) {
                    postRestoreStateEvent.setComponent(uIComponent);
                    uIComponent.processEvent((ComponentSystemEvent)postRestoreStateEvent);
                    return VisitResult.ACCEPT;
                }
            });
        }
        catch (AbortProcessingException abortProcessingException) {
            facesContext.getApplication().publishEvent(facesContext, ExceptionQueuedEvent.class, (Object)new ExceptionQueuedEventContext(facesContext, (Throwable)abortProcessingException, null, PhaseId.RESTORE_VIEW));
        }
        finally {
            facesContext.getAttributes().remove(SKIP_ITERATION_HINT);
        }
    }

    private void notifyAfter(FacesContext facesContext, Lifecycle lifecycle) {
        UIViewRoot uIViewRoot = facesContext.getViewRoot();
        if (null == uIViewRoot) {
            return;
        }
        MethodExpression methodExpression = uIViewRoot.getAfterPhaseListener();
        if (null != methodExpression) {
            try {
                PhaseEvent phaseEvent = new PhaseEvent(facesContext, PhaseId.RESTORE_VIEW, lifecycle);
                methodExpression.invoke(facesContext.getELContext(), new Object[]{phaseEvent});
            }
            catch (Exception exception) {
                if (LOGGER.isLoggable(Level.SEVERE)) {
                    LOGGER.log(Level.SEVERE, "severe.component.unable_to_process_expression", new Object[]{methodExpression.getExpressionString(), "afterPhase"});
                }
                return;
            }
        }
    }

    private static boolean isErrorPage(FacesContext facesContext) {
        return facesContext.getExternalContext().getRequestMap().get(WEBAPP_ERROR_PAGE_MARKER) != null;
    }

    private WebConfiguration getWebConfig(FacesContext facesContext) {
        if (this.webConfig == null) {
            this.webConfig = WebConfiguration.getInstance(facesContext.getExternalContext());
        }
        return this.webConfig;
    }

    private boolean is11CompatEnabled(FacesContext facesContext) {
        return this.getWebConfig(facesContext).isOptionEnabled(WebConfiguration.BooleanWebContextInitParameter.EnableRestoreView11Compatibility);
    }
}

