/*
 * Decompiled with CFR 0.152.
 */
package com.sun.faces.renderkit.html_basic;

import com.sun.faces.renderkit.RenderKitUtils;
import com.sun.faces.renderkit.html_basic.TextRenderer;
import java.io.IOException;
import java.util.Collection;
import java.util.Map;
import javax.faces.FacesException;
import javax.faces.application.FacesMessage;
import javax.faces.application.ProjectStage;
import javax.faces.component.UIComponent;
import javax.faces.component.UIForm;
import javax.faces.context.ExternalContext;
import javax.faces.context.FacesContext;
import javax.faces.convert.ConverterException;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.Part;

public class FileRenderer
extends TextRenderer {
    public void decode(FacesContext facesContext, UIComponent uIComponent) {
        this.rendererParamsNotNull(facesContext, uIComponent);
        if (!this.shouldDecode(uIComponent)) {
            return;
        }
        String string = this.decodeBehaviors(facesContext, uIComponent);
        if (string == null) {
            string = uIComponent.getClientId(facesContext);
        }
        assert (string != null);
        ExternalContext externalContext = facesContext.getExternalContext();
        Map map = externalContext.getRequestParameterMap();
        if (map.containsKey(string)) {
            this.setSubmittedValue(uIComponent, map.get(string));
        }
        HttpServletRequest httpServletRequest = (HttpServletRequest)externalContext.getRequest();
        try {
            Collection collection = httpServletRequest.getParts();
            for (Part part : collection) {
                if (!string.equals(part.getName())) continue;
                uIComponent.setTransient(true);
                this.setSubmittedValue(uIComponent, part);
            }
        }
        catch (IOException iOException) {
            throw new FacesException((Throwable)iOException);
        }
        catch (ServletException servletException) {
            throw new FacesException((Throwable)servletException);
        }
    }

    public void encodeBegin(FacesContext facesContext, UIComponent uIComponent) throws IOException {
        if (facesContext.isProjectStage(ProjectStage.Development)) {
            String string;
            boolean bl = false;
            UIForm uIForm = RenderKitUtils.getForm(uIComponent, facesContext);
            if (null != uIForm) {
                string = (String)uIForm.getAttributes().get("enctype");
                if (null == string || !string.equals("multipart/form-data")) {
                    bl = true;
                }
            } else {
                bl = true;
            }
            if (bl) {
                string = new FacesMessage(FacesMessage.SEVERITY_WARN, "File upload component requires a form with an enctype of multipart/form-data", "File upload component requires a form with an enctype of multipart/form-data");
                facesContext.addMessage(uIComponent.getClientId(facesContext), (FacesMessage)string);
            }
        }
        super.encodeBegin(facesContext, uIComponent);
    }

    public Object getConvertedValue(FacesContext facesContext, UIComponent uIComponent, Object object) throws ConverterException {
        Part part;
        if (object instanceof Part && ((part = (Part)object).getHeader("content-disposition") == null || part.getHeader("content-disposition").endsWith("filename=\"\"")) && part.getSize() <= 0L) {
            return null;
        }
        return object;
    }
}

