/*
 * Decompiled with CFR 0.152.
 */
package com.sun.faces.renderkit.html_basic;

import com.sun.faces.config.WebConfiguration;
import com.sun.faces.renderkit.Attribute;
import com.sun.faces.renderkit.AttributeManager;
import com.sun.faces.renderkit.RenderKitUtils;
import com.sun.faces.renderkit.html_basic.HtmlBasicRenderer;
import com.sun.faces.renderkit.html_basic.LinkRenderer;
import com.sun.faces.util.Util;
import java.io.IOException;
import java.net.URLEncoder;
import java.util.logging.Level;
import javax.faces.component.UIComponent;
import javax.faces.component.UIOutput;
import javax.faces.component.UIViewRoot;
import javax.faces.context.FacesContext;
import javax.faces.context.ResponseWriter;

public class OutputLinkRenderer
extends LinkRenderer {
    private static final Attribute[] ATTRIBUTES = AttributeManager.getAttributes(AttributeManager.Key.OUTPUTLINK);
    protected boolean namespaceParameters;

    public OutputLinkRenderer() {
        WebConfiguration webConfiguration = WebConfiguration.getInstance();
        this.namespaceParameters = webConfiguration.isOptionEnabled(WebConfiguration.BooleanWebContextInitParameter.NamespaceParameters);
    }

    public void decode(FacesContext facesContext, UIComponent uIComponent) {
        this.rendererParamsNotNull(facesContext, uIComponent);
        if (this.shouldDecode(uIComponent)) {
            this.decodeBehaviors(facesContext, uIComponent);
        }
    }

    public void encodeBegin(FacesContext facesContext, UIComponent uIComponent) throws IOException {
        this.rendererParamsNotNull(facesContext, uIComponent);
        UIOutput uIOutput = (UIOutput)uIComponent;
        boolean bl = false;
        if (uIOutput.getAttributes().get("disabled") != null && uIOutput.getAttributes().get("disabled").equals(Boolean.TRUE)) {
            bl = true;
        }
        if (bl) {
            this.renderAsDisabled(facesContext, (UIComponent)uIOutput);
        } else {
            this.renderAsActive(facesContext, (UIComponent)uIOutput);
        }
    }

    public void encodeChildren(FacesContext facesContext, UIComponent uIComponent) throws IOException {
        this.rendererParamsNotNull(facesContext, uIComponent);
        if (!this.shouldEncodeChildren(uIComponent)) {
            return;
        }
        if (uIComponent.getChildCount() > 0) {
            for (UIComponent uIComponent2 : uIComponent.getChildren()) {
                this.encodeRecursive(facesContext, uIComponent2);
            }
        }
    }

    public void encodeEnd(FacesContext facesContext, UIComponent uIComponent) throws IOException {
        this.rendererParamsNotNull(facesContext, uIComponent);
        if (!this.shouldEncode(uIComponent)) {
            return;
        }
        ResponseWriter responseWriter = facesContext.getResponseWriter();
        assert (responseWriter != null);
        if (Boolean.TRUE.equals(uIComponent.getAttributes().get("disabled"))) {
            responseWriter.endElement("span");
        } else {
            responseWriter.endElement("a");
        }
    }

    public boolean getRendersChildren() {
        return true;
    }

    protected String getFragment(UIComponent uIComponent) {
        String string = (String)uIComponent.getAttributes().get("fragment");
        String string2 = string = string != null ? string.trim() : "";
        if (string.length() > 0) {
            string = "#" + string;
        }
        return string;
    }

    protected Object getValue(UIComponent uIComponent) {
        if (Util.componentIsDisabled(uIComponent)) {
            return null;
        }
        return ((UIOutput)uIComponent).getValue();
    }

    protected void renderAsActive(FacesContext facesContext, UIComponent uIComponent) throws IOException {
        String string = this.getCurrentValue(facesContext, uIComponent);
        if (logger.isLoggable(Level.FINE)) {
            logger.fine("Value to be rendered " + string);
        }
        if (!uIComponent.isRendered()) {
            if (logger.isLoggable(Level.FINE)) {
                logger.fine("End encoding component " + uIComponent.getId() + " since " + "rendered attribute is set to false ");
            }
            return;
        }
        ResponseWriter responseWriter = facesContext.getResponseWriter();
        assert (responseWriter != null);
        responseWriter.startElement("a", uIComponent);
        String string2 = this.writeIdAttributeIfNecessary(facesContext, responseWriter, uIComponent);
        if (null != string2) {
            responseWriter.writeAttribute("name", (Object)string2, "name");
        }
        if (null == string || 0 == string.length()) {
            string = "";
        }
        HtmlBasicRenderer.Param[] paramArray = this.getParamList(uIComponent);
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append(string);
        boolean bl = string.indexOf(63) > 0;
        String string3 = null;
        if (this.namespaceParameters) {
            UIViewRoot uIViewRoot = facesContext.getViewRoot();
            string3 = uIViewRoot.getContainerClientId(facesContext);
        }
        int n = paramArray.length;
        for (int i = 0; i < n; ++i) {
            String string4 = paramArray[i].name;
            if (string4 == null || string4.length() == 0) continue;
            if (string3 != null) {
                string4 = string3 + string4;
            }
            String string5 = paramArray[i].value;
            stringBuffer.append(bl ? (char)'&' : '?');
            stringBuffer.append(URLEncoder.encode(string4, "UTF-8"));
            stringBuffer.append('=');
            if (string5 != null && string5.length() != 0) {
                stringBuffer.append(URLEncoder.encode(string5, "UTF-8"));
            }
            bl = true;
        }
        stringBuffer.append(this.getFragment(uIComponent));
        responseWriter.writeURIAttribute("href", (Object)facesContext.getExternalContext().encodeResourceURL(stringBuffer.toString()), "href");
        RenderKitUtils.renderPassThruAttributes(facesContext, responseWriter, uIComponent, ATTRIBUTES);
        RenderKitUtils.renderXHTMLStyleBooleanAttributes(responseWriter, uIComponent);
        String string6 = (String)uIComponent.getAttributes().get("target");
        if (string6 != null && string6.trim().length() != 0) {
            responseWriter.writeAttribute("target", (Object)string6, "target");
        }
        this.writeCommonLinkAttributes(responseWriter, uIComponent);
        responseWriter.flush();
    }
}

