/*
 * Decompiled with CFR 0.152.
 */
package com.sun.faces.util;

import com.sun.faces.util.FacesLogger;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.logging.Logger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Cache<K, V> {
    private static final Logger LOGGER = FacesLogger.UTIL.getLogger();
    private final ConcurrentMap<K, V> cache = new ConcurrentHashMap();
    private final Factory<K, V> factory;

    public Cache(Factory<K, V> factory) {
        this.factory = factory;
    }

    public V get(K k) {
        Object v = this.cache.get(k);
        if (v == null) {
            try {
                v = this.factory.newInstance(k);
            }
            catch (InterruptedException interruptedException) {
                throw new RuntimeException(interruptedException);
            }
            V v2 = this.cache.putIfAbsent(k, v);
            if (v2 != null) {
                v = v2;
            }
        }
        return v;
    }

    public V remove(K k) {
        return this.cache.remove(k);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static interface Factory<K, V> {
        public V newInstance(K var1) throws InterruptedException;
    }
}

