/*
 * Decompiled with CFR 0.152.
 */
package com.sun.faces.util;

import com.sun.faces.util.FacesLogger;
import com.sun.faces.util.Util;
import java.beans.BeanInfo;
import java.beans.IntrospectionException;
import java.beans.Introspector;
import java.beans.PropertyDescriptor;
import java.lang.reflect.Constructor;
import java.lang.reflect.Method;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import java.util.WeakHashMap;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.logging.Level;
import java.util.logging.Logger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class ReflectionUtils {
    private static final Logger LOGGER = FacesLogger.APPLICATION.getLogger();
    private static final Map<ClassLoader, ConcurrentMap<String, MetaData>> REFLECTION_CACHE = new WeakHashMap<ClassLoader, ConcurrentMap<String, MetaData>>();

    private ReflectionUtils() {
    }

    public static synchronized void clearCache(ClassLoader classLoader) {
        REFLECTION_CACHE.remove(classLoader);
    }

    public static synchronized void initCache(ClassLoader classLoader) {
        if (REFLECTION_CACHE.get(classLoader) == null) {
            REFLECTION_CACHE.put(classLoader, new ConcurrentHashMap());
        }
    }

    public static Constructor lookupConstructor(Class<?> clazz, Class<?> ... classArray) {
        ClassLoader classLoader = Util.getCurrentLoader(clazz);
        if (classLoader == null) {
            return null;
        }
        return ReflectionUtils.getMetaData(classLoader, clazz).lookupConstructor(classArray);
    }

    public static Method lookupMethod(Class<?> clazz, String string, Class<?> ... classArray) {
        ClassLoader classLoader = Util.getCurrentLoader(clazz);
        if (classLoader == null) {
            return null;
        }
        return ReflectionUtils.getMetaData(classLoader, clazz).lookupMethod(string, classArray);
    }

    public static Object newInstance(String string) throws InstantiationException, IllegalAccessException {
        ClassLoader classLoader = Util.getCurrentLoader(null);
        if (classLoader == null) {
            return null;
        }
        return ReflectionUtils.getMetaData(classLoader, string).lookupClass().newInstance();
    }

    public static Class<?> lookupClass(String string) {
        ClassLoader classLoader = Util.getCurrentLoader(null);
        if (classLoader == null) {
            return null;
        }
        return ReflectionUtils.getMetaData(classLoader, string).lookupClass();
    }

    public static Method lookupWriteMethod(String string, String string2) {
        ClassLoader classLoader = Util.getCurrentLoader(null);
        if (classLoader == null) {
            return null;
        }
        return ReflectionUtils.getMetaData(classLoader, string).lookupWriteMethod(string2);
    }

    public static Method lookupReadMethod(String string, String string2) {
        ClassLoader classLoader = Util.getCurrentLoader(null);
        if (classLoader == null) {
            return null;
        }
        return ReflectionUtils.getMetaData(classLoader, string).lookupReadMethod(string2);
    }

    private static MetaData getMetaData(ClassLoader classLoader, Class<?> clazz) {
        MetaData metaData;
        ConcurrentMap<String, MetaData> concurrentMap = REFLECTION_CACHE.get(classLoader);
        if (concurrentMap == null) {
            ReflectionUtils.initCache(classLoader);
            concurrentMap = REFLECTION_CACHE.get(classLoader);
        }
        if ((metaData = (MetaData)concurrentMap.get(clazz.getName())) == null) {
            metaData = new MetaData(clazz);
            concurrentMap.put(clazz.getName(), metaData);
        }
        return metaData;
    }

    private static MetaData getMetaData(ClassLoader classLoader, String string) {
        MetaData metaData;
        ConcurrentMap<String, MetaData> concurrentMap = REFLECTION_CACHE.get(classLoader);
        if (concurrentMap == null) {
            ReflectionUtils.initCache(classLoader);
            concurrentMap = REFLECTION_CACHE.get(classLoader);
        }
        if ((metaData = (MetaData)concurrentMap.get(string)) == null) {
            try {
                Class clazz = Util.loadClass(string, concurrentMap);
                metaData = new MetaData(clazz);
                concurrentMap.put(string, metaData);
            }
            catch (ClassNotFoundException classNotFoundException) {
                return null;
            }
        }
        return metaData;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static final class MetaData {
        Map<Integer, Constructor> constructors;
        Map<String, HashMap<Integer, Method>> methods;
        Map<String, HashMap<Integer, Method>> declaredMethods;
        Map<String, PropertyDescriptor> propertyDescriptors;
        Class<?> clazz;

        /*
         * WARNING - void declaration
         */
        public MetaData(Class<?> clazz) {
            block10: {
                String string;
                this.clazz = clazz;
                Constructor<?>[] constructorArray = clazz.getConstructors();
                this.constructors = new HashMap<Integer, Constructor>(constructorArray.length, 1.0f);
                int n = constructorArray.length;
                for (int i = 0; i < n; ++i) {
                    this.constructors.put(MetaData.getKey(constructorArray[i].getParameterTypes()), constructorArray[i]);
                }
                Method[] methodArray = clazz.getMethods();
                this.methods = new HashMap<String, HashMap<Integer, Method>>(methodArray.length, 1.0f);
                int n2 = methodArray.length;
                for (n = 0; n < n2; ++n) {
                    void object;
                    string = methodArray[n].getName();
                    HashMap<Integer, Method> hashMap = this.methods.get(string);
                    if (hashMap == null) {
                        HashMap hashMap2 = new HashMap(4, 1.0f);
                        this.methods.put(string, hashMap2);
                    }
                    object.put(MetaData.getKey(methodArray[n].getParameterTypes()), methodArray[n]);
                }
                methodArray = clazz.getDeclaredMethods();
                this.declaredMethods = new HashMap<String, HashMap<Integer, Method>>(methodArray.length, 1.0f);
                n2 = methodArray.length;
                for (n = 0; n < n2; ++n) {
                    void var7_17;
                    string = methodArray[n].getName();
                    HashMap<Integer, Method> hashMap = this.declaredMethods.get(string);
                    if (hashMap == null) {
                        HashMap hashMap3 = new HashMap(4, 1.0f);
                        this.declaredMethods.put(string, hashMap3);
                    }
                    var7_17.put(MetaData.getKey(methodArray[n].getParameterTypes()), methodArray[n]);
                }
                try {
                    BeanInfo beanInfo = Introspector.getBeanInfo(clazz);
                    PropertyDescriptor[] propertyDescriptorArray = beanInfo.getPropertyDescriptors();
                    if (propertyDescriptorArray != null) {
                        if (this.propertyDescriptors == null) {
                            this.propertyDescriptors = new HashMap<String, PropertyDescriptor>(propertyDescriptorArray.length, 1.0f);
                        }
                        for (PropertyDescriptor propertyDescriptor : propertyDescriptorArray) {
                            this.propertyDescriptors.put(propertyDescriptor.getName(), propertyDescriptor);
                        }
                    }
                }
                catch (IntrospectionException introspectionException) {
                    if (!LOGGER.isLoggable(Level.SEVERE)) break block10;
                    LOGGER.log(Level.SEVERE, introspectionException.toString(), introspectionException);
                }
            }
        }

        public Constructor lookupConstructor(Class<?> ... classArray) {
            return this.constructors.get(MetaData.getKey(classArray));
        }

        public Method lookupMethod(String string, Class<?> ... classArray) {
            Map map = this.methods.get(string);
            Integer n = MetaData.getKey(classArray);
            Method method = null;
            if ((null == map || null == (method = (Method)map.get(n))) && null != (map = (Map)this.declaredMethods.get(string))) {
                method = (Method)map.get(n);
            }
            return method;
        }

        public Class<?> lookupClass() {
            return this.clazz;
        }

        public Method lookupWriteMethod(String string) {
            if (this.propertyDescriptors == null) {
                return null;
            }
            PropertyDescriptor propertyDescriptor = this.propertyDescriptors.get(string);
            if (propertyDescriptor != null) {
                return propertyDescriptor.getWriteMethod();
            }
            return null;
        }

        public Method lookupReadMethod(String string) {
            if (this.propertyDescriptors == null) {
                return null;
            }
            PropertyDescriptor propertyDescriptor = this.propertyDescriptors.get(string);
            if (propertyDescriptor != null) {
                return propertyDescriptor.getReadMethod();
            }
            return null;
        }

        private static Integer getKey(Class<?> ... classArray) {
            return Arrays.deepHashCode(classArray);
        }
    }
}

