/*
 * Decompiled with CFR 0.152.
 */
package com.sun.faces.facelets.el;

import java.io.Externalizable;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import javax.el.ELContext;
import javax.el.ELException;
import javax.el.PropertyNotFoundException;
import javax.el.PropertyNotWritableException;
import javax.el.ValueExpression;
import javax.el.ValueReference;
import javax.faces.view.facelets.TagAttribute;

public final class TagValueExpression
extends ValueExpression
implements Externalizable {
    private static final long serialVersionUID = 1L;
    private ValueExpression wrapped;
    private String tagAttribute;

    public TagValueExpression() {
    }

    public TagValueExpression(TagAttribute tagAttribute, ValueExpression wrapped) {
        this.tagAttribute = tagAttribute.toString();
        this.wrapped = wrapped;
    }

    public Class<?> getExpectedType() {
        return this.wrapped.getExpectedType();
    }

    public Class<?> getType(ELContext context) {
        try {
            return this.wrapped.getType(context);
        }
        catch (PropertyNotFoundException pnfe) {
            throw new PropertyNotFoundException(this.tagAttribute + ": " + pnfe.getMessage(), (Throwable)pnfe);
        }
        catch (ELException e) {
            throw new ELException(this.tagAttribute + ": " + e.getMessage(), (Throwable)e);
        }
    }

    public Object getValue(ELContext context) {
        try {
            return this.wrapped.getValue(context);
        }
        catch (PropertyNotFoundException pnfe) {
            throw new PropertyNotFoundException(this.tagAttribute + ": " + pnfe.getMessage(), (Throwable)pnfe);
        }
        catch (ELException e) {
            throw new ELException(this.tagAttribute + ": " + e.getMessage(), (Throwable)e);
        }
    }

    public boolean isReadOnly(ELContext context) {
        try {
            return this.wrapped.isReadOnly(context);
        }
        catch (PropertyNotFoundException pnfe) {
            throw new PropertyNotFoundException(this.tagAttribute + ": " + pnfe.getMessage(), (Throwable)pnfe);
        }
        catch (ELException e) {
            throw new ELException(this.tagAttribute + ": " + e.getMessage(), (Throwable)e);
        }
    }

    public void setValue(ELContext context, Object value) {
        try {
            this.wrapped.setValue(context, value);
        }
        catch (PropertyNotFoundException pnfe) {
            throw new PropertyNotFoundException(this.tagAttribute + ": " + pnfe.getMessage(), (Throwable)pnfe);
        }
        catch (PropertyNotWritableException pnwe) {
            throw new PropertyNotWritableException(this.tagAttribute + ": " + pnwe.getMessage(), (Throwable)pnwe);
        }
        catch (ELException e) {
            throw new ELException(this.tagAttribute + ": " + e.getMessage(), (Throwable)e);
        }
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        TagValueExpression that = (TagValueExpression)o;
        if (this.tagAttribute != null ? !this.tagAttribute.equals(that.tagAttribute) : that.tagAttribute != null) {
            return false;
        }
        return !(this.wrapped != null ? !this.wrapped.equals((Object)that.wrapped) : that.wrapped != null);
    }

    public int hashCode() {
        int result = this.wrapped != null ? this.wrapped.hashCode() : 0;
        result = 31 * result + (this.tagAttribute != null ? this.tagAttribute.hashCode() : 0);
        return result;
    }

    public String getExpressionString() {
        return this.wrapped.getExpressionString();
    }

    public boolean isLiteralText() {
        return this.wrapped.isLiteralText();
    }

    public ValueReference getValueReference(ELContext context) {
        return this.wrapped.getValueReference(context);
    }

    @Override
    public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
        this.wrapped = (ValueExpression)in.readObject();
        this.tagAttribute = in.readUTF();
    }

    @Override
    public void writeExternal(ObjectOutput out) throws IOException {
        out.writeObject(this.wrapped);
        out.writeUTF(this.tagAttribute);
    }

    public ValueExpression getWrapped() {
        return this.wrapped;
    }

    public String toString() {
        return this.tagAttribute;
    }
}

