/*
 * Decompiled with CFR 0.152.
 */
package com.sun.grizzly.websockets;

import com.sun.grizzly.util.LogMessages;
import com.sun.grizzly.util.net.URL;
import com.sun.grizzly.websockets.BaseWebSocket;
import com.sun.grizzly.websockets.NioClientNetworkHandler;
import com.sun.grizzly.websockets.WebSocketConnectTask;
import com.sun.grizzly.websockets.WebSocketEngine;
import com.sun.grizzly.websockets.WebSocketListener;
import java.io.IOException;
import java.nio.channels.SelectionKey;
import java.nio.channels.Selector;
import java.nio.channels.SocketChannel;
import java.nio.channels.spi.SelectorProvider;
import java.util.Iterator;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.logging.Level;
import java.util.logging.Logger;

public class NioClientWebSocket
extends BaseWebSocket {
    private static final Logger logger = Logger.getLogger("websocket");
    private final Selector selector;
    private final AtomicBoolean connecting = new AtomicBoolean(true);
    private final AtomicBoolean running = new AtomicBoolean(true);
    protected volatile long selectTimeout = 1000L;
    private final URL address;
    private final ExecutorService executorService = Executors.newFixedThreadPool(2);

    public NioClientWebSocket(String url, WebSocketListener ... listeners) throws IOException {
        this(url, WebSocketEngine.DEFAULT_TIMEOUT, listeners);
    }

    public NioClientWebSocket(String url, long timeout, WebSocketListener ... listeners) throws IOException {
        super(listeners);
        this.address = new URL(url);
        this.selector = SelectorProvider.provider().openSelector();
        Thread selectorThread = new Thread(new Runnable(){

            public void run() {
                NioClientWebSocket.this.select();
            }
        });
        selectorThread.setDaemon(true);
        selectorThread.start();
        WebSocketConnectTask connectTask = new WebSocketConnectTask(this);
        this.executorService.execute(connectTask);
        try {
            connectTask.get(timeout, TimeUnit.SECONDS);
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new IOException(e.getMessage());
        }
    }

    public URL getAddress() {
        return this.address;
    }

    private void select() {
        while (this.running.get()) {
            try {
                int count;
                if (this.connecting.compareAndSet(true, false)) {
                    NioClientNetworkHandler handler = this.createNetworkHandler(this.selector);
                    this.setNetworkHandler(handler);
                    SocketChannel socketChannel = handler.getChannel();
                    if (socketChannel.isConnected()) {
                        socketChannel.register(this.selector, 1, handler);
                        handler.doConnect(false);
                    } else {
                        socketChannel.register(this.selector, 8, handler);
                    }
                }
                if ((count = this.selector.select(this.selectTimeout)) == 0) continue;
                Iterator<SelectionKey> selectedKeys = this.selector.selectedKeys().iterator();
                while (selectedKeys.hasNext()) {
                    SelectionKey key = selectedKeys.next();
                    selectedKeys.remove();
                    NioClientNetworkHandler handler = (NioClientNetworkHandler)key.attachment();
                    try {
                        handler.process(key);
                    }
                    catch (IOException e) {
                        e.printStackTrace();
                        handler.shutdown();
                    }
                }
            }
            catch (IOException e) {
                if (!logger.isLoggable(Level.WARNING)) continue;
                logger.log(Level.WARNING, LogMessages.WARNING_GRIZZLY_WS_SELECT_ERROR((Object)e.getMessage()), e);
            }
        }
    }

    public void execute(Runnable runnable) {
        this.executorService.submit(runnable);
    }

    protected NioClientNetworkHandler createNetworkHandler(Selector selector) throws IOException {
        return new NioClientNetworkHandler(selector, this);
    }
}

