/*
 * Decompiled with CFR 0.152.
 */
package com.sun.xml.ws.assembler;

import com.sun.xml.ws.api.message.Packet;
import com.sun.xml.ws.api.pipe.NextAction;
import com.sun.xml.ws.api.pipe.Tube;
import com.sun.xml.ws.api.pipe.TubeCloner;
import com.sun.xml.ws.api.pipe.helper.AbstractFilterTubeImpl;
import com.sun.xml.ws.api.pipe.helper.AbstractTubeImpl;
import com.sun.xml.ws.policy.privateutil.PolicyLogger;
import java.io.StringWriter;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.util.Queue;
import javax.xml.stream.XMLOutputFactory;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamWriter;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class MessageDumpingTube
extends AbstractFilterTubeImpl {
    private static final PolicyLogger LOGGER = PolicyLogger.getLogger(MessageDumpingTube.class);
    private static boolean warnStaxUtils;
    private final Queue<String> messageQueue;
    private final XMLOutputFactory staxOut;

    public MessageDumpingTube(Queue<String> messageQueue, Tube next) {
        super(next);
        this.messageQueue = messageQueue;
        this.staxOut = XMLOutputFactory.newInstance();
    }

    protected MessageDumpingTube(MessageDumpingTube that, TubeCloner cloner) {
        super((AbstractFilterTubeImpl)that, cloner);
        this.messageQueue = that.messageQueue;
        this.staxOut = that.staxOut;
    }

    public AbstractTubeImpl copy(TubeCloner cloner) {
        return new MessageDumpingTube(this, cloner);
    }

    public NextAction processRequest(Packet request) {
        this.dump(request);
        return super.processRequest(request);
    }

    public NextAction processResponse(Packet response) {
        this.dump(response);
        return super.processResponse(response);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void dump(Packet packet) {
        StringWriter stringOut = new StringWriter();
        if (packet.getMessage() == null) {
            stringOut.write("[null]");
        } else {
            XMLStreamWriter writer = null;
            try {
                writer = this.staxOut.createXMLStreamWriter(stringOut);
                writer = this.createIndenter(writer);
                packet.getMessage().copy().writeTo(writer);
            }
            catch (XMLStreamException e) {
                LOGGER.warning("Unexpected exception occured while dumping message", e);
            }
            finally {
                if (writer != null) {
                    try {
                        writer.close();
                    }
                    catch (XMLStreamException ignored) {}
                }
            }
        }
        this.messageQueue.offer(stringOut.toString());
    }

    private XMLStreamWriter createIndenter(XMLStreamWriter writer) {
        block14: {
            try {
                Class<?> clazz = ((Object)((Object)this)).getClass().getClassLoader().loadClass("javanet.staxutils.IndentingXMLStreamWriter");
                Constructor<?> c = clazz.getConstructor(XMLStreamWriter.class);
                writer = (XMLStreamWriter)c.newInstance(writer);
            }
            catch (InstantiationException ex) {
                if (!warnStaxUtils) {
                    warnStaxUtils = true;
                    LOGGER.warning("Put stax-utils.jar to the classpath to indent the dump output", ex);
                }
            }
            catch (IllegalAccessException ex) {
                if (!warnStaxUtils) {
                    warnStaxUtils = true;
                    LOGGER.warning("Put stax-utils.jar to the classpath to indent the dump output", ex);
                }
            }
            catch (IllegalArgumentException ex) {
                if (!warnStaxUtils) {
                    warnStaxUtils = true;
                    LOGGER.warning("Put stax-utils.jar to the classpath to indent the dump output", ex);
                }
            }
            catch (InvocationTargetException ex) {
                if (!warnStaxUtils) {
                    warnStaxUtils = true;
                    LOGGER.warning("Put stax-utils.jar to the classpath to indent the dump output", ex);
                }
            }
            catch (NoSuchMethodException ex) {
                if (!warnStaxUtils) {
                    warnStaxUtils = true;
                    LOGGER.warning("Put stax-utils.jar to the classpath to indent the dump output", ex);
                }
            }
            catch (SecurityException ex) {
                if (!warnStaxUtils) {
                    warnStaxUtils = true;
                    LOGGER.warning("Put stax-utils.jar to the classpath to indent the dump output", ex);
                }
            }
            catch (ClassNotFoundException ex) {
                if (warnStaxUtils) break block14;
                warnStaxUtils = true;
                LOGGER.warning("Put stax-utils.jar to the classpath to indent the dump output", ex);
            }
        }
        return writer;
    }
}

