/*
 * Decompiled with CFR 0.152.
 */
package com.sun.xml.ws.rm.jaxws.runtime.client;

import com.sun.xml.bind.api.JAXBRIContext;
import com.sun.xml.ws.api.SOAPVersion;
import com.sun.xml.ws.api.message.HeaderList;
import com.sun.xml.ws.api.message.Headers;
import com.sun.xml.ws.api.message.Message;
import com.sun.xml.ws.api.message.Messages;
import com.sun.xml.ws.api.message.Packet;
import com.sun.xml.ws.api.pipe.Engine;
import com.sun.xml.ws.api.pipe.Fiber;
import com.sun.xml.ws.api.pipe.Tube;
import com.sun.xml.ws.api.pipe.TubeCloner;
import com.sun.xml.ws.client.ContentNegotiation;
import com.sun.xml.ws.rm.CloseSequenceException;
import com.sun.xml.ws.rm.CreateSequenceException;
import com.sun.xml.ws.rm.RmException;
import com.sun.xml.ws.rm.RmVersion;
import com.sun.xml.ws.rm.TerminateSequenceException;
import com.sun.xml.ws.rm.jaxws.runtime.InboundMessageProcessor;
import com.sun.xml.ws.rm.jaxws.runtime.OutboundSequence;
import com.sun.xml.ws.rm.jaxws.runtime.RMMessage;
import com.sun.xml.ws.rm.jaxws.runtime.SequenceConfig;
import com.sun.xml.ws.rm.jaxws.runtime.client.ClientOutboundSequence;
import com.sun.xml.ws.rm.jaxws.runtime.client.RMSource;
import com.sun.xml.ws.rm.localization.RmLogger;
import com.sun.xml.ws.rm.protocol.AbstractAckRequested;
import com.sun.xml.ws.rm.protocol.AbstractCreateSequence;
import com.sun.xml.ws.rm.protocol.AbstractCreateSequenceResponse;
import com.sun.xml.ws.rm.protocol.AbstractTerminateSequence;
import com.sun.xml.ws.rm.v200502.SequenceElement;
import com.sun.xml.ws.rm.v200702.AckRequestedElement;
import com.sun.xml.ws.rm.v200702.CloseSequenceElement;
import com.sun.xml.ws.rm.v200702.CloseSequenceResponseElement;
import com.sun.xml.ws.rm.v200702.Identifier;
import com.sun.xml.ws.rm.v200702.UsesSequenceSTR;
import java.util.logging.Level;
import javax.xml.bind.JAXBException;
import javax.xml.bind.Unmarshaller;
import javax.xml.namespace.QName;
import javax.xml.ws.BindingProvider;

public class ProtocolMessageSender {
    private static final RmLogger LOGGER = RmLogger.getLogger(ProtocolMessageSender.class);
    private SequenceConfig config;
    private final Engine engine;
    private final Tube nextTube;
    private BindingProvider proxy;
    private ContentNegotiation contentNegotiation;
    private Unmarshaller unmarshaller;

    public ProtocolMessageSender(SequenceConfig config, Unmarshaller unmarshaller, Tube nextTube, BindingProvider proxy, ContentNegotiation contentNegotiation) {
        this.unmarshaller = unmarshaller;
        this.config = config;
        this.proxy = proxy;
        this.contentNegotiation = contentNegotiation;
        this.nextTube = nextTube;
        Fiber currentFiber = Fiber.current();
        if (currentFiber == null) {
            throw LOGGER.logSevereException(new IllegalStateException("No current fiber found"));
        }
        this.engine = currentFiber.owner;
    }

    public AbstractCreateSequenceResponse sendCreateSequence(AbstractCreateSequence cs, String destinationUri, String acksToUri, boolean secureReliableMessaging) throws RmException {
        AbstractCreateSequenceResponse csrElem = null;
        if (cs != null) {
            Message request = Messages.create((JAXBRIContext)this.config.getRMVersion().jaxbContext, (Object)cs, (SOAPVersion)this.config.getSoapVersion());
            Packet requestPacket = new Packet(request);
            requestPacket.proxy = this.proxy;
            requestPacket.contentNegotiation = this.contentNegotiation;
            this.addAddressingHeaders(requestPacket, this.config.getRMVersion().createSequenceAction, destinationUri, false);
            if (secureReliableMessaging) {
                this.addSecurityHeaders(requestPacket);
            }
            Packet responsePacket = this.process(requestPacket);
            if (this.config.getAnonymousAddressingUri().equals(acksToUri)) {
                Message response = responsePacket.getMessage();
                if (response != null) {
                    if (response.isFault()) {
                        throw LOGGER.logSevereException(new CreateSequenceException("CreateSequence was refused by the RMDestination \n ", response));
                    }
                    csrElem = this.unmarshallCreateSequenceResponse(response);
                }
            } else {
                throw LOGGER.logSevereException(new RmException("Addressable endpoints are currently not supported"));
            }
        }
        return csrElem;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void sendTerminateSequence(AbstractTerminateSequence ts, OutboundSequence seq) throws RmException {
        Message request = Messages.create((JAXBRIContext)this.config.getRMVersion().jaxbContext, (Object)ts, (SOAPVersion)this.config.getSoapVersion());
        seq.processAcknowledgement(new RMMessage(request));
        Packet requestPacket = new Packet(request);
        requestPacket.proxy = this.proxy;
        requestPacket.contentNegotiation = this.contentNegotiation;
        this.addAddressingHeaders(requestPacket, this.config.getRMVersion().terminateSequenceAction, seq.getDestination(), false);
        Message response = null;
        try {
            Packet responsePacket = this.process(requestPacket);
            response = responsePacket.getMessage();
            if (response != null && response.isFault()) {
                throw LOGGER.logException(new TerminateSequenceException("There was an error trying to terminate the sequence ", response), Level.WARNING);
            }
        }
        finally {
            if (response != null) {
                response.consume();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void sendLast(OutboundSequence seq) throws RmException {
        Message request = Messages.createEmpty((SOAPVersion)this.config.getSoapVersion());
        SequenceElement el = this.createLastHeader(seq);
        request.getHeaders().add(Headers.create((JAXBRIContext)this.config.getRMVersion().jaxbContext, (Object)el));
        seq.setLast();
        Packet requestPacket = new Packet(request);
        requestPacket.proxy = this.proxy;
        requestPacket.contentNegotiation = this.contentNegotiation;
        this.addAddressingHeaders(requestPacket, this.config.getRMVersion().lastAction, seq.getDestination(), false);
        Message response = null;
        try {
            Packet responsePacket = this.process(requestPacket);
            response = responsePacket.getMessage();
            if (response != null && response.isFault()) {
                throw LOGGER.logException(new RmException("Error sending Last message", response), Level.WARNING);
            }
            InboundMessageProcessor.processMessage(new RMMessage(response), this.unmarshaller, RMSource.getRMSource(), this.config.getRMVersion());
        }
        finally {
            if (response != null) {
                response.consume();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void sendAckRequested(OutboundSequence seq, SOAPVersion version) throws RmException {
        try {
            Message request = Messages.createEmpty((SOAPVersion)version);
            AbstractAckRequested el = this.createAckRequestedElement(seq);
            request.getHeaders().add(Headers.create((JAXBRIContext)this.config.getRMVersion().jaxbContext, (Object)el));
            Packet requestPacket = new Packet(request);
            requestPacket.proxy = this.proxy;
            requestPacket.contentNegotiation = this.contentNegotiation;
            this.addAddressingHeaders(requestPacket, this.config.getRMVersion().ackRequestedAction, seq.getDestination(), false);
            Message response = null;
            try {
                Packet responsePacket = this.process(requestPacket);
                response = responsePacket.getMessage();
                if (response != null && response.isFault()) {
                    ((ClientOutboundSequence)seq).resetLastActivityTime();
                    throw LOGGER.logException(new RmException("Error sending AckRequestedElement", response), Level.WARNING);
                }
                InboundMessageProcessor.processMessage(new RMMessage(response), this.unmarshaller, RMSource.getRMSource(), this.config.getRMVersion());
            }
            finally {
                if (response != null) {
                    response.consume();
                }
            }
        }
        finally {
            ((ClientOutboundSequence)seq).resetLastActivityTime();
        }
    }

    private Packet addAddressingHeaders(Packet requestPacket, String action, String destination, boolean oneWay) throws RmException {
        requestPacket.getMessage().assertOneWay(oneWay);
        requestPacket.setEndPointAddressString(destination);
        requestPacket.getMessage().getHeaders().fillRequestAddressingHeaders(requestPacket, this.config.getAddressingVersion(), this.config.getSoapVersion(), oneWay, action);
        return requestPacket;
    }

    private void addSecurityHeaders(Packet requestPacket) {
        if (this.config.getRMVersion() == RmVersion.WSRM11) {
            HeaderList headerList = requestPacket.getMessage().getHeaders();
            UsesSequenceSTR usesSequenceSTR = new UsesSequenceSTR();
            usesSequenceSTR.getOtherAttributes().put(new QName(this.config.getSoapVersion().nsUri, "mustUnderstand"), "true");
            headerList.add(Headers.create((JAXBRIContext)this.config.getRMVersion().jaxbContext, (Object)usesSequenceSTR));
        }
    }

    private AbstractCreateSequenceResponse unmarshallCreateSequenceResponse(Message response) throws RmException {
        try {
            return (AbstractCreateSequenceResponse)response.readPayloadAsJAXB(this.unmarshaller);
        }
        catch (JAXBException e) {
            throw LOGGER.logSevereException(new RmException("Unable to unmarshall CreateSequenceResponse", e));
        }
    }

    private SequenceElement createLastHeader(OutboundSequence seq) {
        SequenceElement sequenceElement = new SequenceElement();
        sequenceElement.setId(seq.getId());
        sequenceElement.setNumber(seq.getNextIndex());
        sequenceElement.setLastMessage(new SequenceElement.LastMessage());
        return sequenceElement;
    }

    private AbstractAckRequested createAckRequestedElement(OutboundSequence seq) {
        AbstractAckRequested ackRequestedElement = null;
        if (this.config.getRMVersion() == RmVersion.WSRM10) {
            ackRequestedElement = new com.sun.xml.ws.rm.v200502.AckRequestedElement();
            ackRequestedElement.setId(seq.getId());
        } else {
            ackRequestedElement = new AckRequestedElement();
            ackRequestedElement.setId(seq.getId());
        }
        return ackRequestedElement;
    }

    public void sendCloseSequence(OutboundSequence seq) throws RmException {
        Identifier idClose = new Identifier();
        idClose.setValue(seq.getId());
        CloseSequenceElement cs = new CloseSequenceElement();
        cs.setIdentifier(idClose);
        cs.setLastMsgNumber(seq.getNextIndex() - 1);
        Packet requestPacket = new Packet(Messages.create((JAXBRIContext)this.config.getRMVersion().jaxbContext, (Object)cs, (SOAPVersion)this.config.getSoapVersion()));
        requestPacket.proxy = this.proxy;
        requestPacket.contentNegotiation = this.contentNegotiation;
        this.addAddressingHeaders(requestPacket, RmVersion.WSRM11.closeSequenceAction, seq.getDestination(), false);
        seq.setClosed();
        Packet responsePacket = this.process(requestPacket);
        Message response = responsePacket.getMessage();
        if (response.isFault()) {
            throw LOGGER.logException(new CloseSequenceException("CloseSequence was refused by the RMDestination", response), Level.WARNING);
        }
        this.unmarshallCloseSequenceResponse(response);
    }

    private CloseSequenceResponseElement unmarshallCloseSequenceResponse(Message response) throws RmException {
        try {
            return (CloseSequenceResponseElement)response.readPayloadAsJAXB(this.unmarshaller);
        }
        catch (JAXBException e) {
            throw LOGGER.logSevereException(new RmException("Unable to unmarshall CloseSequenceResponse", e));
        }
    }

    private Packet process(Packet request) throws RmException {
        Fiber fiber = this.engine.createFiber();
        Tube tubeline = TubeCloner.clone((Tube)this.nextTube);
        return fiber.runSync(tubeline, request);
    }
}

