/*
 * Decompiled with CFR 0.152.
 */
package com.sun.xml.ws.rm.runtime;

import com.sun.istack.NotNull;
import com.sun.xml.ws.api.message.Packet;
import com.sun.xml.ws.api.pipe.Fiber;
import com.sun.xml.ws.rm.localization.LocalizationMessages;
import com.sun.xml.ws.rm.localization.RmLogger;
import java.util.Queue;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.logging.Level;

final class PeriodicFiberResumeTask
implements Runnable {
    private static final RmLogger LOGGER = RmLogger.getLogger(PeriodicFiberResumeTask.class);
    private final Queue<FiberRegistration> fiberResumeQueue = new ConcurrentLinkedQueue<FiberRegistration>();
    private long resumePeriod;

    PeriodicFiberResumeTask(long period) {
        this.resumePeriod = period;
    }

    public void run() {
        while (!this.fiberResumeQueue.isEmpty() && this.fiberResumeQueue.peek().expired(this.resumePeriod)) {
            FiberRegistration registration = this.fiberResumeQueue.poll();
            registration.fiber.resume(registration.packet);
            if (!LOGGER.isLoggable(Level.FINER)) continue;
            LOGGER.finer(LocalizationMessages.WSRM_1127_FIBER_RESUMED(registration.fiber.toString(), registration.packet.toString()));
        }
    }

    final boolean registerForResume(@NotNull Fiber fiber, Packet packet) {
        return this.fiberResumeQueue.offer(new FiberRegistration(fiber, packet));
    }

    private static class FiberRegistration {
        private final long timestamp = System.currentTimeMillis();
        @NotNull
        final Fiber fiber;
        final Packet packet;

        FiberRegistration(Fiber fiber, Packet packet) {
            this.fiber = fiber;
            this.packet = packet;
        }

        boolean expired(long period) {
            return System.currentTimeMillis() - this.timestamp >= period;
        }
    }
}

