/*
 * Decompiled with CFR 0.152.
 */
package com.sun.xml.ws.tx.common;

import com.sun.xml.ws.api.tx.ATTransaction;
import com.sun.xml.ws.tx.common.ATTransactionImpl;
import com.sun.xml.ws.tx.common.TransactionManagerImpl;
import com.sun.xml.ws.tx.coordinator.CoordinationContextInterface;
import java.util.HashMap;
import java.util.Map;
import javax.transaction.HeuristicMixedException;
import javax.transaction.HeuristicRollbackException;
import javax.transaction.InvalidTransactionException;
import javax.transaction.NotSupportedException;
import javax.transaction.RollbackException;
import javax.transaction.SystemException;
import javax.transaction.Transaction;
import javax.transaction.TransactionManager;
import javax.transaction.TransactionSynchronizationRegistry;

public class ATTransactionManagerImpl
implements TransactionManager {
    private static final ATTransactionManagerImpl singleton = new ATTransactionManagerImpl();
    private final TransactionManager javaeeTM = TransactionManagerImpl.getInstance();
    private final TransactionSynchronizationRegistry javaeeSynchReg = (TransactionSynchronizationRegistry)this.javaeeTM;
    private final Map<String, ATTransaction> coordIdTxnMap = new HashMap<String, ATTransaction>();

    public static ATTransactionManagerImpl getInstance() {
        return singleton;
    }

    public ATTransaction getTransaction(String coordId) {
        return this.coordIdTxnMap.get(coordId);
    }

    private ATTransactionManagerImpl() {
    }

    public void begin() throws NotSupportedException, SystemException {
        this.javaeeTM.begin();
    }

    public void commit() throws RollbackException, HeuristicMixedException, HeuristicRollbackException, SecurityException, IllegalStateException, SystemException {
        this.javaeeTM.commit();
    }

    public int getStatus() throws SystemException {
        throw new UnsupportedOperationException("Not yet implemented");
    }

    public Transaction getTransaction() throws SystemException {
        ATTransaction result = null;
        Transaction jtaTxn = this.javaeeTM.getTransaction();
        if (jtaTxn == null) {
            return result;
        }
        CoordinationContextInterface cc = this.getCoordinationContext();
        if (cc != null && (result = this.getTransaction(cc.getIdentifier())) == null) {
            result = new ATTransactionImpl(jtaTxn, cc);
            this.coordIdTxnMap.put(cc.getIdentifier(), result);
        }
        return result;
    }

    public void resume(Transaction transaction) throws InvalidTransactionException, IllegalStateException, SystemException {
        this.javaeeTM.resume(transaction);
    }

    public void rollback() throws IllegalStateException, SecurityException, SystemException {
        this.javaeeTM.rollback();
    }

    public void setRollbackOnly() throws IllegalStateException {
        this.javaeeSynchReg.setRollbackOnly();
    }

    public void setTransactionTimeout(int seconds) throws SystemException {
        this.javaeeTM.setTransactionTimeout(seconds);
    }

    public Transaction suspend() throws SystemException {
        return this.javaeeTM.suspend();
    }

    public CoordinationContextInterface getCoordinationContext() {
        try {
            return (CoordinationContextInterface)this.javaeeSynchReg.getResource((Object)"WSCOOR-SUN");
        }
        catch (IllegalStateException ise) {
            return null;
        }
    }

    public void setCoordinationContext(CoordinationContextInterface coordinationCtx) {
        this.javaeeSynchReg.putResource((Object)"WSCOOR-SUN", (Object)coordinationCtx);
    }
}

