/*
 * Decompiled with CFR 0.152.
 */
package com.sun.xml.ws.security.impl;

import com.sun.org.apache.xml.internal.security.encryption.EncryptedKey;
import com.sun.org.apache.xml.internal.security.encryption.XMLCipher;
import com.sun.org.apache.xml.internal.security.encryption.XMLEncryptionException;
import com.sun.xml.ws.security.IssuedTokenContext;
import com.sun.xml.ws.security.SecurityContextTokenInfo;
import com.sun.xml.ws.security.Token;
import com.sun.xml.wss.XWSSecurityException;
import java.net.URI;
import java.security.Key;
import java.security.KeyPair;
import java.security.cert.X509Certificate;
import java.util.ArrayList;
import java.util.Date;
import javax.security.auth.Subject;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class IssuedTokenContextImpl
implements IssuedTokenContext {
    X509Certificate x509Certificate = null;
    Token securityToken = null;
    Token associatedProofToken = null;
    Token secTokenReference = null;
    Token unAttachedSecTokenReference = null;
    ArrayList<Object> securityPolicies = new ArrayList();
    Object otherPartyEntropy = null;
    Object selfEntropy = null;
    URI computedKeyAlgorithm;
    byte[] proofKey = null;
    SecurityContextTokenInfo sctInfo = null;
    Date creationTime = null;
    Date expiryTime = null;
    String username = null;
    String endPointAddress = null;
    Subject subject;
    KeyPair proofKeyPair;

    @Override
    public X509Certificate getRequestorCertificate() {
        return this.x509Certificate;
    }

    @Override
    public void setRequestorCertificate(X509Certificate cert) {
        this.x509Certificate = cert;
    }

    @Override
    public Subject getRequestorSubject() {
        return this.subject;
    }

    @Override
    public void setRequestorSubject(Subject subject) {
        this.subject = subject;
    }

    @Override
    public String getRequestorUsername() {
        return this.username;
    }

    @Override
    public void setRequestorUsername(String username) {
        this.username = username;
    }

    @Override
    public void setSecurityToken(Token securityToken) {
        this.securityToken = securityToken;
    }

    @Override
    public Token getSecurityToken() {
        return this.securityToken;
    }

    @Override
    public void setAssociatedProofToken(Token associatedProofToken) {
        this.associatedProofToken = associatedProofToken;
    }

    @Override
    public Token getAssociatedProofToken() {
        return this.associatedProofToken;
    }

    @Override
    public Token getAttachedSecurityTokenReference() {
        return this.secTokenReference;
    }

    @Override
    public void setAttachedSecurityTokenReference(Token secTokenReference) {
        this.secTokenReference = secTokenReference;
    }

    @Override
    public Token getUnAttachedSecurityTokenReference() {
        return this.unAttachedSecTokenReference;
    }

    @Override
    public void setUnAttachedSecurityTokenReference(Token secTokenReference) {
        this.unAttachedSecTokenReference = secTokenReference;
    }

    @Override
    public ArrayList<Object> getSecurityPolicy() {
        return this.securityPolicies;
    }

    @Override
    public void setOtherPartyEntropy(Object otherPartyEntropy) {
        this.otherPartyEntropy = otherPartyEntropy;
    }

    @Override
    public Object getOtherPartyEntropy() {
        return this.otherPartyEntropy;
    }

    @Override
    public Key getDecipheredOtherPartyEntropy(Key privKey) throws XWSSecurityException {
        try {
            return this.getDecipheredOtherPartyEntropy(this.getOtherPartyEntropy(), privKey);
        }
        catch (XMLEncryptionException xee) {
            throw new XWSSecurityException(xee);
        }
    }

    private Key getDecipheredOtherPartyEntropy(Object encryptedKey, Key privKey) throws XMLEncryptionException {
        if (encryptedKey instanceof EncryptedKey) {
            EncryptedKey encKey = (EncryptedKey)encryptedKey;
            XMLCipher cipher = XMLCipher.getInstance();
            cipher.setKEK(privKey);
            cipher.decryptKey(encKey);
            return null;
        }
        return null;
    }

    @Override
    public void setSelfEntropy(Object selfEntropy) {
        this.selfEntropy = selfEntropy;
    }

    @Override
    public Object getSelfEntropy() {
        return this.selfEntropy;
    }

    @Override
    public URI getComputedKeyAlgorithmFromProofToken() {
        return this.computedKeyAlgorithm;
    }

    public void setComputedKeyAlgorithmFromProofToken(URI computedKeyAlgorithm) {
        this.computedKeyAlgorithm = computedKeyAlgorithm;
    }

    @Override
    public void setProofKey(byte[] key) {
        this.proofKey = key;
    }

    @Override
    public byte[] getProofKey() {
        return this.proofKey;
    }

    @Override
    public void setProofKeyPair(KeyPair keys) {
        this.proofKeyPair = keys;
    }

    @Override
    public KeyPair getProofKeyPair() {
        return this.proofKeyPair;
    }

    @Override
    public Date getCreationTime() {
        return this.creationTime;
    }

    @Override
    public Date getExpirationTime() {
        return this.expiryTime;
    }

    @Override
    public void setCreationTime(Date date) {
        this.creationTime = date;
    }

    @Override
    public void setExpirationTime(Date date) {
        this.expiryTime = date;
    }

    @Override
    public void setEndpointAddress(String endPointAddress) {
        this.endPointAddress = endPointAddress;
    }

    @Override
    public String getEndpointAddress() {
        return this.endPointAddress;
    }

    @Override
    public void destroy() {
    }

    @Override
    public SecurityContextTokenInfo getSecurityContextTokenInfo() {
        return this.sctInfo;
    }

    @Override
    public void setSecurityContextTokenInfo(SecurityContextTokenInfo sctInfo) {
        this.sctInfo = sctInfo;
    }
}

