/*
 * Decompiled with CFR 0.152.
 */
package com.swoval.files;

import com.swoval.files.DirectoryRegistryImpl;
import com.swoval.files.Executor;
import com.swoval.files.FileCacheDirectoryTree;
import com.swoval.files.FileCachePathWatcher;
import com.swoval.files.FileTreeDataViews;
import com.swoval.files.FileTreeRepository;
import com.swoval.files.FileTreeRepositoryImpl;
import com.swoval.files.FileTreeViews;
import com.swoval.files.PathWatcher;
import com.swoval.files.PathWatchers;
import com.swoval.files.SymlinkWatcher;
import com.swoval.files.TypedPath;
import com.swoval.functional.Filter;
import com.swoval.logging.Logger;
import com.swoval.logging.Loggers;
import java.io.IOException;

public class FileTreeRepositories {
    private FileTreeRepositories() {
    }

    public static <T> FileTreeRepository<T> get(FileTreeDataViews.Converter<T> converter, boolean bl) throws InterruptedException, IOException {
        return FileTreeRepositories.get(converter, bl, false, Loggers.getLogger());
    }

    public static <T> FileTreeRepository<T> get(FileTreeDataViews.Converter<T> converter, Filter<TypedPath> filter, boolean bl) throws InterruptedException, IOException {
        return FileTreeRepositories.get(converter, filter, bl, false, Loggers.getLogger());
    }

    public static <T> FileTreeRepository<T> get(FileTreeDataViews.Converter<T> converter, boolean bl, boolean bl2, Logger logger) throws InterruptedException, IOException {
        return FileTreeRepositories.get(converter, null, bl, bl2, logger);
    }

    public static <T> FileTreeRepository<T> get(FileTreeDataViews.Converter<T> converter, Filter<TypedPath> filter, boolean bl, boolean bl2, Logger logger) throws InterruptedException, IOException {
        SymlinkWatcher symlinkWatcher = bl ? new SymlinkWatcher(PathWatchers.get(false, new DirectoryRegistryImpl(), logger), logger) : null;
        Executor executor = Executor.make("FileTreeRepository-callback-executor");
        final FileCacheDirectoryTree<T> fileCacheDirectoryTree = new FileCacheDirectoryTree<T>(converter, executor, symlinkWatcher, bl2, logger, filter);
        PathWatcher<PathWatchers.Event> pathWatcher = PathWatchers.get(false, fileCacheDirectoryTree.readOnlyDirectoryRegistry(), logger);
        pathWatcher.addObserver(new FileTreeViews.Observer<PathWatchers.Event>(){

            @Override
            public void onError(Throwable throwable) {
            }

            @Override
            public void onNext(PathWatchers.Event event) {
                fileCacheDirectoryTree.handleEvent(event);
            }
        });
        FileCachePathWatcher<T> fileCachePathWatcher = new FileCachePathWatcher<T>(fileCacheDirectoryTree, pathWatcher);
        return new FileTreeRepositoryImpl<T>(fileCacheDirectoryTree, fileCachePathWatcher);
    }
}

