/*
 * Decompiled with CFR 0.152.
 */
package com.taskadapter.redmineapi;

import com.taskadapter.redmineapi.RedmineException;
import com.taskadapter.redmineapi.bean.Project;
import com.taskadapter.redmineapi.bean.WikiPage;
import com.taskadapter.redmineapi.bean.WikiPageDetail;
import com.taskadapter.redmineapi.internal.RequestParam;
import com.taskadapter.redmineapi.internal.Transport;
import java.util.List;

public class WikiManager {
    private final Transport transport;

    WikiManager(Transport transport) {
        this.transport = transport;
    }

    public List<WikiPage> getWikiPagesByProject(String projectKey) throws RedmineException {
        return this.transport.getChildEntries(Project.class, projectKey, WikiPage.class);
    }

    public WikiPageDetail getWikiPageDetailByProjectAndTitle(String projectKey, String pageTitle) throws RedmineException {
        String urlSafeString = WikiPageDetail.getUrlSafeString(pageTitle);
        WikiPageDetail wikiPageDetail = this.transport.getChildEntry(Project.class, projectKey, WikiPageDetail.class, urlSafeString, new RequestParam("include", "attachments"));
        wikiPageDetail.setProjectKey(projectKey);
        return wikiPageDetail;
    }

    @Deprecated
    public void create(String projectKey, WikiPageDetail detail) throws RedmineException {
        this.update(projectKey, detail);
    }

    @Deprecated
    public void update(String projectKey, WikiPageDetail detail) throws RedmineException {
        String urlSafeTitle = WikiPageDetail.getUrlSafeString(detail.getTitle());
        this.transport.updateChildEntry(Project.class, projectKey, detail, urlSafeTitle, new RequestParam[0]);
    }
}

