/*
 * Decompiled with CFR 0.152.
 */
package com.teradata.jdbc;

import com.teradata.jdbc.TeraConnectionPoolDataSource;
import com.teradata.jdbc.TeraLogicalConnection;
import com.teradata.jdbc.jdbc_4.util.ErrorFactory;
import java.sql.Connection;
import java.sql.SQLException;
import java.util.Vector;
import javax.sql.ConnectionEvent;
import javax.sql.ConnectionEventListener;
import javax.sql.PooledConnection;
import javax.sql.StatementEventListener;

public class TeraPooledConnection
implements PooledConnection {
    protected Connection realConnection = null;
    private TeraConnectionPoolDataSource dataSource = null;
    private TeraLogicalConnection logicalConnection = null;
    private Vector listeners = new Vector(5);
    private boolean isOpen = true;
    private String password;
    private String user;

    public TeraPooledConnection(TeraConnectionPoolDataSource teraConnectionPoolDataSource) {
        this.dataSource = teraConnectionPoolDataSource;
        this.password = teraConnectionPoolDataSource.getpassword();
        this.user = teraConnectionPoolDataSource.getuser();
    }

    public TeraPooledConnection(TeraConnectionPoolDataSource teraConnectionPoolDataSource, String string, String string2) {
        this.dataSource = teraConnectionPoolDataSource;
        this.password = string2;
        this.user = string;
    }

    @Override
    public void addConnectionEventListener(ConnectionEventListener connectionEventListener) {
        this.listeners.add(connectionEventListener);
    }

    @Override
    public void close() throws SQLException {
        if (this.isClosed()) {
            throw ErrorFactory.makeDriverJDBCException("TJ187");
        }
        if (this.logicalConnection != null) {
            this.logicalConnection.setOpenState(false);
            this.logicalConnection = null;
        }
        if (this.realConnection != null) {
            this.realConnection.close();
            this.realConnection = null;
        }
        this.notifyListeners(new ConnectionEvent(this));
        this.setOpenState(false);
    }

    @Override
    public Connection getConnection() throws SQLException {
        if (this.isClosed()) {
            throw ErrorFactory.makeDriverJDBCException("TJ186");
        }
        if (this.logicalConnection != null) {
            this.logicalConnection = null;
        }
        if (this.realConnection == null) {
            this.realConnection = this.dataSource.createNewConnection(this.user, this.password);
        }
        this.logicalConnection = new TeraLogicalConnection(this.dataSource, this, this.realConnection);
        return this.logicalConnection;
    }

    public boolean isClosed() {
        return !this.isOpen;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void notifyListeners(ConnectionEvent connectionEvent) {
        SQLException sQLException = connectionEvent.getSQLException();
        int n = 0;
        Vector vector = this.listeners;
        synchronized (vector) {
            for (ConnectionEventListener connectionEventListener : this.listeners) {
                ++n;
                if (sQLException != null) {
                    connectionEventListener.connectionErrorOccurred(connectionEvent);
                    continue;
                }
                connectionEventListener.connectionClosed(connectionEvent);
            }
        }
    }

    @Override
    public void removeConnectionEventListener(ConnectionEventListener connectionEventListener) {
        this.listeners.remove(connectionEventListener);
    }

    public void setOpenState(boolean bl) {
        this.isOpen = bl;
    }

    @Override
    public void addStatementEventListener(StatementEventListener statementEventListener) {
    }

    @Override
    public void removeStatementEventListener(StatementEventListener statementEventListener) {
    }
}

