/*
 * Decompiled with CFR 0.152.
 */
package com.teradata.jdbc.jdbc.fastexport;

import com.teradata.jdbc.TeraResultSetMetaData;
import com.teradata.jdbc.URLParameters;
import com.teradata.jdbc.Utility;
import com.teradata.jdbc.jdbc.ConnectionFactory;
import com.teradata.jdbc.jdbc.RowFetchController;
import com.teradata.jdbc.jdbc.fastexport.FastExportManagerConnection;
import com.teradata.jdbc.jdbc.fastexport.FastExportPreparedStatement;
import com.teradata.jdbc.jdbc_4.MetaDataList;
import com.teradata.jdbc.jdbc_4.TDPreparedStatement;
import com.teradata.jdbc.jdbc_4.TDResultSet;
import com.teradata.jdbc.jdbc_4.TDSession;
import com.teradata.jdbc.jdbc_4.TDStatement;
import com.teradata.jdbc.jdbc_4.ifsupport.Result;
import com.teradata.jdbc.jdbc_4.ifsupport.Results;
import com.teradata.jdbc.jdbc_4.io.TDPacket;
import com.teradata.jdbc.jdbc_4.statemachine.ActivityAnalyzer;
import com.teradata.jdbc.jdbc_4.util.ErrorFactory;
import java.io.InputStream;
import java.io.Reader;
import java.math.BigDecimal;
import java.net.URL;
import java.sql.Array;
import java.sql.Blob;
import java.sql.Clob;
import java.sql.Connection;
import java.sql.Date;
import java.sql.NClob;
import java.sql.ParameterMetaData;
import java.sql.PreparedStatement;
import java.sql.Ref;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.RowId;
import java.sql.SQLException;
import java.sql.SQLWarning;
import java.sql.SQLXML;
import java.sql.Statement;
import java.sql.Time;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.BitSet;
import java.util.Calendar;

public class FastExportManagerPreparedStatement
implements PreparedStatement,
RowFetchController {
    private FastExportManagerConnection managerCon = null;
    private PreparedStatement appPstmt = null;
    private boolean workloadEnabled = false;
    private boolean noSpoolEnabled = false;
    private TDSession m_controlSession = null;
    private Connection[] fastexportCons = null;
    private boolean fastexporting = false;
    private String machineName = null;
    private String userName = null;
    private String password = null;
    String beginFastExport = null;
    private String selectStmt = null;
    private Results results = null;
    private TDPacket[] resultsPacket = null;
    private Statement controlStmt = null;
    private PreparedStatement controlPstmt = null;
    private Object[] boundParam = new Object[2000];
    private BitSet boundParamColumn = new BitSet(2000);
    private PreparedStatement[] fastexportPrepStmts = null;
    private boolean closed = false;
    private boolean connected = false;
    private SQLWarning sqlWarnings = null;
    private int rowFetchSize;
    private int rowFetchDirection;
    private int maxFetchRows;
    private int maxFetchFieldSize;
    private int blkNumber;
    private int blkNumberLastReceived;
    private int blkNumberLastDeserialized;
    private int stmtNumber;
    private ArrayList rsmdList = new ArrayList();
    private ArrayList blockCountList = new ArrayList();
    private boolean[] fastexportPrepStmtResponseFailed;
    private boolean[] fastexportPrepStmtSkipDeserialize;
    public static final int MAX_COLUMN_COUNT = 2000;
    public static final int DEFAULT_FASTEXPORT_MAX_SESSION_COUNT = 8;

    public FastExportManagerPreparedStatement(FastExportManagerConnection fastExportManagerConnection, String string, String string2, String string3, PreparedStatement preparedStatement) throws SQLException {
        this.managerCon = fastExportManagerConnection;
        this.machineName = string;
        this.userName = string2;
        this.password = string3;
        this.selectStmt = ((TDPreparedStatement)preparedStatement).getOriginalSql();
        this.appPstmt = preparedStatement;
        this.results = new Results(fastExportManagerConnection.getLog());
    }

    protected void abortIfClosed() throws SQLException {
        if (this.managerCon.isClosed()) {
            throw ErrorFactory.makeDriverJDBCException("TJ408");
        }
        if (this.closed) {
            throw ErrorFactory.makeDriverJDBCException("TJ409");
        }
    }

    private void abortIfIndexNotValid(int n) throws SQLException {
        if (n <= 0 || n > 2000) {
            throw ErrorFactory.makeDriverJDBCException("TJ411", n);
        }
    }

    private void saveBoundParam(int n, Object object) throws SQLException {
        this.abortIfIndexNotValid(n);
        this.boundParam[n - 1] = object;
        this.boundParamColumn.set(n - 1);
    }

    private void initializeFastExport() throws SQLException {
        try {
            boolean bl = this.fastexporting;
            if (bl) {
                this.closeFastExport();
            }
            this.connectFastExport();
            if (bl && this.boundParamColumn.length() != 0) {
                for (int i = 0; i < this.boundParamColumn.length(); ++i) {
                    int n;
                    Object object = this.boundParam[i];
                    if (object instanceof TypedNull) {
                        n = ((TypedNull)object).getType();
                        this.controlPstmt.setNull(i + 1, n);
                        continue;
                    }
                    if (object instanceof ObjectWithCalendar) {
                        n = ((ObjectWithCalendar)object).getType();
                        Calendar calendar = ((ObjectWithCalendar)object).getCalendar();
                        if ((object = ((ObjectWithCalendar)object).getObject()) instanceof Time || n == 92) {
                            this.controlPstmt.setTime(i + 1, (Time)object, calendar);
                            continue;
                        }
                        if (!(object instanceof Timestamp) && n != 93) continue;
                        this.controlPstmt.setTimestamp(i + 1, (Timestamp)object, calendar);
                        continue;
                    }
                    if (object instanceof ObjectWithScale) {
                        n = ((ObjectWithScale)object).getType();
                        int n2 = ((ObjectWithScale)object).getScale();
                        object = ((ObjectWithScale)object).getObject();
                        this.controlPstmt.setObject(i + 1, object, n, n2);
                        continue;
                    }
                    if (object instanceof ObjectWithoutScale) {
                        n = ((ObjectWithoutScale)object).getType();
                        object = ((ObjectWithoutScale)object).getObject();
                        this.controlPstmt.setObject(i + 1, object, n);
                        continue;
                    }
                    this.controlPstmt.setObject(i + 1, object);
                }
            }
        }
        catch (SQLException sQLException) {
            SQLException sQLException2 = ErrorFactory.makeDriverJDBCException("TJ574", this.selectStmt);
            sQLException2.setNextException(sQLException);
            throw sQLException2;
        }
    }

    private static SQLException chainSQLExceptions(SQLException sQLException, SQLException sQLException2) {
        return Utility.chainSQLExceptions(sQLException, sQLException2);
    }

    private void chainSQLWarnings(SQLWarning sQLWarning) {
        if (this.sqlWarnings == null) {
            this.sqlWarnings = sQLWarning;
        } else {
            this.sqlWarnings.setNextWarning(sQLWarning);
        }
    }

    private int executeControlCommand(String string, String string2) throws SQLException {
        if (this.m_controlSession.getLog().canLog(1)) {
            this.m_controlSession.getLog().info(string + ": " + string2);
        }
        return this.controlStmt.executeUpdate(string2);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private int getSessionsCount(int n) throws SQLException {
        int n2;
        Object object;
        String string;
        this.workloadEnabled = false;
        String string2 = "";
        String[] stringArray = new String[]{"", ""};
        boolean bl = false;
        try (Statement statement = this.managerCon.createStatement();){
            string = "HELP SESSION";
            if (this.managerCon.getLog().canLog(1)) {
                this.managerCon.getLog().info("FastExportManagerPreparedStatement.getSessionsCount: " + string);
            }
            object = statement.executeQuery(string);
            try {
                if (object.next()) {
                    string2 = Utility.getCurrentDatabaseFromHelpSessionResultSet((ResultSet)object);
                    stringArray = Utility.parseQueryBand(Utility.getQueryBandFromHelpSessionResultSet((ResultSet)object));
                    bl = Utility.getUnicodePassThroughFromHelpSessionResultSet((ResultSet)object);
                }
            }
            finally {
                object.close();
            }
        }
        if (bl) {
            this.executeControlCommand("FastExportManagerPreparedStatement.getSessionsCount", "SET SESSION CHARACTER SET UNICODE PASS THROUGH ON");
        }
        if (string2.length() > 0) {
            this.executeControlCommand("FastExportManagerPreparedStatement.getSessionsCount", "DATABASE \"" + string2.replaceAll("\"", "\"\"") + "\"");
        }
        if (this.m_controlSession.useCheckWorkload()) {
            this.executeControlCommand("FastExportManagerPreparedStatement.getSessionsCount", "SET QUERY_BAND='UtilityName=JDBCE;' FOR SESSION");
            if (stringArray[1].length() > 0) {
                this.executeControlCommand("FastExportManagerPreparedStatement.getSessionsCount", "SET QUERY_BAND='" + stringArray[1] + "' UPDATE FOR SESSION");
            }
            this.executeControlCommand("FastExportManagerPreparedStatement.getSessionsCount", "CHECK WORKLOAD FOR " + this.beginFastExport);
            this.executeControlCommand("FastExportManagerPreparedStatement.getSessionsCount", "CHECK WORKLOAD FOR " + this.selectStmt);
            string = (!this.managerCon.getURLParameters().isGoverned() ? "{fn TERADATA_FAILFAST}" : "") + "CHECK WORKLOAD END";
            if (this.m_controlSession.getLog().canLog(1)) {
                this.m_controlSession.getLog().info("FastExportManagerPreparedStatement.getSessionsCount: " + string);
            }
            object = this.controlStmt.executeQuery(string);
            try {
                ResultSetMetaData resultSetMetaData = object.getMetaData();
                if (object.next() && resultSetMetaData.getColumnCount() >= 2 && object.getString(1) != null) {
                    if (object.getString(1).trim().equalsIgnoreCase("Y")) {
                        int n3 = object.getInt(2);
                        if (n3 > 0) {
                            int n4 = n == 0 ? n3 : Math.min(n, n3);
                            this.workloadEnabled = true;
                            if (n4 < n) {
                                SQLWarning sQLWarning = ErrorFactory.makeSQLWarning("TJ615", String.valueOf(n), String.valueOf(n4), this.selectStmt);
                                this.chainSQLWarnings(sQLWarning);
                            }
                            int n5 = n4;
                            return n5;
                        }
                        this.managerCon.getLog().info("FastExport received no valid AMP count from " + string + ", thus assuming default SESSIONS count.");
                    } else {
                        this.managerCon.getLog().info("FastExport was told to assume default SESSIONS count by " + string + ".");
                    }
                } else {
                    this.managerCon.getLog().info("FastExport received no valid ResultSet from " + string + ", thus assuming default SESSIONS count.");
                }
            }
            finally {
                object.close();
            }
        }
        int n6 = Integer.parseInt(this.m_controlSession.getAMPCount());
        if (n == 0) {
            n2 = Math.min(8, n6);
        } else {
            n2 = Math.min(n, n6);
            if (n2 < n) {
                object = ErrorFactory.makeSQLWarning("TJ616", String.valueOf(n), String.valueOf(n2), this.selectStmt);
                this.chainSQLWarnings((SQLWarning)object);
            }
        }
        return n2;
    }

    private void connectFastExport() throws SQLException {
        if (!this.connected) {
            SQLException sQLException = null;
            int n = 0;
            int n2 = 0;
            int n3 = 0;
            int n4 = 0;
            int n5 = 0;
            try {
                int n6;
                URLParameters uRLParameters = this.managerCon.getURLParameters();
                n3 = uRLParameters.getSessions();
                URLParameters uRLParameters2 = new URLParameters(uRLParameters.getDelegatedParameters() + "," + "TMODE" + "=TERA" + (uRLParameters.isGoverned() || this.managerCon.isFailFastSupported() ? ",LSS_TYPE=E" : "") + "," + "CONNECT_FUNCTION" + "=" + 1);
                this.m_controlSession = (TDSession)ConnectionFactory.createConnection(this.machineName, this.userName, this.password, uRLParameters2);
                n = Integer.parseInt(this.m_controlSession.getAMPCount());
                this.controlStmt = this.m_controlSession.createStatement();
                this.beginFastExport = "BEGIN FASTEXPORT";
                if (this.m_controlSession.getConfigResponse().isFastExportNoSpoolSupported()) {
                    this.beginFastExport = this.beginFastExport + " WITH NO SPOOL";
                }
                n2 = this.getSessionsCount(n3);
                this.controlPstmt = this.m_controlSession.prepareStatement(this.selectStmt);
                TDPreparedStatement tDPreparedStatement = (TDPreparedStatement)this.controlPstmt;
                tDPreparedStatement.setRequestMode((byte)73);
                MetaDataList metaDataList = tDPreparedStatement.getMetaDataList();
                for (int i = 0; i < metaDataList.size(); ++i) {
                    TeraResultSetMetaData teraResultSetMetaData = metaDataList.getMetaDataForStatement(i + 1);
                    if (ActivityAnalyzer.isFastExportCompatible(teraResultSetMetaData.getActivityType())) continue;
                    throw ErrorFactory.makeDriverJDBCException("TJ571");
                }
                URLParameters uRLParameters3 = new URLParameters(uRLParameters.getDelegatedParameters() + (uRLParameters.isGoverned() || this.managerCon.isFailFastSupported() ? ",LSS_TYPE=E" : "") + "," + "PARTITION" + "=" + "EXPORT" + "," + "CONNECT_FUNCTION" + "=" + 2 + "," + "LOGON_SEQUENCE_NUMBER" + "=" + this.m_controlSession.getLogonSequenceNumber());
                this.fastexportCons = new Connection[n2];
                for (n6 = 0; n6 < this.fastexportCons.length; ++n6) {
                    this.fastexportCons[n6] = ConnectionFactory.createConnection(this.machineName, this.userName, this.password, uRLParameters3);
                    ++n4;
                }
                this.resultsPacket = new TDPacket[this.fastexportCons.length];
                for (n6 = 0; n6 < this.resultsPacket.length; ++n6) {
                    this.resultsPacket[n6] = this.m_controlSession.createPacket(1);
                }
                this.fastexportPrepStmts = new PreparedStatement[this.fastexportCons.length];
                for (n6 = 0; n6 < this.fastexportPrepStmts.length; ++n6) {
                    this.fastexportPrepStmts[n6] = this.fastexportCons[n6].prepareStatement(null);
                    ++n5;
                }
                this.managerCon.getLog().info("FastExport found " + n + " AMP(s) in " + this.machineName + " and created " + n4 + (this.workloadEnabled ? " workload" : "") + " FastExportConnection(s) and " + n5 + " FastExportPreparedStatement(s) with SESSIONS=" + n3 + ".");
                this.connected = true;
            }
            catch (SQLException sQLException2) {
                sQLException = FastExportManagerPreparedStatement.chainSQLExceptions(sQLException, sQLException2);
                try {
                    this.closeFastExport();
                }
                catch (SQLException sQLException3) {
                    sQLException = FastExportManagerPreparedStatement.chainSQLExceptions(sQLException, sQLException3);
                }
                SQLException sQLException4 = ErrorFactory.makeDriverJDBCException("TJ575", this.selectStmt, String.valueOf(n), String.valueOf(n4), String.valueOf(n5), String.valueOf(n3));
                sQLException4.setNextException(sQLException);
                throw sQLException4;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void closeFastExport() throws SQLException {
        if (this.connected) {
            SQLException sQLException = null;
            try {
                SQLException sQLException2;
                try {
                    this.endFastExport();
                }
                catch (SQLException sQLException3) {
                    sQLException = FastExportManagerPreparedStatement.chainSQLExceptions(sQLException, sQLException3);
                }
                if (this.fastexportPrepStmts != null) {
                    for (int i = 0; i < this.fastexportPrepStmts.length; ++i) {
                        if (this.fastexportPrepStmts[i] == null) continue;
                        try {
                            this.fastexportPrepStmts[i].close();
                            continue;
                        }
                        catch (SQLException sQLException4) {
                            sQLException2 = ErrorFactory.makeDriverJDBCException("TJ576", i, this.fastexportPrepStmts.length);
                            sQLException = FastExportManagerPreparedStatement.chainSQLExceptions(sQLException, sQLException2);
                            sQLException = FastExportManagerPreparedStatement.chainSQLExceptions(sQLException, sQLException4);
                        }
                    }
                }
                if (this.controlStmt != null) {
                    try {
                        this.controlStmt.close();
                    }
                    catch (SQLException sQLException5) {
                        sQLException = FastExportManagerPreparedStatement.chainSQLExceptions(sQLException, sQLException5);
                    }
                }
                if (this.controlPstmt != null) {
                    try {
                        this.controlPstmt.close();
                    }
                    catch (SQLException sQLException6) {
                        sQLException = FastExportManagerPreparedStatement.chainSQLExceptions(sQLException, sQLException6);
                    }
                }
                if (this.fastexportCons != null) {
                    for (int i = 0; i < this.fastexportCons.length; ++i) {
                        if (this.fastexportCons[i] == null) continue;
                        try {
                            this.fastexportCons[i].close();
                            continue;
                        }
                        catch (SQLException sQLException7) {
                            sQLException2 = ErrorFactory.makeDriverJDBCException("TJ577", i, this.fastexportCons.length);
                            sQLException = FastExportManagerPreparedStatement.chainSQLExceptions(sQLException, sQLException2);
                            sQLException = FastExportManagerPreparedStatement.chainSQLExceptions(sQLException, sQLException7);
                        }
                    }
                }
                if (this.m_controlSession != null) {
                    try {
                        this.m_controlSession.close();
                    }
                    catch (SQLException sQLException8) {
                        sQLException = FastExportManagerPreparedStatement.chainSQLExceptions(sQLException, sQLException8);
                    }
                }
            }
            finally {
                this.connected = false;
                this.resultsPacket = null;
                this.fastexportPrepStmts = null;
                this.controlStmt = null;
                this.controlPstmt = null;
                this.fastexportCons = null;
                this.m_controlSession = null;
            }
            if (sQLException != null) {
                SQLException sQLException9 = ErrorFactory.makeDriverJDBCException("TJ578", this.selectStmt);
                sQLException9.setNextException(sQLException);
                throw sQLException9;
            }
        }
    }

    private void beginFastExport() throws SQLException {
        if (this.connected && !this.fastexporting) {
            SQLException sQLException = null;
            try {
                this.executeControlCommand("FastExportManagerPreparedStatement.beginFastExport", this.beginFastExport);
                if (this.m_controlSession.getLog().canLog(1)) {
                    this.m_controlSession.getLog().info("FastExportManagerPreparedStatement.beginFastExport: " + this.selectStmt);
                }
                this.controlPstmt.execute();
                this.fastexporting = true;
            }
            catch (SQLException sQLException2) {
                sQLException = FastExportManagerPreparedStatement.chainSQLExceptions(sQLException, sQLException2);
            }
            if (sQLException != null) {
                SQLException sQLException3 = ErrorFactory.makeDriverJDBCException("TJ580", this.selectStmt);
                sQLException3.setNextException(sQLException);
                throw sQLException3;
            }
        }
    }

    protected void endFastExport() throws SQLException {
        if (this.connected && this.fastexporting) {
            SQLException sQLException = null;
            try {
                this.receiveResultsPreviouslyRequested();
                this.executeControlCommand("FastExportManagerPreparedStatement.endFastExport", "END FASTEXPORT");
            }
            catch (SQLException sQLException2) {
                sQLException = FastExportManagerPreparedStatement.chainSQLExceptions(sQLException, sQLException2);
            }
            finally {
                this.fastexporting = false;
            }
            if (sQLException != null) {
                SQLException sQLException3 = ErrorFactory.makeDriverJDBCException("TJ581", this.selectStmt);
                sQLException3.setNextException(sQLException);
                throw sQLException3;
            }
        }
    }

    private void clearFastExportParameters() throws SQLException {
        if (this.connected) {
            SQLException sQLException = null;
            for (int i = 0; i < this.fastexportPrepStmts.length; ++i) {
                try {
                    this.fastexportPrepStmts[i].clearParameters();
                    continue;
                }
                catch (SQLException sQLException2) {
                    SQLException sQLException3 = ErrorFactory.makeDriverJDBCException("TJ576", i, this.fastexportPrepStmts.length);
                    sQLException = FastExportManagerPreparedStatement.chainSQLExceptions(sQLException, sQLException3);
                    sQLException = FastExportManagerPreparedStatement.chainSQLExceptions(sQLException, sQLException2);
                }
            }
            if (sQLException != null) {
                SQLException sQLException4 = ErrorFactory.makeDriverJDBCException("TJ584", this.selectStmt);
                sQLException4.setNextException(sQLException);
                throw sQLException4;
            }
        }
    }

    protected String getLogonSequenceNumber() {
        if (this.connected) {
            return this.m_controlSession.getLogonSequenceNumber();
        }
        return "";
    }

    protected boolean isConnected() {
        return this.connected;
    }

    private void receiveResultsPreviouslyRequested() throws SQLException {
        if (this.blkNumber != 0 && this.blkNumber - 1 != this.blkNumberLastReceived) {
            long l = (long)this.stmtNumber << 32;
            int n = (Integer)this.blockCountList.get(this.stmtNumber - 1);
            int n2 = n < this.fastexportPrepStmts.length ? n : this.fastexportPrepStmts.length;
            int n3 = 0;
            while (this.blkNumberLastReceived < n && n3 < n2) {
                if (!this.fastexportPrepStmtResponseFailed[n3]) {
                    try {
                        int n4;
                        ((FastExportPreparedStatement)this.fastexportPrepStmts[n3]).receiveResults(this.resultsPacket[n3]);
                        if (this.resultsPacket[n3].getBuffer().getBuffer().length > 52 && ((n4 = (this.resultsPacket[n3].getBuffer().getBuffer()[52] & 0x7F) << 8 & 0xFF00 | this.resultsPacket[n3].getBuffer().getBuffer()[53] & 0xFF) == 9 || n4 == 49)) {
                            this.fastexportPrepStmtResponseFailed[n3] = true;
                        }
                    }
                    catch (SQLException sQLException) {
                        SQLException sQLException2 = ErrorFactory.makeDriverJDBCException("TJ586", Long.toHexString(l + (long)this.blkNumberLastReceived + 1L), String.valueOf(n), String.valueOf(n3), String.valueOf(this.fastexportPrepStmts.length), String.valueOf(n2));
                        sQLException2.setNextException(sQLException);
                        throw sQLException2;
                    }
                }
                ++n3;
                ++this.blkNumberLastReceived;
            }
        }
    }

    @Override
    public void suppressResponseCancel() {
    }

    @Override
    public void closingResultSet(boolean bl, boolean bl2) throws SQLException {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void fetchRows(TDResultSet tDResultSet, int n, int n2, long l, long l2) throws SQLException {
        block38: {
            SQLException sQLException = null;
            try {
                SQLException sQLException2;
                int n3;
                this.receiveResultsPreviouslyRequested();
                if (this.stmtNumber != n2) {
                    if (this.stmtNumber != 0) {
                        this.clearFastExportParameters();
                    }
                    this.blkNumber = 1;
                    this.blkNumberLastReceived = 0;
                    this.blkNumberLastDeserialized = 0;
                    this.stmtNumber = n2;
                }
                ResultSetMetaData resultSetMetaData = (ResultSetMetaData)this.rsmdList.get(this.stmtNumber - 1);
                long l3 = (long)this.stmtNumber << 32;
                int n4 = (Integer)this.blockCountList.get(this.stmtNumber - 1);
                int n5 = n4 < this.fastexportPrepStmts.length ? n4 : this.fastexportPrepStmts.length;
                boolean[] blArray = new boolean[this.fastexportPrepStmts.length];
                if (this.blkNumber == 1) {
                    this.managerCon.getLog().info("FastExport will use " + n5 + " FastExportPreparedStatement(s) to select data for statement " + this.stmtNumber + " with blkCnt=" + n4 + ".");
                    for (n3 = 0; n3 < n5; ++n3) {
                        this.fastexportPrepStmts[n3].setObject(1, resultSetMetaData);
                        ((FastExportPreparedStatement)this.fastexportPrepStmts[n3]).shareResults(this.results, this.stmtNumber - 1);
                    }
                }
                n3 = 0;
                while (this.blkNumber <= n4 && n3 < n5 && sQLException == null) {
                    if (!this.fastexportPrepStmtResponseFailed[n3]) {
                        try {
                            if (this.noSpoolEnabled) {
                                this.fastexportPrepStmts[n3].setInt(2, this.stmtNumber);
                            } else {
                                this.fastexportPrepStmts[n3].setLong(2, l3 + (long)this.blkNumber);
                            }
                            ((FastExportPreparedStatement)this.fastexportPrepStmts[n3]).requestResults();
                        }
                        catch (SQLException sQLException3) {
                            sQLException2 = ErrorFactory.makeDriverJDBCException("TJ585", Long.toHexString(l3 + (long)this.blkNumber), String.valueOf(n4), String.valueOf(n3), String.valueOf(this.fastexportPrepStmts.length), String.valueOf(n5));
                            sQLException = FastExportManagerPreparedStatement.chainSQLExceptions(sQLException, sQLException2);
                            sQLException = FastExportManagerPreparedStatement.chainSQLExceptions(sQLException, sQLException3);
                            blArray[n3] = true;
                        }
                    }
                    ++n3;
                    ++this.blkNumber;
                }
                if (this.blkNumberLastReceived == 0) {
                    n3 = 0;
                    while (this.blkNumberLastReceived < n4 && n3 < n5) {
                        if (blArray[n3]) {
                            return;
                        }
                        try {
                            int n6;
                            ((FastExportPreparedStatement)this.fastexportPrepStmts[n3]).receiveResults(this.resultsPacket[n3]);
                            if (this.resultsPacket[n3].getBuffer().getBuffer().length > 52 && ((n6 = (this.resultsPacket[n3].getBuffer().getBuffer()[52] & 0x7F) << 8 & 0xFF00 | this.resultsPacket[n3].getBuffer().getBuffer()[53] & 0xFF) == 9 || n6 == 49)) {
                                this.fastexportPrepStmtResponseFailed[n3] = true;
                            }
                        }
                        catch (SQLException sQLException4) {
                            sQLException2 = ErrorFactory.makeDriverJDBCException("TJ586", Long.toHexString(l3 + (long)this.blkNumberLastReceived + 1L), String.valueOf(n4), String.valueOf(n3), String.valueOf(this.fastexportPrepStmts.length), String.valueOf(n5));
                            sQLException = FastExportManagerPreparedStatement.chainSQLExceptions(sQLException, sQLException2);
                            sQLException = FastExportManagerPreparedStatement.chainSQLExceptions(sQLException, sQLException4);
                        }
                        ++n3;
                        ++this.blkNumberLastReceived;
                    }
                    n3 = 0;
                    while (this.blkNumber <= n4 && n3 < n5) {
                        if (sQLException != null) {
                            return;
                        }
                        if (!this.fastexportPrepStmtResponseFailed[n3]) {
                            try {
                                if (this.noSpoolEnabled) {
                                    this.fastexportPrepStmts[n3].setInt(2, this.stmtNumber);
                                } else {
                                    this.fastexportPrepStmts[n3].setLong(2, l3 + (long)this.blkNumber);
                                }
                                ((FastExportPreparedStatement)this.fastexportPrepStmts[n3]).requestResults();
                            }
                            catch (SQLException sQLException5) {
                                sQLException2 = ErrorFactory.makeDriverJDBCException("TJ585", Long.toHexString(l3 + (long)this.blkNumber), String.valueOf(n4), String.valueOf(n3), String.valueOf(this.fastexportPrepStmts.length), String.valueOf(n5));
                                sQLException = FastExportManagerPreparedStatement.chainSQLExceptions(sQLException, sQLException2);
                                sQLException = FastExportManagerPreparedStatement.chainSQLExceptions(sQLException, sQLException5);
                            }
                        }
                        ++n3;
                        ++this.blkNumber;
                    }
                }
                n3 = 0;
                while (this.blkNumberLastDeserialized < n4 && n3 < n5) {
                    if (sQLException != null) {
                        return;
                    }
                    if (!this.fastexportPrepStmtSkipDeserialize[n3]) {
                        try {
                            ((FastExportPreparedStatement)this.fastexportPrepStmts[n3]).deserializeResults(this.resultsPacket[n3]);
                        }
                        catch (SQLException sQLException6) {
                            if (this.noSpoolEnabled && sQLException6.getErrorCode() == 9112) {
                                this.fastexportPrepStmtSkipDeserialize[n3] = true;
                                --this.blkNumber;
                            }
                            sQLException2 = ErrorFactory.makeDriverJDBCException("TJ587", Long.toHexString(l3 + (long)this.blkNumberLastDeserialized + 1L), String.valueOf(n4), String.valueOf(n3), String.valueOf(this.fastexportPrepStmts.length), String.valueOf(n5));
                            sQLException = FastExportManagerPreparedStatement.chainSQLExceptions(sQLException, sQLException2);
                            sQLException = FastExportManagerPreparedStatement.chainSQLExceptions(sQLException, sQLException6);
                        }
                    }
                    ++n3;
                    ++this.blkNumberLastDeserialized;
                }
                if (this.blkNumber - 1 == this.blkNumberLastDeserialized) {
                    this.results.getResult(this.stmtNumber - 1).getResultSet().lastRowFetched();
                }
            }
            catch (SQLException sQLException7) {
                sQLException = FastExportManagerPreparedStatement.chainSQLExceptions(sQLException, sQLException7);
            }
            finally {
                if (sQLException == null) break block38;
                SQLException sQLException8 = ErrorFactory.makeDriverJDBCException("TJ597", this.selectStmt);
                sQLException8.setNextException(sQLException);
                throw sQLException8;
            }
        }
    }

    @Override
    public Object getCloseMutex() {
        return this.managerCon;
    }

    @Override
    public int getCurrentRequestNumber() {
        return -1;
    }

    @Override
    public int getCurrentStatementNumber() {
        return this.results.getResultsSize() + 1;
    }

    @Override
    public int getRowFetchDirection() {
        return this.rowFetchDirection;
    }

    @Override
    public int getRowFetchSize() {
        return this.rowFetchSize;
    }

    @Override
    public int getMaxFetchRows() {
        return this.maxFetchRows;
    }

    @Override
    public int getMaxFetchFieldSize() {
        return this.maxFetchFieldSize;
    }

    @Override
    public boolean registerStatement() {
        return this.fastexporting;
    }

    @Override
    public void unregisterStatement() {
    }

    @Override
    public void addBatch() throws SQLException {
        this.abortIfClosed();
        throw ErrorFactory.makeDriverJDBCException("TJ573");
    }

    @Override
    public void clearParameters() throws SQLException {
        this.abortIfClosed();
        for (int i = 0; i < this.boundParamColumn.length(); ++i) {
            this.boundParam[i] = null;
        }
        this.boundParamColumn.clear();
        this.clearFastExportParameters();
    }

    @Override
    public boolean execute() throws SQLException {
        Object object;
        this.abortIfClosed();
        this.initializeFastExport();
        SQLException sQLException = null;
        try {
            Object object2;
            this.clearWarnings();
            this.results.reinit();
            this.beginFastExport();
            this.rsmdList.clear();
            this.blockCountList.clear();
            do {
                this.rsmdList.add(this.controlPstmt.getMetaData());
                object = this.controlPstmt.getResultSet();
                this.noSpoolEnabled = ActivityAnalyzer.isFastExportWithNoSpool(((TDResultSet)object).getExecuteActivityType());
                if (this.noSpoolEnabled) {
                    this.managerCon.getLog().info("FastExport WITH NO SPOOL is being used for statement " + this.selectStmt);
                    object2 = ErrorFactory.makeSQLWarning("TJ611", this.selectStmt);
                    this.chainSQLWarnings((SQLWarning)object2);
                    this.blockCountList.add(new Integer(0x7FFFFFFE));
                    continue;
                }
                this.blockCountList.add(new Integer(this.controlPstmt.getUpdateCount()));
            } while (this.controlPstmt.getMoreResults() || this.controlPstmt.getUpdateCount() >= 0);
            this.rowFetchSize = this.getFetchSize();
            this.rowFetchDirection = this.getFetchDirection();
            this.maxFetchRows = this.getMaxRows();
            this.maxFetchFieldSize = this.getMaxFieldSize();
            object = (TDPreparedStatement)this.appPstmt;
            object2 = ((TDStatement)object).getMetaDataList();
            for (int i = 0; i < ((MetaDataList)object2).size(); ++i) {
                TDResultSet tDResultSet = this.managerCon.constructResultSet(((MetaDataList)object2).getMetaDataForStatement(i + 1), 1, this, this, this.managerCon.getLog());
                int n = (Integer)this.blockCountList.get(i);
                tDResultSet.setActivityCount(n == 0 ? 0L : 0x7FFFFFFEL);
                this.results.addResult(null, new Result(tDResultSet));
            }
            this.stmtNumber = 0;
            this.blkNumber = 0;
            this.blkNumberLastReceived = 0;
            this.blkNumberLastDeserialized = 0;
            this.fastexportPrepStmtResponseFailed = new boolean[this.fastexportPrepStmts.length];
            this.fastexportPrepStmtSkipDeserialize = new boolean[this.fastexportPrepStmts.length];
            this.fetchRows(null, -1, 1, 0L, 0L);
        }
        catch (SQLException sQLException2) {
            sQLException = FastExportManagerPreparedStatement.chainSQLExceptions(sQLException, sQLException2);
        }
        if (sQLException != null) {
            object = ErrorFactory.makeDriverJDBCException("TJ579", this.selectStmt);
            ((SQLException)object).setNextException(sQLException);
            throw object;
        }
        return true;
    }

    @Override
    public ResultSet executeQuery() throws SQLException {
        this.abortIfClosed();
        TDPreparedStatement tDPreparedStatement = (TDPreparedStatement)this.appPstmt;
        MetaDataList metaDataList = tDPreparedStatement.getMetaDataList();
        if (metaDataList.size() > 1) {
            throw ErrorFactory.makeDriverJDBCException("TJ572", this.selectStmt);
        }
        this.execute();
        return this.getResultSet();
    }

    @Override
    public int executeUpdate() throws SQLException {
        this.abortIfClosed();
        throw ErrorFactory.makeDriverJDBCException("TJ406");
    }

    @Override
    public ResultSetMetaData getMetaData() throws SQLException {
        this.abortIfClosed();
        return this.appPstmt.getMetaData();
    }

    @Override
    public ParameterMetaData getParameterMetaData() throws SQLException {
        this.abortIfClosed();
        return this.appPstmt.getParameterMetaData();
    }

    @Override
    public void setArray(int n, Array array) throws SQLException {
        this.abortIfClosed();
        throw ErrorFactory.makeDriverJDBCException("TJ406");
    }

    @Override
    public void setAsciiStream(int n, InputStream inputStream, int n2) throws SQLException {
        this.abortIfClosed();
        throw ErrorFactory.makeDriverJDBCException("TJ406");
    }

    @Override
    public void setBigDecimal(int n, BigDecimal bigDecimal) throws SQLException {
        this.abortIfClosed();
        if (bigDecimal == null) {
            this.setNull(n, 3);
        } else {
            this.saveBoundParam(n, bigDecimal);
        }
        this.initializeFastExport();
        this.controlPstmt.setBigDecimal(n, bigDecimal);
    }

    @Override
    public void setBinaryStream(int n, InputStream inputStream, int n2) throws SQLException {
        this.abortIfClosed();
        throw ErrorFactory.makeDriverJDBCException("TJ406");
    }

    @Override
    public void setBlob(int n, Blob blob) throws SQLException {
        this.abortIfClosed();
        throw ErrorFactory.makeDriverJDBCException("TJ406");
    }

    @Override
    public void setBoolean(int n, boolean bl) throws SQLException {
        this.abortIfClosed();
        throw ErrorFactory.makeDriverJDBCException("TJ406");
    }

    @Override
    public void setByte(int n, byte by) throws SQLException {
        this.abortIfClosed();
        this.saveBoundParam(n, new Byte(by));
        this.initializeFastExport();
        this.controlPstmt.setByte(n, by);
    }

    @Override
    public void setBytes(int n, byte[] byArray) throws SQLException {
        this.abortIfClosed();
        if (byArray == null) {
            this.setNull(n, -3);
        } else {
            this.saveBoundParam(n, byArray);
        }
        this.initializeFastExport();
        this.controlPstmt.setBytes(n, byArray);
    }

    @Override
    public void setCharacterStream(int n, Reader reader, int n2) throws SQLException {
        this.abortIfClosed();
        throw ErrorFactory.makeDriverJDBCException("TJ406");
    }

    @Override
    public void setClob(int n, Clob clob) throws SQLException {
        this.abortIfClosed();
        throw ErrorFactory.makeDriverJDBCException("TJ406");
    }

    @Override
    public void setDate(int n, Date date) throws SQLException {
        this.setDate(n, date, null);
    }

    @Override
    public void setDate(int n, Date date, Calendar calendar) throws SQLException {
        this.abortIfClosed();
        if (date == null) {
            this.setNull(n, 91);
        } else {
            this.saveBoundParam(n, calendar != null ? TDResultSet.convertDateWithTimeZoneToGMT(n, date, calendar) : date);
        }
        this.initializeFastExport();
        this.controlPstmt.setDate(n, date, calendar);
    }

    @Override
    public void setDouble(int n, double d) throws SQLException {
        this.abortIfClosed();
        this.saveBoundParam(n, new Double(d));
        this.initializeFastExport();
        this.controlPstmt.setDouble(n, d);
    }

    @Override
    public void setFloat(int n, float f) throws SQLException {
        this.abortIfClosed();
        this.saveBoundParam(n, new Float(f));
        this.initializeFastExport();
        this.controlPstmt.setFloat(n, f);
    }

    @Override
    public void setInt(int n, int n2) throws SQLException {
        this.abortIfClosed();
        this.saveBoundParam(n, new Integer(n2));
        this.initializeFastExport();
        this.controlPstmt.setInt(n, n2);
    }

    @Override
    public void setLong(int n, long l) throws SQLException {
        this.abortIfClosed();
        this.saveBoundParam(n, new Long(l));
        this.initializeFastExport();
        this.controlPstmt.setLong(n, l);
    }

    @Override
    public void setNull(int n, int n2) throws SQLException {
        this.abortIfClosed();
        this.saveBoundParam(n, new TypedNull(n2));
        this.initializeFastExport();
        this.controlPstmt.setNull(n, n2);
    }

    @Override
    public void setNull(int n, int n2, String string) throws SQLException {
        this.abortIfClosed();
        throw ErrorFactory.makeDriverJDBCException("TJ406");
    }

    @Override
    public void setObject(int n, Object object) throws SQLException {
        this.abortIfClosed();
        this.saveBoundParam(n, object);
        this.initializeFastExport();
        this.controlPstmt.setObject(n, object);
    }

    @Override
    public void setObject(int n, Object object, int n2) throws SQLException {
        this.abortIfClosed();
        this.saveBoundParam(n, new ObjectWithoutScale(object, n2));
        this.initializeFastExport();
        this.controlPstmt.setObject(n, object, n2);
    }

    @Override
    public void setObject(int n, Object object, int n2, int n3) throws SQLException {
        this.abortIfClosed();
        this.saveBoundParam(n, new ObjectWithScale(object, n2, n3));
        this.initializeFastExport();
        this.controlPstmt.setObject(n, object, n2, n3);
    }

    @Override
    public void setRef(int n, Ref ref) throws SQLException {
        this.abortIfClosed();
        throw ErrorFactory.makeDriverJDBCException("TJ406");
    }

    @Override
    public void setShort(int n, short s) throws SQLException {
        this.abortIfClosed();
        this.saveBoundParam(n, new Short(s));
        this.initializeFastExport();
        this.controlPstmt.setShort(n, s);
    }

    @Override
    public void setString(int n, String string) throws SQLException {
        this.abortIfClosed();
        if (string == null) {
            this.setNull(n, 12);
        } else {
            this.saveBoundParam(n, string);
        }
        this.initializeFastExport();
        this.controlPstmt.setString(n, string);
    }

    @Override
    public void setTime(int n, Time time) throws SQLException {
        this.setTime(n, time, null);
    }

    @Override
    public void setTime(int n, Time time, Calendar calendar) throws SQLException {
        this.abortIfClosed();
        if (time == null && calendar == null) {
            this.setNull(n, 92);
        } else if (time == null && calendar != null) {
            this.saveBoundParam(n, new ObjectWithCalendar(null, calendar, 92));
        } else if (time != null && calendar != null) {
            this.saveBoundParam(n, new ObjectWithCalendar(time, calendar, 92));
        } else if (time != null && calendar == null) {
            this.saveBoundParam(n, time);
        }
        this.initializeFastExport();
        this.controlPstmt.setTime(n, time, calendar);
    }

    @Override
    public void setTimestamp(int n, Timestamp timestamp) throws SQLException {
        this.setTimestamp(n, timestamp, null);
    }

    @Override
    public void setTimestamp(int n, Timestamp timestamp, Calendar calendar) throws SQLException {
        this.abortIfClosed();
        if (timestamp == null && calendar == null) {
            this.setNull(n, 93);
        } else if (timestamp == null && calendar != null) {
            this.saveBoundParam(n, new ObjectWithCalendar(null, calendar, 93));
        } else if (timestamp != null && calendar != null) {
            this.saveBoundParam(n, new ObjectWithCalendar(timestamp, calendar, 93));
        } else if (timestamp != null && calendar == null) {
            this.saveBoundParam(n, timestamp);
        }
        this.initializeFastExport();
        this.controlPstmt.setTimestamp(n, timestamp, calendar);
    }

    @Override
    public void setUnicodeStream(int n, InputStream inputStream, int n2) throws SQLException {
        this.abortIfClosed();
        throw ErrorFactory.makeDriverJDBCException("TJ406");
    }

    @Override
    public void setURL(int n, URL uRL) throws SQLException {
        this.abortIfClosed();
        throw ErrorFactory.makeDriverJDBCException("TJ406");
    }

    @Override
    public void addBatch(String string) throws SQLException {
        this.abortIfClosed();
        throw ErrorFactory.makeDriverJDBCException("TJ407");
    }

    @Override
    public void cancel() throws SQLException {
        this.abortIfClosed();
    }

    @Override
    public void clearBatch() throws SQLException {
        this.abortIfClosed();
        throw ErrorFactory.makeDriverJDBCException("TJ573");
    }

    @Override
    public void clearWarnings() throws SQLException {
        this.abortIfClosed();
        this.sqlWarnings = null;
        if (this.connected) {
            this.controlStmt.clearWarnings();
            this.controlPstmt.clearWarnings();
        }
    }

    @Override
    public void close() throws SQLException {
        SQLException sQLException = null;
        try {
            try {
                this.closeFastExport();
            }
            catch (SQLException sQLException2) {
                sQLException = FastExportManagerPreparedStatement.chainSQLExceptions(sQLException, sQLException2);
            }
            this.appPstmt.close();
        }
        catch (SQLException sQLException3) {
            sQLException = FastExportManagerPreparedStatement.chainSQLExceptions(sQLException, sQLException3);
        }
        finally {
            this.closed = true;
            this.boundParam = null;
            this.boundParamColumn = null;
            this.managerCon.removeStatement(this);
        }
        if (sQLException != null) {
            SQLException sQLException4 = ErrorFactory.makeDriverJDBCException("TJ582", this.selectStmt);
            sQLException4.setNextException(sQLException);
            throw sQLException4;
        }
    }

    @Override
    public boolean execute(String string) throws SQLException {
        this.abortIfClosed();
        throw ErrorFactory.makeDriverJDBCException("TJ407");
    }

    @Override
    public boolean execute(String string, int n) throws SQLException {
        this.abortIfClosed();
        throw ErrorFactory.makeDriverJDBCException("TJ407");
    }

    @Override
    public boolean execute(String string, int[] nArray) throws SQLException {
        this.abortIfClosed();
        throw ErrorFactory.makeDriverJDBCException("TJ407");
    }

    @Override
    public boolean execute(String string, String[] stringArray) throws SQLException {
        this.abortIfClosed();
        throw ErrorFactory.makeDriverJDBCException("TJ407");
    }

    @Override
    public int[] executeBatch() throws SQLException {
        this.abortIfClosed();
        throw ErrorFactory.makeDriverJDBCException("TJ573");
    }

    @Override
    public ResultSet executeQuery(String string) throws SQLException {
        this.abortIfClosed();
        throw ErrorFactory.makeDriverJDBCException("TJ407");
    }

    @Override
    public int executeUpdate(String string) throws SQLException {
        this.abortIfClosed();
        throw ErrorFactory.makeDriverJDBCException("TJ407");
    }

    @Override
    public int executeUpdate(String string, int n) throws SQLException {
        this.abortIfClosed();
        throw ErrorFactory.makeDriverJDBCException("TJ407");
    }

    @Override
    public int executeUpdate(String string, int[] nArray) throws SQLException {
        this.abortIfClosed();
        throw ErrorFactory.makeDriverJDBCException("TJ407");
    }

    @Override
    public int executeUpdate(String string, String[] stringArray) throws SQLException {
        this.abortIfClosed();
        throw ErrorFactory.makeDriverJDBCException("TJ407");
    }

    @Override
    public Connection getConnection() throws SQLException {
        this.abortIfClosed();
        return this.managerCon;
    }

    @Override
    public int getFetchDirection() throws SQLException {
        this.abortIfClosed();
        return this.appPstmt.getFetchDirection();
    }

    @Override
    public int getFetchSize() throws SQLException {
        this.abortIfClosed();
        return this.appPstmt.getFetchSize();
    }

    @Override
    public ResultSet getGeneratedKeys() throws SQLException {
        this.abortIfClosed();
        return this.appPstmt.getGeneratedKeys();
    }

    @Override
    public int getMaxFieldSize() throws SQLException {
        this.abortIfClosed();
        return this.appPstmt.getMaxFieldSize();
    }

    @Override
    public int getMaxRows() throws SQLException {
        this.abortIfClosed();
        return this.appPstmt.getMaxRows();
    }

    @Override
    public boolean getMoreResults() throws SQLException {
        return this.getMoreResults(1);
    }

    @Override
    public boolean getMoreResults(int n) throws SQLException {
        boolean bl;
        this.abortIfClosed();
        if (n != 1) {
            throw ErrorFactory.makeDriverJDBCException("TJ634", n);
        }
        TDPreparedStatement tDPreparedStatement = (TDPreparedStatement)this.appPstmt;
        boolean bl2 = bl = this.results.getResultsSize() == 0 && tDPreparedStatement.getMetaDataList().size() > 0;
        if (bl) {
            return this.appPstmt.getMoreResults(n);
        }
        if (this.results.getResultType() == 2) {
            this.results.getResult().getResultSet().close();
        }
        return this.results.getMoreResults() && this.results.getResultType() == 2;
    }

    @Override
    public int getQueryTimeout() throws SQLException {
        this.abortIfClosed();
        return 0;
    }

    @Override
    public ResultSet getResultSet() throws SQLException {
        this.abortIfClosed();
        if (this.results.getResultType() == 2) {
            TDResultSet tDResultSet = this.results.getResult().getResultSet();
            return tDResultSet;
        }
        return null;
    }

    @Override
    public int getResultSetConcurrency() throws SQLException {
        this.abortIfClosed();
        return this.appPstmt.getResultSetConcurrency();
    }

    @Override
    public int getResultSetHoldability() throws SQLException {
        this.abortIfClosed();
        return this.appPstmt.getResultSetHoldability();
    }

    @Override
    public int getResultSetType() throws SQLException {
        this.abortIfClosed();
        return this.appPstmt.getResultSetType();
    }

    @Override
    public int getUpdateCount() throws SQLException {
        this.abortIfClosed();
        return -1;
    }

    @Override
    public SQLWarning getWarnings() throws SQLException {
        this.abortIfClosed();
        if (this.connected) {
            this.chainSQLWarnings(this.controlStmt.getWarnings());
            this.controlStmt.clearWarnings();
            this.chainSQLWarnings(this.controlPstmt.getWarnings());
            this.controlPstmt.clearWarnings();
        }
        return this.sqlWarnings;
    }

    @Override
    public void setCursorName(String string) throws SQLException {
        this.abortIfClosed();
    }

    @Override
    public void setEscapeProcessing(boolean bl) throws SQLException {
        this.abortIfClosed();
    }

    @Override
    public void setFetchDirection(int n) throws SQLException {
        this.abortIfClosed();
        this.appPstmt.setFetchDirection(n);
    }

    @Override
    public void setFetchSize(int n) throws SQLException {
        this.abortIfClosed();
        this.appPstmt.setFetchSize(n);
    }

    @Override
    public void setMaxFieldSize(int n) throws SQLException {
        this.abortIfClosed();
        this.appPstmt.setMaxFieldSize(n);
    }

    @Override
    public void setMaxRows(int n) throws SQLException {
        this.abortIfClosed();
        this.appPstmt.setMaxRows(n);
    }

    @Override
    public void setQueryTimeout(int n) throws SQLException {
        this.abortIfClosed();
    }

    @Override
    public boolean getFinalizeAutoClose() {
        return this.managerCon.getURLParameters().getFinalizeAutoClose();
    }

    @Override
    public boolean isClosed() throws SQLException {
        return this.closed;
    }

    @Override
    public boolean isPoolable() throws SQLException {
        this.abortIfClosed();
        return true;
    }

    @Override
    public void setPoolable(boolean bl) throws SQLException {
        this.abortIfClosed();
    }

    @Override
    public void setAsciiStream(int n, InputStream inputStream) throws SQLException {
        this.abortIfClosed();
        throw ErrorFactory.makeDriverJDBCException("TJ726", "setAsciiStream(int,InputStream)");
    }

    @Override
    public void setAsciiStream(int n, InputStream inputStream, long l) throws SQLException {
        this.abortIfClosed();
        throw ErrorFactory.makeDriverJDBCException("TJ726", "setAsciiStream(int,InputStream,long)");
    }

    @Override
    public void setBinaryStream(int n, InputStream inputStream) throws SQLException {
        this.abortIfClosed();
        throw ErrorFactory.makeDriverJDBCException("TJ726", "setBinaryStream(int,InputStream");
    }

    @Override
    public void setBinaryStream(int n, InputStream inputStream, long l) throws SQLException {
        this.abortIfClosed();
        throw ErrorFactory.makeDriverJDBCException("TJ726", "setBinaryStream(int,InputStream,long)");
    }

    @Override
    public void setBlob(int n, InputStream inputStream) throws SQLException {
        this.abortIfClosed();
        throw ErrorFactory.makeDriverJDBCException("TJ726", "setBlob(int,InputStream");
    }

    @Override
    public void setBlob(int n, InputStream inputStream, long l) throws SQLException {
        this.abortIfClosed();
        throw ErrorFactory.makeDriverJDBCException("TJ726", "setBlob(int,InputStream,long)");
    }

    @Override
    public void setCharacterStream(int n, Reader reader) throws SQLException {
        this.abortIfClosed();
        throw ErrorFactory.makeDriverJDBCException("TJ726", "setCharacterStream(int,Reader)");
    }

    @Override
    public void setCharacterStream(int n, Reader reader, long l) throws SQLException {
        this.abortIfClosed();
        throw ErrorFactory.makeDriverJDBCException("TJ726", "setCharacterStream(int,Reader,long)");
    }

    @Override
    public void setClob(int n, Reader reader) throws SQLException {
        this.abortIfClosed();
        throw ErrorFactory.makeDriverJDBCException("TJ726", "setClob(int,Reader)");
    }

    @Override
    public void setClob(int n, Reader reader, long l) throws SQLException {
        this.abortIfClosed();
        throw ErrorFactory.makeDriverJDBCException("TJ726", "setClob(int,Reader,long)");
    }

    @Override
    public void setNCharacterStream(int n, Reader reader) throws SQLException {
        this.abortIfClosed();
        throw ErrorFactory.makeDriverJDBCException("TJ726", "setNCharacterStream(int,Reader)");
    }

    @Override
    public void setNCharacterStream(int n, Reader reader, long l) throws SQLException {
        this.abortIfClosed();
        throw ErrorFactory.makeDriverJDBCException("TJ726", "setNCharacterStream(int,Reader,long)");
    }

    @Override
    public void setNClob(int n, Reader reader) throws SQLException {
        this.abortIfClosed();
        throw ErrorFactory.makeDriverJDBCException("TJ726", "setNClob(int,Reader)");
    }

    @Override
    public void setNClob(int n, Reader reader, long l) throws SQLException {
        this.abortIfClosed();
        throw ErrorFactory.makeDriverJDBCException("TJ726", "setNClob(int,Reader,long)");
    }

    @Override
    public void setNString(int n, String string) throws SQLException {
        this.abortIfClosed();
        throw ErrorFactory.makeDriverJDBCException("TJ406");
    }

    @Override
    public void closeOnCompletion() throws SQLException {
    }

    @Override
    public boolean isCloseOnCompletion() throws SQLException {
        return false;
    }

    @Override
    public void setNClob(int n, NClob nClob) throws SQLException {
        this.abortIfClosed();
        throw ErrorFactory.makeDriverJDBCException("TJ726", "setNClob(int,NClob)");
    }

    @Override
    public void setRowId(int n, RowId rowId) throws SQLException {
        this.abortIfClosed();
        throw ErrorFactory.makeDriverJDBCException("TJ406");
    }

    @Override
    public void setSQLXML(int n, SQLXML sQLXML) throws SQLException {
        this.abortIfClosed();
        throw ErrorFactory.makeDriverJDBCException("TJ406");
    }

    @Override
    public <T> T unwrap(Class<T> clazz) throws SQLException {
        throw ErrorFactory.makeDriverJDBCException("TJ733");
    }

    @Override
    public boolean isWrapperFor(Class<?> clazz) throws SQLException {
        return false;
    }

    private static class ObjectWithCalendar {
        private Object obj;
        private Calendar cal;
        private int type;

        public ObjectWithCalendar(Object object, Calendar calendar, int n) {
            this.obj = object;
            this.cal = calendar;
            this.type = n;
        }

        public Object getObject() {
            return this.obj;
        }

        public Calendar getCalendar() {
            return this.cal;
        }

        public int getType() {
            return this.type;
        }
    }

    private static class ObjectWithoutScale {
        private Object obj;
        private int type;

        public ObjectWithoutScale(Object object, int n) {
            this.obj = object;
            this.type = n;
        }

        public Object getObject() {
            return this.obj;
        }

        public int getType() {
            return this.type;
        }
    }

    private static class ObjectWithScale {
        private Object obj;
        private int type;
        private int scale;

        public ObjectWithScale(Object object, int n, int n2) {
            this.obj = object;
            this.type = n;
            this.scale = n2;
        }

        public Object getObject() {
            return this.obj;
        }

        public int getType() {
            return this.type;
        }

        public int getScale() {
            return this.scale;
        }
    }

    private static class TypedNull {
        private int type;

        public TypedNull(int n) {
            this.type = n;
        }

        public int getType() {
            return this.type;
        }
    }
}

