/*
 * Decompiled with CFR 0.152.
 */
package com.teradata.jdbc.jdbc_4.util;

import com.teradata.jdbc.Const;
import com.teradata.jdbc.ErrorMessage;
import com.teradata.jdbc.jdbc_4.io.TDNetworkIOIF;
import com.teradata.jdbc.jdbc_4.logging.Log;
import com.teradata.jdbc.jdbc_4.util.Errors;
import com.teradata.jdbc.jdbc_4.util.TDDataTruncation;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.io.Writer;
import java.sql.BatchUpdateException;
import java.sql.ClientInfoStatus;
import java.sql.SQLClientInfoException;
import java.sql.SQLException;
import java.sql.SQLWarning;
import java.util.Date;
import java.util.LinkedHashMap;
import java.util.Properties;

public class ErrorFactory {
    private static final String TERAJDBC_VERSION = " [TeraJDBC " + Const.DRIVER_VERSION + "]";
    private static final String DBMS_ERROR = "[Teradata Database]" + TERAJDBC_VERSION;
    private static final String DRIVER_ERROR = "[Teradata JDBC Driver]" + TERAJDBC_VERSION;

    private ErrorFactory() {
    }

    private static String formatExceptionMessage(String string, String string2, String string3, int n, String string4, String string5, String string6, String string7, String string8) {
        string2 = String.valueOf(string2);
        return string + " [Error " + n + "] [SQLState " + string3 + "] " + ErrorMessage.Format5(string2, string4, string5, string6, string7, string8);
    }

    public static SQLException makeDriverJDBCException(String string) {
        return ErrorFactory.makeDriverJDBCException(string, null, null, null, null, null);
    }

    public static SQLException makeDriverJDBCException(String string, String string2) {
        return ErrorFactory.makeDriverJDBCException(string, string2, null, null, null, null);
    }

    public static SQLException makeDriverJDBCException(String string, String string2, String string3) {
        return ErrorFactory.makeDriverJDBCException(string, string2, string3, null, null, null);
    }

    public static SQLException makeDriverJDBCException(String string, String string2, String string3, String string4) {
        return ErrorFactory.makeDriverJDBCException(string, string2, string3, string4, null, null);
    }

    public static SQLException makeDriverJDBCException(String string, String string2, String string3, String string4, String string5) {
        return ErrorFactory.makeDriverJDBCException(string, string2, string3, string4, string5, null);
    }

    public static SQLException makeDriverJDBCException(String string, String string2, String string3, String string4, String string5, String string6) {
        String string7 = ErrorMessage.messages.getString(string);
        Errors.ErrorDescriptor errorDescriptor = Errors.getErrorDescriptor(string);
        int n = errorDescriptor.getCode();
        String string8 = Errors.getSQLState(n);
        string7 = ErrorFactory.formatExceptionMessage(DRIVER_ERROR, string7, string8, n, string2, string3, string4, string5, string6);
        return new SQLException(string7, string8, n);
    }

    public static SQLException makeDriverJDBCException(String string, int n) {
        return ErrorFactory.makeDriverJDBCException(string, Integer.toString(n));
    }

    public static SQLException makeDriverJDBCException(String string, int n, int n2) {
        return ErrorFactory.makeDriverJDBCException(string, Integer.toString(n), Integer.toString(n2));
    }

    public static SQLException makeDriverJDBCException(String string, int n, int n2, int n3) {
        return ErrorFactory.makeDriverJDBCException(string, Integer.toString(n), Integer.toString(n2), Integer.toString(n3));
    }

    public static SQLException makeDriverJDBCException(String string, int n, int n2, int n3, int n4) {
        return ErrorFactory.makeDriverJDBCException(string, Integer.toString(n), Integer.toString(n2), Integer.toString(n3), Integer.toString(n4));
    }

    public static SQLException makeDriverJDBCException(String string, int n, int n2, int n3, int n4, int n5) {
        return ErrorFactory.makeDriverJDBCException(string, Integer.toString(n), Integer.toString(n2), Integer.toString(n3), Integer.toString(n4), Integer.toString(n5));
    }

    public static BatchUpdateException convertToBatchUpdateException(SQLException sQLException, int[] nArray) {
        BatchUpdateException batchUpdateException = new BatchUpdateException(sQLException.getMessage(), sQLException.getSQLState(), sQLException.getErrorCode(), nArray);
        batchUpdateException.setNextException(sQLException);
        batchUpdateException.initCause(sQLException);
        return batchUpdateException;
    }

    public static BatchUpdateException makeBatchUpdateException(String string, int[] nArray) {
        return ErrorFactory.makeBatchUpdateException(string, nArray, null, null, null, null, null, null);
    }

    public static BatchUpdateException makeBatchUpdateException(String string, int[] nArray, String string2) {
        return ErrorFactory.makeBatchUpdateException(string, nArray, null, string2, null, null, null, null);
    }

    public static BatchUpdateException makeBatchUpdateException(String string, SQLException sQLException, int[] nArray) {
        return ErrorFactory.makeBatchUpdateException(string, nArray, sQLException, null, null, null, null, null);
    }

    public static BatchUpdateException makeBatchUpdateException(String string, int[] nArray, SQLException sQLException, String string2, String string3, String string4, String string5, String string6) {
        String string7 = ErrorMessage.messages.getString(string);
        Errors.ErrorDescriptor errorDescriptor = Errors.getErrorDescriptor(string);
        int n = errorDescriptor.getCode();
        String string8 = Errors.getSQLState(n);
        string7 = ErrorFactory.formatExceptionMessage(DRIVER_ERROR, string7, string8, n, string2, string3, string4, string5, string6);
        BatchUpdateException batchUpdateException = new BatchUpdateException(string7, string8, n, nArray);
        if (sQLException != null) {
            batchUpdateException.setNextException(sQLException);
            batchUpdateException.initCause(sQLException);
        }
        return batchUpdateException;
    }

    public static SQLException makeChainedBatchJDBCException(SQLException sQLException, SQLException sQLException2, int n, int n2) {
        SQLException sQLException3 = n == 1 ? sQLException2 : sQLException;
        for (int i = 2; i <= n2; ++i) {
            sQLException3.setNextException(n == i ? sQLException2 : ErrorFactory.cloneJDBCException(sQLException, 1));
        }
        return sQLException3;
    }

    public static SQLException cloneJDBCException(SQLException sQLException, int n) {
        return new SQLException(sQLException.getMessage(), sQLException.getSQLState(), sQLException.getErrorCode() * n);
    }

    public static SQLException makeIoJDBCException(String string, String string2, TDNetworkIOIF tDNetworkIOIF, Throwable throwable, Log log) {
        return ErrorFactory.makeIoJDBCException(string, string2, tDNetworkIOIF, throwable, log, true);
    }

    public static SQLException makeIoJDBCException(String string, String string2, TDNetworkIOIF tDNetworkIOIF, Throwable throwable, Log log, boolean bl) {
        StringWriter stringWriter = new StringWriter();
        if (throwable != null) {
            throwable.printStackTrace(new PrintWriter((Writer)stringWriter, true));
        }
        StringBuffer stringBuffer = new StringBuffer(string2 + " " + new Date() + " " + tDNetworkIOIF + " " + stringWriter);
        for (int i = 0; i < stringBuffer.length(); ++i) {
            char c = stringBuffer.charAt(i);
            if (c != '\t' && c != '\r' && c != '\n') continue;
            stringBuffer.setCharAt(i, ' ');
        }
        String string3 = stringBuffer.toString();
        if (log != null) {
            if (bl) {
                log.error(string3);
            } else {
                log.info(string3);
            }
        }
        SQLException sQLException = ErrorFactory.makeDriverJDBCException(string, string3);
        sQLException.initCause(throwable);
        return sQLException;
    }

    public static TDDataTruncation makeTDDataTruncation(String string, int n, boolean bl, boolean bl2, int n2, int n3, int n4) {
        String string2 = ErrorMessage.messages.getString(string);
        Errors.ErrorDescriptor errorDescriptor = Errors.getErrorDescriptor(string);
        int n5 = errorDescriptor.getCode();
        String string3 = Errors.getSQLState(n5);
        string2 = ErrorFactory.formatExceptionMessage(DRIVER_ERROR, string2, string3, n5, Integer.toString(n2), Integer.toString(n), Integer.toString(n4), Integer.toString(n3), null);
        return new TDDataTruncation(string2, string3, n5, n, bl, bl2, n2, n3);
    }

    public static TDDataTruncation makeTDDataTruncation(String string, int n, boolean bl, boolean bl2, int n2, int n3) {
        String string2 = ErrorMessage.messages.getString(string);
        Errors.ErrorDescriptor errorDescriptor = Errors.getErrorDescriptor(string);
        int n4 = errorDescriptor.getCode();
        String string3 = Errors.getSQLState(n4);
        string2 = ErrorFactory.formatExceptionMessage(DRIVER_ERROR, string2, string3, n4, Integer.toString(n2), Integer.toString(n), Integer.toString(n3), null, null);
        return new TDDataTruncation(string2, string3, n4, n, bl, bl2, n2, n3);
    }

    public static SQLWarning makeSQLWarning(String string) {
        return ErrorFactory.makeSQLWarning(string, null, null, null, null, null);
    }

    public static SQLWarning makeSQLWarning(String string, String string2) {
        return ErrorFactory.makeSQLWarning(string, string2, null, null, null, null);
    }

    public static SQLWarning makeSQLWarning(String string, String string2, String string3) {
        return ErrorFactory.makeSQLWarning(string, string2, string3, null, null, null);
    }

    public static SQLWarning makeSQLWarning(String string, String string2, String string3, String string4) {
        return ErrorFactory.makeSQLWarning(string, string2, string3, string4, null, null);
    }

    public static SQLWarning makeSQLWarning(String string, String string2, String string3, String string4, String string5) {
        return ErrorFactory.makeSQLWarning(string, string2, string3, string4, string5, null);
    }

    public static SQLWarning makeSQLWarning(String string, String string2, String string3, String string4, String string5, String string6) {
        String string7 = ErrorMessage.messages.getString(string);
        Errors.ErrorDescriptor errorDescriptor = Errors.getErrorDescriptor(string);
        int n = errorDescriptor.getCode();
        String string8 = Errors.getSQLState(n);
        string7 = ErrorFactory.formatExceptionMessage(DRIVER_ERROR, string7, string8, n, string2, string3, string4, string5, string6);
        return new SQLWarning(string7, string8, n);
    }

    public static SQLWarning makeDatabaseSQLWarning(String string, int n) {
        String string2 = Errors.getSQLState(n);
        string = ErrorFactory.formatExceptionMessage(DBMS_ERROR, string, string2, n, null, null, null, null, null);
        return new SQLWarning(string, string2, n);
    }

    public static SQLException makeDatabaseSQLException(String string, int n) {
        String string2 = Errors.getSQLState(n);
        string = ErrorFactory.formatExceptionMessage(DBMS_ERROR, string, string2, n, null, null, null, null, null);
        return new SQLException(string, string2, n);
    }

    public static SQLException makeDatabaseSQLException(String string, int n, int n2) {
        String string2 = Errors.getSQLState(n, n2);
        string = ErrorFactory.formatExceptionMessage(DBMS_ERROR, string, string2, n, null, null, null, null, null);
        return new SQLException(string, string2, n);
    }

    public static SQLException makeErrorCodeOnlyDatabaseSQLException(int n, String string, String string2, String string3) {
        String string4 = ErrorMessage.messages.getString(string);
        String string5 = Errors.getSQLState(n);
        string4 = ErrorFactory.formatExceptionMessage(DBMS_ERROR, string4, string5, n, string2, string3, null, null, null);
        return new SQLException(string4, string5, n);
    }

    public static SQLWarning makeSQLWarning(String string, int n) {
        return ErrorFactory.makeSQLWarning(string, Integer.toString(n));
    }

    public static SQLWarning makeSQLWarning(String string, int n, int n2) {
        return ErrorFactory.makeSQLWarning(string, Integer.toString(n), Integer.toString(n2));
    }

    public static SQLWarning makeSQLWarning(String string, int n, int n2, int n3) {
        return ErrorFactory.makeSQLWarning(string, Integer.toString(n), Integer.toString(n2), Integer.toString(n3));
    }

    public static SQLWarning makeSQLWarning(String string, int n, int n2, int n3, int n4) {
        return ErrorFactory.makeSQLWarning(string, Integer.toString(n), Integer.toString(n2), Integer.toString(n3), Integer.toString(n4));
    }

    public static SQLWarning makeSQLWarning(String string, int n, int n2, int n3, int n4, int n5) {
        return ErrorFactory.makeSQLWarning(string, Integer.toString(n), Integer.toString(n2), Integer.toString(n3), Integer.toString(n4), Integer.toString(n5));
    }

    public static SQLClientInfoException makeSQLClientInfoException(SQLException sQLException, String string, Properties properties) {
        Object object;
        LinkedHashMap<String, ClientInfoStatus> linkedHashMap = new LinkedHashMap<String, ClientInfoStatus>();
        if (properties != null) {
            object = ClientInfoStatus.REASON_UNKNOWN;
            if (sQLException != null) {
                switch (sQLException.getErrorCode()) {
                    case 5992: 
                    case 5993: 
                    case 5994: 
                    case 5995: 
                    case 5996: {
                        object = ClientInfoStatus.REASON_VALUE_INVALID;
                    }
                }
            }
            for (String string2 : properties.stringPropertyNames()) {
                linkedHashMap.put(string2, (ClientInfoStatus)((Object)object));
            }
        }
        object = null;
        if (sQLException != null) {
            object = new SQLClientInfoException(sQLException.getMessage(), sQLException.getSQLState(), sQLException.getErrorCode(), linkedHashMap, sQLException);
        } else if (string != null) {
            String string2;
            int n = Errors.getErrorDescriptor(string).getCode();
            string2 = Errors.getSQLState(n);
            String string3 = ErrorFactory.formatExceptionMessage(DRIVER_ERROR, ErrorMessage.messages.getString(string), string2, n, null, null, null, null, null);
            object = new SQLClientInfoException(string3, string2, n, linkedHashMap);
        }
        return object;
    }
}

