/*
 * Decompiled with CFR 0.152.
 */
package com.thimbleware.jmemcached.storage.mmap;

import com.thimbleware.jmemcached.storage.bytebuffer.BlockStoreFactory;
import com.thimbleware.jmemcached.storage.bytebuffer.ByteBufferBlockStore;
import java.io.File;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.nio.ByteBuffer;
import java.nio.MappedByteBuffer;
import java.nio.channels.FileChannel;
import org.jboss.netty.buffer.ChannelBuffers;

public final class MemoryMappedBlockStore
extends ByteBufferBlockStore {
    private File physicalFile;
    private RandomAccessFile fileStorage;
    private static final MemoryMappedBlockStoreFactory MEMORY_MAPPED_BLOCK_STORE_FACTORY = new MemoryMappedBlockStoreFactory();

    private MemoryMappedBlockStore(long maxBytes, File file, int blockSizeBytes) throws IOException {
        super(blockSizeBytes);
        this.storageBuffer = ChannelBuffers.wrappedBuffer((ByteBuffer)this.getMemoryMappedFileStorage(maxBytes, file));
        this.initialize(this.storageBuffer.capacity());
    }

    public static BlockStoreFactory getFactory() {
        return MEMORY_MAPPED_BLOCK_STORE_FACTORY;
    }

    private MappedByteBuffer getMemoryMappedFileStorage(long maxBytes, File file) throws IOException {
        this.physicalFile = file;
        this.fileStorage = new RandomAccessFile(file, "rw");
        this.fileStorage.seek(maxBytes);
        return this.fileStorage.getChannel().map(FileChannel.MapMode.PRIVATE, 0L, maxBytes);
    }

    protected void freeResources() throws IOException {
        super.freeResources();
        this.fileStorage.close();
        this.physicalFile.delete();
        this.physicalFile = null;
        this.fileStorage = null;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class MemoryMappedBlockStoreFactory
    implements BlockStoreFactory<MemoryMappedBlockStore> {
        @Override
        public MemoryMappedBlockStore manufacture(long sizeBytes, int blockSizeBytes) {
            try {
                File tempFile = File.createTempFile("jmemcached", "blockStore");
                tempFile.deleteOnExit();
                return new MemoryMappedBlockStore(sizeBytes, tempFile, blockSizeBytes);
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        }
    }
}

