/*
 * Decompiled with CFR 0.152.
 */
package com.tictactec.ta.lib.meta;

import com.tictactec.ta.lib.Core;
import com.tictactec.ta.lib.MInteger;
import com.tictactec.ta.lib.RetCode;
import com.tictactec.ta.lib.meta.TaFuncSignature;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;

public class TaFuncMetaInfo
extends TaFuncSignature {
    Method method;
    Method lookbackMethod;
    Class[] outVarTypes;
    Class[] optionTypes;
    Class[] parameterTypes;
    static final int TOTAL_FIX_PARAMETERS = 4;
    static final int INPUT_FIX_PARAMETERS = 2;
    static final int OUTPUT_FIX_PARAMETERS = 2;

    public TaFuncMetaInfo(String name, Method method, Method lookbackMethod) {
        this.name = name;
        this.method = method;
        this.lookbackMethod = lookbackMethod;
        this.optionTypes = lookbackMethod.getParameterTypes();
        this.parameterTypes = method.getParameterTypes();
        int ins = this.getNumberOfInputParameters();
        int outs = this.getNumberOfOutputParameters();
        this.createVarTypes(ins, outs);
    }

    int getNumberOfInputParameters() {
        return this.getFirstMInteger() - this.optionTypes.length - 2;
    }

    int getNumberOfOutputParameters() {
        return this.parameterTypes.length - this.getFirstMInteger() - 2;
    }

    int getFirstMInteger() {
        for (int i = 0; i < this.parameterTypes.length; ++i) {
            if (!this.parameterTypes[i].equals(MInteger.class)) continue;
            return i;
        }
        return -1;
    }

    void createVarTypes(int ins, int outs) {
        assert (ins > 0 && outs > 0);
        this.inVarTypes = new Class[ins];
        this.outVarTypes = new Class[outs];
        for (int i = 0; i < ins; ++i) {
            this.inVarTypes[i] = this.parameterTypes[2 + i];
        }
        int offset = 2 + ins + this.optionTypes.length + 2;
        for (int i = 0; i < outs; ++i) {
            this.outVarTypes[i] = this.parameterTypes[offset + i];
        }
    }

    public Class[] getInVarTypes() {
        return this.inVarTypes;
    }

    public Method getLookbackMethod() {
        return this.lookbackMethod;
    }

    public Method getMethod() {
        return this.method;
    }

    public String getName() {
        return this.name;
    }

    public Class[] getOptionTypes() {
        return this.optionTypes;
    }

    public Class[] getOutVarTypes() {
        return this.outVarTypes;
    }

    public boolean is11() {
        return this.inVarTypes.length == 1 && this.outVarTypes.length == 1;
    }

    public boolean is1N() {
        return this.inVarTypes.length == 1 && this.outVarTypes.length > 1;
    }

    public boolean isN1() {
        return this.inVarTypes.length > 1 && this.outVarTypes.length == 1;
    }

    public boolean isNN() {
        return this.inVarTypes.length > 1 && this.outVarTypes.length > 1;
    }

    public RetCode call(Core taCore, Object[] inArs, int startIndex, int endIndex, Object[] outArs, MInteger outBegIdx, MInteger outNbElement, Object ... options) throws IllegalArgumentException, IllegalAccessException, InvocationTargetException {
        Object[] parameters = new Object[inArs.length + outArs.length + options.length + 4];
        parameters[0] = startIndex;
        parameters[1] = endIndex;
        int i = 2;
        for (int j = 0; j < this.inVarTypes.length; ++j) {
            parameters[i++] = inArs[j];
        }
        for (Object opt : options) {
            parameters[i++] = opt;
        }
        parameters[i++] = outBegIdx;
        parameters[i++] = outNbElement;
        for (int j = 0; j < this.outVarTypes.length; ++j) {
            parameters[i++] = outArs[j];
        }
        return (RetCode)((Object)this.getMethod().invoke((Object)taCore, parameters));
    }

    public int callLookback(Core taCore, Object ... options) throws IllegalArgumentException, IllegalAccessException, InvocationTargetException {
        System.out.println(this.getLookbackMethod());
        return (Integer)this.getLookbackMethod().invoke((Object)taCore, options);
    }

    public String toString() {
        int i;
        StringBuffer sb = new StringBuffer();
        sb.append(this.name + "[");
        sb.append(this.inVarTypes.length);
        sb.append(":");
        sb.append(this.outVarTypes.length);
        sb.append("]");
        sb.append("IN:(");
        for (i = 0; i < this.inVarTypes.length; ++i) {
            sb.append(this.inVarTypes[i].getName());
            if (i >= this.inVarTypes.length - 1) continue;
            sb.append(",");
        }
        sb.append(") OUT(");
        for (i = 0; i < this.outVarTypes.length; ++i) {
            sb.append(this.outVarTypes[i].getName());
            if (i >= this.outVarTypes.length - 1) continue;
            sb.append(",");
        }
        sb.append(")");
        return sb.toString();
    }
}

