/*
 * Decompiled with CFR 0.152.
 */
package com.tngtech.java.junit.dataprovider;

import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.junit.runner.Description;
import org.junit.runner.manipulation.Filter;

public class DataProviderFilter
extends Filter {
    static final Pattern DESCRIPTION_PATTERN = Pattern.compile("([^\\[\\] ]+)(\\[(\\d+):.*\\])?\\((.+)\\)$");
    private static final int GROUP_METHOD_NAME = 1;
    private static final int GROUP_METHOD_PARAMS = 2;
    private static final int GROUP_METHOD_IDX = 3;
    private static final int GROUP_CLASS = 4;
    private final String filterDescription;
    private final Matcher filterDescriptionMatcher;

    public DataProviderFilter(Filter filter) {
        if (filter == null) {
            throw new NullPointerException("supplied filter must not be null");
        }
        this.filterDescription = filter.describe();
        this.filterDescriptionMatcher = DESCRIPTION_PATTERN.matcher(this.filterDescription);
        if (!this.filterDescriptionMatcher.find()) {
            throw new IllegalArgumentException(String.format("Filter %s with description %s is not supported by %s.", filter.getClass(), this.filterDescription, ((Object)((Object)this)).getClass().getSimpleName()));
        }
    }

    public boolean shouldRun(Description description) {
        if (description.isTest()) {
            Matcher descriptionMatcher = DESCRIPTION_PATTERN.matcher(description.getDisplayName());
            if (!descriptionMatcher.matches()) {
                throw new IllegalArgumentException(String.format("Test method description %s is not suppored by %s.", this.filterDescription, ((Object)((Object)this)).getClass().getSimpleName()));
            }
            if (!this.filterDescriptionMatcher.group(1).equals(descriptionMatcher.group(1)) || !this.filterDescriptionMatcher.group(4).equals(descriptionMatcher.group(4))) {
                return false;
            }
            return this.filterDescriptionMatcher.group(2) == null || this.filterDescriptionMatcher.group(3).equals(descriptionMatcher.group(3));
        }
        for (Description each : description.getChildren()) {
            if (!this.shouldRun(each)) continue;
            return true;
        }
        return false;
    }

    public String describe() {
        return this.filterDescription;
    }
}

