/*
 * Decompiled with CFR 0.152.
 */
package com.totsp.mavenplugin.gwt.support;

import com.totsp.mavenplugin.gwt.support.ExitException;
import com.totsp.mavenplugin.gwt.support.GwtWebInfProcessor;
import org.apache.commons.cli.CommandLine;
import org.apache.commons.cli.GnuParser;
import org.apache.commons.cli.HelpFormatter;
import org.apache.commons.cli.Option;
import org.apache.commons.cli.OptionBuilder;
import org.apache.commons.cli.Options;
import org.apache.commons.cli.ParseException;

public class Main {
    private static HelpFormatter formatter = new HelpFormatter();
    private static Option helpOpt = new Option("help", "print this message");
    private static Option moduleNameOpt;
    private static Option targetWebXmlPath;
    private static Option webXmlFilePathOpt;
    private static Options options;

    private Main() {
    }

    public static void main(String[] args) {
        GnuParser parser = new GnuParser();
        try {
            CommandLine line = parser.parse(options, args);
            if (line == null || line.getOptions() == null || line.getOptions().length == 0 || line.hasOption("help")) {
                formatter.printHelp("GwtWebInfProcessor", options);
            } else if (line.hasOption("moduleName") && line.hasOption("targetWebXmlPath") && line.hasOption("webXmlPath")) {
                try {
                    GwtWebInfProcessor processor = new GwtWebInfProcessor(line.getOptionValue("moduleName"), line.getOptionValue("targetWebXmlPath"), line.getOptionValue("webXmlPath"), false);
                    processor.process();
                }
                catch (ExitException ee) {
                    ee.printStackTrace();
                    System.exit(0);
                }
                catch (Exception e) {
                    e.printStackTrace();
                    System.exit(1);
                }
            } else {
                formatter.printHelp("GwtWebInfProcessor", options);
            }
        }
        catch (ParseException exp) {
            exp.printStackTrace();
            System.err.println("Parsing failed.  Reason: " + exp.getMessage());
        }
    }

    static {
        OptionBuilder.withArgName((String)"moduleName");
        OptionBuilder.hasArg();
        OptionBuilder.withDescription((String)"specify GWT module name (complete, com.mystuff.module.Module)");
        moduleNameOpt = OptionBuilder.create((String)"moduleName");
        OptionBuilder.withArgName((String)"targetWebXmlPath");
        OptionBuilder.hasArg();
        OptionBuilder.withDescription((String)"specify the output file to write to (${maven.war.webapp.dir}/WEB-INF/web.xml)");
        targetWebXmlPath = OptionBuilder.create((String)"targetWebXmlPath");
        OptionBuilder.withArgName((String)"webXmlPath");
        OptionBuilder.hasArg();
        OptionBuilder.withDescription((String)"src web.xml file (maven.war.src/WEB-INF/web.xml)");
        webXmlFilePathOpt = OptionBuilder.create((String)"webXmlPath");
        options = new Options();
        options.addOption(helpOpt);
        options.addOption(moduleNameOpt);
        options.addOption(targetWebXmlPath);
        options.addOption(webXmlFilePathOpt);
    }
}

