/*
 * Decompiled with CFR 0.152.
 */
package com.totsp.mavenplugin.gwt.support.beans;

import com.totsp.mavenplugin.gwt.support.beans.Bean;
import com.totsp.mavenplugin.gwt.support.beans.BeanGeneratorBase;
import java.io.File;
import org.apache.commons.cli.CommandLine;
import org.apache.commons.cli.GnuParser;
import org.apache.commons.cli.HelpFormatter;
import org.apache.commons.cli.Option;
import org.apache.commons.cli.OptionBuilder;
import org.apache.commons.cli.Options;

public class GWTBeanGenerator
extends BeanGeneratorBase {
    private static final HelpFormatter formatter = new HelpFormatter();
    private static final Option helpOpt = new Option("help", "print this message");
    private static final Option startBean;
    private static final Option destinationPackage;
    private static final Option destinationDirectory;
    private static final Option withGetSet;
    private static final Option withPropertyChangeSupport;
    private static final Option overWrite;
    private static final Options options;

    public static void main(String[] args) throws Exception {
        GnuParser parser = new GnuParser();
        CommandLine line = parser.parse(options, args);
        if (line == null || line.getOptions() == null || line.getOptions().length == 0 || line.hasOption("help")) {
            formatter.printHelp("GWTBeanGenerator", options);
        }
        Class<?> startBean = Class.forName(line.getOptionValue("startBean"));
        File directory = new File(line.getOptionValue("destinationDirectory"));
        directory.mkdirs();
        Bean root = new Bean(startBean);
        String packageName = line.getOptionValue("destinationPackage");
        String packagePath = packageName.replace('.', File.separatorChar);
        File packageDirectory = new File(directory, packagePath);
        packageDirectory.mkdirs();
        boolean getSet = line.hasOption("withGetSet");
        boolean propertyChangeSupport = line.hasOption("withPropertyChangeSupport");
        GWTBeanGenerator.writeBean(packageName, packageDirectory, getSet, propertyChangeSupport, line.hasOption("overwrite"), root);
    }

    static {
        OptionBuilder.withArgName((String)"startBean");
        OptionBuilder.hasArg();
        OptionBuilder.withDescription((String)"bean to begin mapping from");
        startBean = OptionBuilder.create((String)"startBean");
        OptionBuilder.withArgName((String)"destinationPackage");
        OptionBuilder.hasArg();
        OptionBuilder.withDescription((String)"package to put generated beans into");
        destinationPackage = OptionBuilder.create((String)"destinationPackage");
        OptionBuilder.withArgName((String)"destinationDirectory");
        OptionBuilder.hasArg();
        OptionBuilder.withDescription((String)"directory to put generated java files into");
        destinationDirectory = OptionBuilder.create((String)"destinationDirectory");
        withGetSet = new Option("withGetSet", "create getters and setters for GWT classes");
        withPropertyChangeSupport = new Option("withPropertyChangeSupport", "create change events for beans (implies withGetSet)");
        overWrite = new Option("overwrite", "if there are existing files, this will overwrite them");
        options = new Options();
        options.addOption(helpOpt);
        options.addOption(startBean);
        options.addOption(destinationPackage);
        options.addOption(destinationDirectory);
        options.addOption(withPropertyChangeSupport);
        options.addOption(withGetSet);
        options.addOption(overWrite);
    }
}

